/*
 * Decompiled with CFR 0.152.
 */
package com.se.gui;

import com.nokia.mid.ui.DeviceControl;
import com.se.bean.Ball;
import com.se.bean.Point;
import com.se.bean.ScoreDisplay;
import com.se.bean.Target;
import com.se.manager.Frame;
import com.se.manager.GameInfo;
import com.se.manager.GoalTimeBar;
import com.se.manager.ItemManager;
import com.se.manager.PopupDisplay;
import com.se.manager.SplashScreen;
import com.se.manager.TimeDisplay;
import com.se.mms.SendScreenshot;
import com.se.util.AccSensor;
import com.se.util.Cheat;
import com.se.util.Common;
import com.se.util.Config;
import com.se.util.ItemProperty;
import com.se.util.Logger;
import com.se.util.Sound;
import com.se.util.Vibration;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.midlet.MIDlet;

public class GamePlay
extends Canvas
implements Runnable {
    private Logger log = new Logger(class$com$se$gui$GamePlay == null ? (class$com$se$gui$GamePlay = GamePlay.class$("com.se.gui.GamePlay")) : class$com$se$gui$GamePlay);
    private AccSensor m_objAS;
    private Thread m_objThread;
    private LayerManager m_objLM = new LayerManager();
    private Ball m_objBall;
    private Target m_objT;
    private ItemManager m_objItemMan;
    private ScoreDisplay m_objScore;
    private TimeDisplay m_objTimer;
    private GoalTimeBar m_objGoalTimeBar;
    private GameInfo m_objGameInfo;
    private PopupDisplay m_objPopupDisplay;
    private Image m_imgBG;
    private String m_strBGpath = "/com/se/res/gp_bg.png";
    private Image m_imgScreenshot;
    private Image m_imgBuffer = Image.createImage((int)this.getWidth(), (int)Config.getScreen_RIGHT());
    private Graphics m_gBuffer = this.m_imgBuffer.getGraphics();
    static /* synthetic */ Class class$com$se$gui$GamePlay;

    public GamePlay() throws IOException {
        int i;
        this.m_objGameInfo = new GameInfo();
        this.m_objBall = new Ball();
        this.m_objT = new Target();
        this.m_objItemMan = new ItemManager(this.m_objLM);
        this.m_objItemMan.setItemsInterval(Config.getItemsInterval());
        this.m_objGoalTimeBar = new GoalTimeBar(3000L);
        this.log.debug("creating ScoreDisplay");
        this.m_objScore = new ScoreDisplay(Config.getScoreSize(), new Point(Config.getScore_X(), Config.getScore_Y()));
        this.log.debug("creating TimeDisplay");
        this.m_objTimer = new TimeDisplay(Config.getTimeMin(), Config.getTimeSec(), new Point(Config.getTimeDisplay_X(), Config.getTimeDisplay_Y()));
        this.m_objPopupDisplay = new PopupDisplay();
        this.log.debug("creating Background-Image");
        this.m_imgBG = Image.createImage((String)this.m_strBGpath);
        this.m_objLM.append((Layer)this.m_objBall.getSprite());
        this.m_objLM.append((Layer)this.m_objT.getSprite());
        Sprite[] arrSpriteScore = this.m_objScore.getSprites();
        Sprite[] arrSpriteTime = this.m_objTimer.getSprites();
        for (i = 0; i < arrSpriteScore.length; ++i) {
            this.m_objLM.append((Layer)arrSpriteScore[i]);
        }
        for (i = 0; i < arrSpriteTime.length; ++i) {
            this.m_objLM.append((Layer)arrSpriteTime[i]);
        }
        this.log.debug("init von AccSensor");
        this.m_objAS = new AccSensor();
        this.log.debug("Thread starten");
        this.m_objThread = new Thread(this);
        this.m_objThread.start();
        Config.gamePause();
    }

    protected void keyPressed(int keyCode) {
        this.log.debug("KEY_CODE: '" + keyCode + "");
        if (Cheat.doGoal(keyCode)) {
            for (int i = 0; i < 20; ++i) {
                this.m_objScore.increment();
            }
        }
        switch (keyCode) {
            case -6: {
                if (SplashScreen.isSendHighScore()) {
                    SplashScreen.setSendHighScore(false);
                    SplashScreen.setSendingHS(false);
                    SplashScreen.setGameOverSend(false);
                    SplashScreen.setGameOver(true);
                    this.repaint();
                    break;
                }
                if (SplashScreen.isGamePause()) {
                    SplashScreen.setGamePause(false);
                    Config.gameResume();
                    break;
                }
                if (!SplashScreen.isGameOver()) break;
                Config.gamePause();
                this.resetGame();
                Sound.play(0);
                Display.getDisplay((MIDlet)Frame.SOCCER).setCurrent((Displayable)Frame.MAIN_MENU);
                break;
            }
            case -7: 
            case -5: {
                if (SplashScreen.isSendHighScore()) {
                    SplashScreen.setSendHighScore(false);
                    SplashScreen.setGameOverSend(true);
                    this.log.debug("screenshot wird erstellt");
                    SplashScreen.setSendingHS(true);
                    new SendScreenshot(this.m_imgBuffer, this.m_objScore.getScore());
                    break;
                }
                if (SplashScreen.isGamePause()) {
                    this.resetGame();
                    Sound.play(0);
                    Display.getDisplay((MIDlet)Frame.SOCCER).setCurrent((Displayable)Frame.MAIN_MENU);
                    break;
                }
                if (!SplashScreen.isGameOver()) break;
                this.resetGame();
                Sound.play(1);
                Config.gameResume();
                break;
            }
            case -8: {
                if (SplashScreen.isGameOver()) break;
                Config.gamePause();
                SplashScreen.setGamePause(true);
                this.repaint();
                break;
            }
            case 42: {
                this.log.debug("screenshot wird erstellt");
                SplashScreen.setSendingHS(true);
                new SendScreenshot(this.m_imgBuffer, this.m_objScore.getScore());
                break;
            }
            default: {
                this.log.info("Key not defined ...");
            }
        }
    }

    public void run() {
        try {
            while (true) {
                if (Config.isGameRunning()) {
                    this.m_objTimer.startTimer();
                    if (Common.isTimerZero(this.m_objTimer.getTime())) {
                        this.refreshFrames();
                        this.log.debug("time:=" + Common.formatTime(this.m_objTimer.getTime()));
                        Config.gamePause();
                        Sound.play(2);
                        this.createScreenshot();
                        if (this.m_objScore.getScore() > Config.getMinScoreForUpload()) {
                            SplashScreen.setSendHighScore(true);
                        } else {
                            SplashScreen.setGameOver(true);
                        }
                        this.repaint();
                    } else {
                        this.m_objBall.calcPos(this.getWidth(), this.getHeight(), this.m_objAS.getAxis());
                        this.calcInTarget();
                        ItemProperty objIP = this.ballHitsItem();
                        if (objIP != null) {
                            this.m_objPopupDisplay.showPopup(objIP.getType(), objIP.getX(), objIP.getY());
                        }
                        DeviceControl.setLights((int)0, (int)1);
                        this.refreshFrames();
                        this.repaint();
                    }
                } else {
                    this.m_objTimer.stopTimer();
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            this.log.debug("InterruptException:=" + e.toString());
            try {
                this.m_objAS.destroy();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    public void paint(Graphics g) {
        this.drawBackground(g);
        this.m_objLM.paint(g, 0, 0);
        this.m_objT.drawRing(g);
        this.m_objGoalTimeBar.drawGoalBar(g);
        this.m_objGameInfo.drawStatus(g);
        this.m_objPopupDisplay.drawPopups(g);
        SplashScreen.GamePause_Show(g);
        SplashScreen.GameOver_Show(g);
        SplashScreen.SendingHS_Show(g);
        SplashScreen.GameOverSend_Show(g);
        SplashScreen.SendHighScore_Show(g);
    }

    public Image getScreenShot() {
        return this.m_imgScreenshot;
    }

    private void createScreenshot() {
        this.drawBackground(this.m_gBuffer);
        this.m_objLM.paint(this.m_gBuffer, 0, 0);
        this.m_objT.drawRing(this.m_gBuffer);
        this.m_objGoalTimeBar.drawGoalBar(this.m_gBuffer);
        this.m_objGameInfo.drawStatus(this.m_gBuffer);
        SplashScreen.GamePause_Show(this.m_gBuffer);
        SplashScreen.GameOver_Show(this.m_gBuffer);
    }

    private ItemProperty ballHitsItem() {
        ItemProperty objIP = this.m_objItemMan.isColWithItem(this.m_objBall.getSprite());
        if (objIP == null) {
            return null;
        }
        switch (objIP.getType()) {
            case 1: {
                this.m_objGameInfo.addGravityStage();
                this.m_objBall.setGravityStage(this.m_objGameInfo.getGravityStage());
                this.log.debug("G++ --> Gravity Stage :" + this.m_objGameInfo.getGravityStage());
                objIP.setType(2);
                break;
            }
            case 4: {
                this.m_objGameInfo.minusGravityStage();
                this.m_objBall.setGravityStage(this.m_objGameInfo.getGravityStage());
                this.log.debug("G-- --> Gravity Stage :" + this.m_objGameInfo.getGravityStage());
                objIP.setType(3);
                break;
            }
            case 2: {
                this.m_objGameInfo.addTargetStage();
                this.m_objT.incrementSize();
                this.log.debug("Targ++ --> Target Stage :" + this.m_objT.getActSize());
                objIP.setType(4);
                break;
            }
            case 5: {
                this.m_objGameInfo.minusTargetStage();
                this.m_objT.decrementSize();
                this.log.debug("Targ-- --> Target Stage :" + this.m_objT.getActSize());
                objIP.setType(5);
                break;
            }
            case 3: {
                objIP.setType(0);
                this.m_objTimer.freeze(5);
                this.log.debug("T++ --> Time Plus :");
                break;
            }
            case 6: {
                objIP.setType(1);
                this.m_objBall.freeze(3);
                this.log.debug("T-- --> Time Minus :");
            }
        }
        Vibration.doit();
        return objIP;
    }

    private void calcInTarget() {
        if (this.m_objT.isInTarget(this.m_objBall.getSprite()) > 0) {
            if (this.m_objGoalTimeBar.getState() == -1) {
                this.log.debug("state:=" + this.m_objGoalTimeBar.getState());
                this.m_objScore.increment();
                this.m_objGoalTimeBar.reset();
                this.m_objT.generateNext();
                Vibration.doit();
            } else {
                this.m_objGoalTimeBar.start();
            }
        } else {
            this.m_objGoalTimeBar.stop();
        }
    }

    private void drawBackground(Graphics g) {
        g.drawImage(this.m_imgBG, 0, 0, 20);
    }

    private void refreshFrames() {
        this.m_objBall.refresh();
        this.m_objT.refresh();
        this.m_objTimer.refresh();
        this.m_objItemMan.nextFrame();
    }

    private void resetGame() {
        this.m_imgScreenshot = null;
        this.m_objBall.reset();
        this.m_objT.reset();
        this.m_objTimer.reset();
        SplashScreen.setGameOver(false);
        SplashScreen.setGamePause(false);
        this.m_objScore.reset();
        this.m_objItemMan.reset();
        this.m_objGameInfo.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

