/*
 * Decompiled with CFR 0.152.
 */
package com.se.mms;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public final class BMPGenerator {
    public static byte[] encodeBMP(Image image) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgb = new int[height * width];
        image.getRGB(rgb, 0, width, 0, 0, width, height);
        return BMPGenerator.encodeBMP(rgb, width, height);
    }

    public static byte[] encodeBMP(int[] rgb, int width, int height) throws IOException {
        int pad = (4 - width % 4) % 4;
        int size = 54 + height * (pad + width * 3);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(size);
        DataOutputStream stream = new DataOutputStream(bytes);
        stream.writeByte(66);
        stream.writeByte(77);
        stream.writeInt(BMPGenerator.swapEndian(size));
        stream.writeInt(0);
        stream.writeInt(BMPGenerator.swapEndian(54));
        stream.writeInt(BMPGenerator.swapEndian(40));
        stream.writeInt(BMPGenerator.swapEndian(width));
        stream.writeInt(BMPGenerator.swapEndian(height));
        stream.writeShort(BMPGenerator.swapEndian((short)1));
        stream.writeShort(BMPGenerator.swapEndian((short)24));
        stream.writeInt(0);
        stream.writeInt(0);
        stream.writeInt(0);
        stream.writeInt(0);
        stream.writeInt(0);
        stream.writeInt(0);
        for (int j = height - 1; j >= 0; --j) {
            int i;
            for (i = 0; i < width; ++i) {
                int val = rgb[i + width * j];
                stream.writeByte(val & 0xFF);
                stream.writeByte(val >>> 8 & 0xFF);
                stream.writeByte(val >>> 16 & 0xFF);
            }
            for (i = 0; i < pad; ++i) {
                stream.writeByte(0);
            }
        }
        byte[] out = bytes.toByteArray();
        bytes.close();
        if (out.length != size) {
            throw new RuntimeException("bad math");
        }
        return out;
    }

    private static int swapEndian(int value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }

    private static short swapEndian(short value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        return (short)(b1 << 8 | b2 << 0);
    }
}

