/*
 * Decompiled with CFR 0.152.
 */
package com.se.util;

import com.se.util.Logger;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class MyPlayer {
    private Logger log = new Logger(class$com$se$util$MyPlayer == null ? (class$com$se$util$MyPlayer = MyPlayer.class$("com.se.util.MyPlayer")) : class$com$se$util$MyPlayer);
    private boolean m_bON_OFF;
    private String[] m_arrSounds;
    private String[] m_arrSoundTypes;
    private String m_strPath = "/com/se/res/sound/";
    private Player[] m_objPlayer;
    static /* synthetic */ Class class$com$se$util$MyPlayer;

    public MyPlayer(String[] pArrSounds, String[] pArrSoundType) {
        this(pArrSounds, pArrSoundType, null);
    }

    public MyPlayer(String[] pArrSounds, String[] pArrSoundType, String p_strPath) {
        this.m_arrSounds = pArrSounds;
        this.m_arrSoundTypes = pArrSoundType;
        this.m_bON_OFF = true;
        if (p_strPath != null) {
            this.m_strPath = p_strPath;
        }
        this.load();
    }

    public void on_off() {
        this.m_bON_OFF = !this.m_bON_OFF;
        try {
            for (int iPos = 0; iPos < this.m_objPlayer.length; ++iPos) {
                if (this.m_bON_OFF) {
                    this.m_objPlayer[0].start();
                    continue;
                }
                this.m_objPlayer[0].stop();
            }
        }
        catch (MediaException ex) {
            this.log.error("on_off:=" + ex.toString());
        }
    }

    public void destroy() {
        try {
            int iSoundCount = this.m_arrSounds.length;
            for (int iPos = 0; iPos < iSoundCount; ++iPos) {
                this.m_objPlayer[iPos].stop();
                this.m_objPlayer[iPos] = null;
            }
        }
        catch (MediaException ex) {
            this.log.error("destroy:=" + ex.toString());
        }
    }

    private void load() {
        try {
            int iSoundCount = this.m_arrSounds.length;
            this.m_objPlayer = new Player[iSoundCount];
            for (int iPos = 0; iPos < iSoundCount; ++iPos) {
                InputStream m_objIS = this.getClass().getResourceAsStream(this.m_strPath + this.m_arrSounds[iPos]);
                this.m_objPlayer[iPos] = Manager.createPlayer((InputStream)m_objIS, (String)this.m_arrSoundTypes[iPos]);
                this.m_objPlayer[iPos].realize();
                if (iPos == 0 || iPos == 1) {
                    this.m_objPlayer[iPos].setLoopCount(-1);
                }
                this.m_objPlayer[iPos].prefetch();
                this.m_objPlayer[iPos].stop();
            }
        }
        catch (Throwable t) {
            this.log.error("load:=" + t.toString());
        }
    }

    public void play(int pSound) {
        if (!this.m_bON_OFF) {
            return;
        }
        try {
            if (pSound > this.m_objPlayer.length) {
                throw new IllegalAccessException("Es gibt keinen Sound an der Stelle " + pSound + "(max=" + this.m_objPlayer.length + ")");
            }
            for (int i = 0; i < this.m_objPlayer.length; ++i) {
                this.pause(i);
            }
            this.m_objPlayer[pSound].start();
        }
        catch (Throwable t) {
            this.log.error("play:=" + t.toString());
        }
    }

    public void pause(int pSound) {
        this.stop(pSound);
    }

    public void resume(int pSound) {
        try {
            this.m_objPlayer[pSound].start();
        }
        catch (Throwable t) {
            this.log.error("resume:=" + t.toString());
        }
    }

    public void stop(int pSound) {
        try {
            this.m_objPlayer[pSound].stop();
        }
        catch (Throwable t) {
            this.log.error("stop:=" + t.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

