/*
 * Decompiled with CFR 0.152.
 */
package com.se.util;

import com.se.util.AccSensor;
import com.se.util.Config;

public class Physics {
    private double m_iFRICTION = 0.01;
    private double m_iBOUNCE_FRICTION = 0.15;
    private double m_iACCELERATION_DIVIDER = 10000.0;
    private double m_iSpeedX = 0.0;
    private double m_iSpeedY = 0.0;
    private double m_iSpeedZ = 0.0;
    private double m_iAccelX = 0.0;
    private double m_iAccelY = 0.0;
    private double m_iAccelZ = 0.0;

    public void accelerate(AccSensor.Axis pAxis) {
        this.m_iAccelY = (double)pAxis.getY() / this.m_iACCELERATION_DIVIDER;
        this.m_iAccelX = -((double)pAxis.getX() / this.m_iACCELERATION_DIVIDER);
        this.m_iAccelZ = -((double)pAxis.getX() / this.m_iACCELERATION_DIVIDER);
    }

    public int getSpeed() {
        if (this.m_iSpeedX < 1.0 || this.m_iSpeedY < 1.0) {
            return 5;
        }
        if (this.m_iSpeedX < 4.0 || this.m_iSpeedY < 4.0) {
            return 8;
        }
        if (this.m_iSpeedX < 7.0 || this.m_iSpeedY < 7.0) {
            return 10;
        }
        return 15;
    }

    public void recalculate() {
        this.m_iSpeedY += this.m_iAccelY * Config.getGravity();
        this.m_iSpeedX += this.m_iAccelX * Config.getGravity();
        this.m_iSpeedZ += this.m_iAccelZ * Config.getGravity();
        this.m_iSpeedY -= this.m_iSpeedY * this.m_iFRICTION;
        this.m_iSpeedX -= this.m_iSpeedX * this.m_iFRICTION;
    }

    public void setFrictionX() {
        this.m_iSpeedX = -(this.m_iSpeedX - this.m_iSpeedX * this.m_iBOUNCE_FRICTION);
    }

    public void setFrictionY() {
        this.m_iSpeedY = -(this.m_iSpeedY - this.m_iSpeedY * this.m_iBOUNCE_FRICTION);
    }

    public void setSpeedX(double iSpeed) {
        this.m_iSpeedX = iSpeed;
    }

    public void setSpeedY(double iSpeed) {
        this.m_iSpeedY = iSpeed;
    }

    public void setSpeedZ(double iSpeed) {
        this.m_iSpeedZ = iSpeed;
    }

    public double getSpeedX() {
        return this.m_iSpeedX;
    }

    public double getSpeedY() {
        return this.m_iSpeedY;
    }

    public double getSpeedZ() {
        return this.m_iSpeedZ;
    }

    public double getGravity() {
        return this.m_iACCELERATION_DIVIDER;
    }

    public void setGravity(double GRAVITY_ACCELERATOR) {
        this.m_iACCELERATION_DIVIDER = GRAVITY_ACCELERATOR;
    }
}

