/*
 * Decompiled with CFR 0.152.
 */
package com.se.manager;

import com.se.bean.Item;
import com.se.bean.Point;
import com.se.bean.Rectangle;
import com.se.util.Config;
import com.se.util.ItemProperty;
import com.se.util.Logger;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class ItemManager
extends TimerTask {
    public static final int m_iSize = 4;
    private LayerManager m_objLayerManager;
    private Item[] m_objItems = new Item[24];
    private int[] m_arrActItems = new int[4];
    private String m_sGravityPlus = "/com/se/res/items/gravity_3frames_1stage_plus.png";
    private String m_sGravityMinus = "/com/se/res/items/gravity_3frames_1stage_minus.png";
    private String m_sTargetPlus = "/com/se/res/items/target_3frames_1stage_plus.png";
    private String m_sTargetMinus = "/com/se/res/items/target_3frames_1stage_minus.png";
    private String m_sTimePlus = "/com/se/res/items/time_3frames_1stage_plus.png";
    private String m_sTimeMinus = "/com/se/res/items/time_3frames_1stage_minus.png";
    private Logger log = new Logger(class$com$se$manager$ItemManager == null ? (class$com$se$manager$ItemManager = ItemManager.class$("com.se.manager.ItemManager")) : class$com$se$manager$ItemManager);
    private int m_iFrameCounter = 0;
    private int m_iFrameSleep = 30;
    int iQuadr = 0;
    static /* synthetic */ Class class$com$se$manager$ItemManager;

    public ItemManager(LayerManager p_LayerManager) {
        this.m_objLayerManager = p_LayerManager;
        this.initialiseItems();
    }

    public void initialiseItems() {
        for (int i = 0; i < 4; ++i) {
            this.m_objItems[1 + i * 6 - 1] = new Item(this.m_sGravityPlus, 1);
            this.m_objItems[2 + i * 6 - 1] = new Item(this.m_sTargetPlus, 2);
            this.m_objItems[3 + i * 6 - 1] = new Item(this.m_sTimePlus, 3);
            this.m_objItems[4 + i * 6 - 1] = new Item(this.m_sGravityMinus, 4);
            this.m_objItems[5 + i * 6 - 1] = new Item(this.m_sTargetMinus, 5);
            this.m_objItems[6 + i * 6 - 1] = new Item(this.m_sTimeMinus, 6);
            Point curPos = new Point(Config.getItem_UP(), Config.getItem_LEFT());
            switch (i) {
                case 0: {
                    curPos = new Point(Config.getItem_UP(), Config.getItem_LEFT());
                    break;
                }
                case 1: {
                    curPos = new Point(Config.getItem_DOWN(), Config.getItem_RIGHT());
                    break;
                }
                case 2: {
                    curPos = new Point(Config.getItem_UP(), Config.getItem_RIGHT());
                    break;
                }
                case 3: {
                    curPos = new Point(Config.getItem_DOWN(), Config.getItem_LEFT());
                }
            }
            for (int x = i * 6; x < (1 + i) * 6; ++x) {
                this.m_objItems[x].setPosition((int)curPos.getX(), (int)curPos.getY());
                this.m_objItems[x].getSprite().setVisible(false);
                this.log.debug("Item " + x + " Type->" + this.m_objItems[x].getType() + " Pos->X:" + this.m_objItems[x].getSprite().getX() + "/Y:" + this.m_objItems[x].getSprite().getY());
            }
            this.m_arrActItems[i] = -1;
        }
        this.addItemArrToLM();
    }

    public void addItemArrToLM() {
        this.log.debug("Fuegt Sprites zu LM hinzu");
        for (int i = 0; i < this.m_objItems.length; ++i) {
            this.m_objLayerManager.append((Layer)this.m_objItems[i].getSprite());
        }
    }

    public void addRandomItem() {
        int iRandItemType = 1 + (int)(Config.getRandom() * 6.0f);
        this.iQuadr = Rectangle.nextQuadrant(this.iQuadr);
        this.changeVisibility(this.iQuadr, iRandItemType);
    }

    public void changeVisibility(int p_iQuadr, int p_iItem) {
        if (this.m_arrActItems[p_iQuadr] != -1) {
            this.changeVisibilityFalse(this.m_arrActItems[p_iQuadr]);
        }
        int iItemPos = p_iQuadr * 6 - 1 + p_iItem;
        this.log.debug("Item " + iItemPos + " Visible : True");
        this.m_objItems[iItemPos].show();
        this.m_arrActItems[p_iQuadr] = iItemPos;
    }

    public void changeVisibilityFalse(int p_iItemPos) {
        this.log.debug("Item " + p_iItemPos + " Visible : False");
        this.m_objItems[p_iItemPos].hide();
    }

    public void nextFrame() {
        if (this.m_iFrameCounter == 0) {
            for (int i = 0; i < this.m_objItems.length; ++i) {
                if (this.m_objItems[i] != null) {
                    this.m_objItems[i].getSprite().nextFrame();
                    continue;
                }
                this.log.debug("XXXXX:= IS NULL");
            }
            this.m_iFrameCounter = this.m_iFrameSleep;
        }
        --this.m_iFrameCounter;
    }

    public ItemProperty isColWithItem(Sprite p_sprite) {
        for (int i = 0; i < this.m_arrActItems.length; ++i) {
            if (this.m_arrActItems[i] == -1 || this.m_objItems[this.m_arrActItems[i]].isColidatingWith(p_sprite) <= 0) continue;
            int iType = this.m_objItems[this.m_arrActItems[i]].getType();
            int iX = this.m_objItems[this.m_arrActItems[i]].getSprite().getX();
            int iY = this.m_objItems[this.m_arrActItems[i]].getSprite().getY();
            this.changeVisibilityFalse(this.m_arrActItems[i]);
            this.m_arrActItems[i] = -1;
            return new ItemProperty(iType, iX, iY);
        }
        return null;
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            this.m_arrActItems[i] = 0;
        }
        int iSize = this.m_objItems.length;
        for (int i = 0; i < iSize; ++i) {
            this.m_objItems[i].hide();
        }
    }

    public void printStatus() {
        for (int i = 0; i < this.m_arrActItems.length; ++i) {
            this.log.debug("Integer Array " + i + " : " + this.m_arrActItems[i]);
        }
    }

    public void setItemsInterval(int pItemsInterval) {
        Timer objTimer = new Timer();
        objTimer.schedule((TimerTask)this, Config.getItemsDelay() * 1000, (long)(pItemsInterval * 1000));
    }

    public void run() {
        if (Config.isGameRunning()) {
            this.addRandomItem();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

