/*
 * Decompiled with CFR 0.152.
 */
package com.se.util;

import com.se.util.Logger;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.DataListener;
import javax.microedition.sensor.MeasurementRange;
import javax.microedition.sensor.SensorConnection;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorManager;

public class AccSensor
implements Runnable,
DataListener {
    private SensorConnection m_objSensor;
    private String m_strURL;
    private int[] m_arrChannels = new int[3];
    private String[] m_arrChannelNames = new String[3];
    private Axis m_objAxis;
    private boolean m_bIsLog;
    private final Logger log = new Logger(class$com$se$util$AccSensor == null ? (class$com$se$util$AccSensor = AccSensor.class$("com.se.util.AccSensor")) : class$com$se$util$AccSensor);
    static /* synthetic */ Class class$com$se$util$AccSensor;

    public AccSensor() {
        this.m_objAxis = new Axis(0, 0, 0);
        this.log.debug("findSensors");
        SensorInfo[] arrSI = SensorManager.findSensors((String)"acceleration", (String)"user");
        for (int i = 0; i < arrSI.length; ++i) {
            this.log.debug("arr[" + i + "]:=" + arrSI[i]);
        }
        this.setInfo(arrSI);
        new Thread(this).start();
    }

    public Axis getAxis() {
        return this.m_objAxis;
    }

    private void setInfo(SensorInfo[] pArrSI) {
        StringBuffer objSB = new StringBuffer();
        for (int i = 0; i < pArrSI.length; ++i) {
            SensorInfo s = pArrSI[i];
            objSB.append("getDescription: " + s.getDescription());
            objSB.append("isAvailable: " + s.isAvailable());
            objSB.append("isAvailabilityPushSupported: " + s.isAvailabilityPushSupported());
            objSB.append("isConditionPushSupported: " + s.isConditionPushSupported());
            objSB.append("getConnectionType: " + s.getConnectionType());
            objSB.append("getContextType: " + s.getContextType());
            objSB.append("getMaxBufferSize: " + s.getMaxBufferSize());
            objSB.append("getModel: " + s.getModel());
            objSB.append("getQuantity: " + s.getQuantity());
            this.m_strURL = s.getUrl();
            objSB.append("getUrl: " + this.m_strURL);
            objSB.append("Properties:");
            String[] propNames = s.getPropertyNames();
            for (int r = 0; r < propNames.length; ++r) {
                objSB.append("  " + propNames[r] + ": " + s.getProperty(propNames[r]));
            }
            ChannelInfo[] cInfos = s.getChannelInfos();
            if (cInfos.length != 3) {
                objSB.append("Should support 3 channels but reports " + cInfos.length);
                throw new IllegalArgumentException("Should support 3 channels but reports " + cInfos.length);
            }
            objSB.append("Channels:");
            for (int r = 0; r < cInfos.length; ++r) {
                ChannelInfo c = cInfos[r];
                this.m_arrChannelNames[r] = c.getName();
                objSB.append("  getName: " + this.m_arrChannelNames[r]);
                int type = c.getDataType();
                switch (type) {
                    case 2: {
                        objSB.append("  Data type: TYPE_INT");
                        break;
                    }
                    case 1: {
                        objSB.append("  Data type: TYPE_DOUBLE");
                        objSB.append("Should be TYPE_INT");
                        throw new IllegalArgumentException("Should be TYPE_INT");
                    }
                    case 4: {
                        objSB.append("  Data type: TYPE_OBJECT");
                        objSB.append("Should be TYPE_INT");
                        throw new IllegalArgumentException("Should be TYPE_INT");
                    }
                }
                objSB.append("  getScale: " + c.getScale());
                objSB.append("  getUnit: " + c.getUnit().toString());
                objSB.append("  getAccuracy: " + c.getAccuracy());
                MeasurementRange[] ranges = c.getMeasurementRanges();
                objSB.append("  Measurement range:");
                for (int p = 0; p < ranges.length; ++p) {
                    MeasurementRange m = ranges[p];
                    objSB.append("    getSmallestValue:" + m.getSmallestValue());
                    objSB.append("    getLargestValue: " + m.getLargestValue());
                    objSB.append("    getResolution: " + m.getResolution());
                }
            }
        }
        this.m_bIsLog = false;
    }

    public boolean isLogger() {
        return this.m_bIsLog;
    }

    public String getURL() {
        return this.m_strURL;
    }

    public void run() {
        try {
            this.m_objSensor = (SensorConnection)Connector.open((String)this.m_strURL);
            this.m_objSensor.setDataListener((DataListener)this, 1);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void destroy() throws IOException {
        this.m_objSensor.close();
    }

    public void dataReceived(SensorConnection sensor, Data[] data, boolean isDataLost) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getChannelInfo().getName().compareTo(this.m_arrChannelNames[0]) == 0) {
                this.m_arrChannels[0] = data[i].getIntValues()[0];
                continue;
            }
            if (data[i].getChannelInfo().getName().compareTo(this.m_arrChannelNames[1]) == 0) {
                this.m_arrChannels[1] = data[i].getIntValues()[0];
                continue;
            }
            if (data[i].getChannelInfo().getName().compareTo(this.m_arrChannelNames[2]) != 0) continue;
            this.m_arrChannels[2] = data[i].getIntValues()[0];
        }
        this.m_objAxis = new Axis(this.m_arrChannels[0], this.m_arrChannels[1], this.m_arrChannels[2]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Axis {
        private int m_iX;
        private int m_iY;
        private int m_iZ;

        public Axis(int iX, int iY, int iZ) {
            this.m_iX = iX;
            this.m_iY = iY;
            this.m_iZ = iZ;
        }

        public int getX() {
            return this.m_iX;
        }

        public int getY() {
            return this.m_iY;
        }

        public int getZ() {
            return this.m_iZ;
        }
    }
}

