/*
 * Decompiled with CFR 0.152.
 */
package com.se.bean;

import com.se.bean.Point;
import com.se.bean.Rectangle;
import com.se.util.Config;
import com.se.util.Logger;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Target {
    private Logger log = new Logger(class$com$se$bean$Target == null ? (class$com$se$bean$Target = Target.class$("com.se.bean.Target")) : class$com$se$bean$Target);
    private Sprite m_objSprite;
    private int m_iRadius;
    private int m_iCOUNT;
    private int m_iSLEEP = 4;
    private Image m_imgTarget;
    private String m_strTargetPath = "/com/se/res/target/66x66_Target_4x8Frames.png";
    private int m_iStage = 0;
    private boolean m_bIsInTarget = false;
    private String m_strRingPath = "/com/se/res/target/ring_%.png";
    private Image[] m_imgRing = new Image[4];
    private Rectangle m_objGoal;
    static /* synthetic */ Class class$com$se$bean$Target;

    public Target() throws IOException {
        this.m_iCOUNT = this.m_iSLEEP;
        this.m_imgTarget = Image.createImage((String)this.m_strTargetPath);
        for (int i = 0; i < 4; ++i) {
            this.log.debug(this.m_strRingPath.replace('%', Integer.toString(i).charAt(0)));
            this.m_imgRing[i] = Image.createImage((String)this.m_strRingPath.replace('%', Integer.toString(i).charAt(0)));
        }
        this.m_iRadius = this.m_imgTarget.getWidth() / 2;
        this.m_objSprite = new Sprite(this.m_imgTarget, this.m_imgTarget.getWidth(), this.m_imgTarget.getWidth());
        this.m_objSprite.setRefPixelPosition(this.m_iRadius, this.m_iRadius);
        this.m_objSprite.setFrameSequence(this.getFrameSequence());
        this.m_objGoal = new Rectangle(2, Config.getGoalLeft(), Config.getGoalRight(), Config.getGoalUp(), Config.getGoalDown());
        this.generateNext();
    }

    public void drawRing(Graphics g) {
        if (this.m_bIsInTarget) {
            g.drawImage(this.m_imgRing[this.m_iStage], (int)this.getX() + (3 - this.m_iStage), (int)this.getY() + (3 - this.m_iStage), 20);
            this.log.debug("Stage" + this.m_iStage);
        }
    }

    public void refresh() {
        if (this.m_iCOUNT == 0) {
            this.m_objSprite.nextFrame();
            this.m_iCOUNT = this.m_iSLEEP;
        }
        --this.m_iCOUNT;
    }

    public void generateNext() {
        float iX = (float)this.m_objGoal.getQuadrWidth() * Config.getRandom();
        float iY = (float)this.m_objGoal.getQuadrHeight() * Config.getRandom();
        this.m_objGoal.nextQuadrant();
        Point curPos = this.m_objGoal.getPointFromQuadr(iX, iY);
        this.log.debug("Quadrant = " + this.m_objGoal.getQuadrant() + "  X=" + (int)curPos.getX() + "/Y=" + (int)curPos.getY());
        this.m_objSprite.setPosition((int)curPos.getX(), (int)curPos.getY());
    }

    public Image getImage() {
        return this.m_imgTarget;
    }

    public Sprite getSprite() {
        return this.m_objSprite;
    }

    public int getRadius() {
        return this.m_iRadius;
    }

    public float getX() {
        return this.m_objSprite.getX();
    }

    public float getY() {
        return this.m_objSprite.getY();
    }

    public Point getPoint() {
        return new Point(this.m_objSprite.getX(), this.m_objSprite.getY());
    }

    public int isInTarget(Sprite sprite) {
        if (this.m_objSprite.collidesWith(sprite, true)) {
            this.m_bIsInTarget = true;
            return 1;
        }
        this.m_bIsInTarget = false;
        return 0;
    }

    public int incrementSize() {
        if (this.m_iStage < 3) {
            ++this.m_iStage;
            this.m_objSprite.setFrameSequence(this.getFrameSequence());
        }
        return this.m_iStage;
    }

    public int decrementSize() {
        if (this.m_iStage > 0) {
            --this.m_iStage;
            this.m_objSprite.setFrameSequence(this.getFrameSequence());
        }
        return this.m_iStage;
    }

    public int getActSize() {
        return this.m_iStage;
    }

    public void reset() {
        this.generateNext();
    }

    private int[] getFrameSequence() {
        int[] arrFrSeq = new int[7];
        for (int i = 0; i < 7; ++i) {
            arrFrSeq[i] = 8 * this.m_iStage + i;
        }
        return arrFrSeq;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

