/*
 * Decompiled with CFR 0.152.
 */
package com.se.util;

import java.util.Calendar;
import java.util.Date;

public class Common {
    public static final int[] CosTable90 = new int[]{1024, 1023, 1023, 1022, 1021, 1020, 1018, 1016, 1014, 1011, 1008, 1005, 1001, 997, 993, 989, 984, 979, 973, 968, 962, 955, 949, 942, 935, 928, 920, 912, 904, 895, 886, 877, 868, 858, 848, 838, 828, 817, 806, 795, 784, 772, 760, 748, 736, 724, 711, 698, 685, 671, 658, 644, 630, 616, 601, 587, 572, 557, 542, 527, 512, 496, 480, 464, 448, 432, 416, 400, 383, 366, 350, 333, 316, 299, 282, 265, 247, 230, 212, 195, 177, 160, 142, 124, 107, 89, 71, 53, 35, 17, 0};
    public static final int[] AtanTable = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 30, 31, 32, 33, 34, 35, 36, 37, 37, 38, 39, 40, 40, 41, 42, 43, 43, 44, 45};

    public static String formatTime(long m_iTime) {
        Calendar objC = Common.getTime(m_iTime);
        return "" + objC.get(12) + ":" + objC.get(13);
    }

    public static String getDigitFillZero(int pDigit, int pSize) {
        String strDigit = "" + pDigit;
        int iSizeOfDigit = strDigit.length();
        StringBuffer sbDigit = new StringBuffer();
        for (int i = iSizeOfDigit; i < pSize; ++i) {
            sbDigit.append("0");
        }
        sbDigit.append(pDigit);
        return sbDigit.toString();
    }

    public static Calendar getTime(long pTime) {
        Calendar objC = Calendar.getInstance();
        objC.setTime(new Date(pTime));
        return objC;
    }

    public static long initTime(int iMin, int iSec) {
        Calendar objC = Calendar.getInstance();
        objC.set(12, iMin);
        objC.set(13, iSec);
        return objC.getTime().getTime();
    }

    public static boolean isTimerZero(long m_iTime) {
        Calendar objC = Common.getTime(m_iTime);
        return objC.get(12) == 0 && objC.get(13) == 0;
    }

    public static int atan(int Y, int X) {
        int bottom;
        boolean swap = false;
        int top = Math.abs(Y);
        if (top > (bottom = Math.abs(X))) {
            int btemp = bottom;
            bottom = top;
            top = btemp;
            swap = true;
        } else if (bottom == 0) {
            return -300;
        }
        int index = top * 45 / bottom;
        int angle = AtanTable[index];
        if (swap) {
            angle = 90 - angle;
        }
        if (X < 0 && Y < 0) {
            angle += 180;
        } else if (Y < 0) {
            angle = 90 - angle;
            angle += 270;
        } else if (X < 0) {
            angle = 90 - angle;
            angle += 90;
        }
        if (angle == 360) {
            angle = 0;
        }
        return angle;
    }

    public static double aTan2(double y, double x) {
        double angle;
        double coeff_1 = 0.7853981633974483;
        double coeff_2 = 3.0 * coeff_1;
        double abs_y = Math.abs(y);
        if (x >= 0.0) {
            double r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            double r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0.0 ? -angle : angle;
    }

    public static final String replace(String text, String searchString, String replacementString) {
        StringBuffer sBuffer = new StringBuffer();
        int pos = 0;
        while ((pos = text.indexOf(searchString)) != -1) {
            sBuffer.append(text.substring(0, pos) + replacementString);
            text = text.substring(pos + searchString.length());
        }
        sBuffer.append(text);
        return sBuffer.toString();
    }

    public static double toPositivDegrees(double m_iGRAD) {
        if (m_iGRAD < 0.0) {
            return m_iGRAD * -1.0;
        }
        return 360.0 - m_iGRAD;
    }
}

