/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.toctoc.midlet;

import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.ams.Installer;
import com.sonyericsson.toctoc.midlet.TocToc;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class WorkerThread
extends Thread {
    private TocToc tocToc;
    private Installer installer;
    private static final String JAD_URL = "http://spi.movistar.es/upgrades/se/toctoc.jad";
    private static final String JAR_URL = "http://spi.movistar.es/upgrades/se/toctoc.jar";

    public WorkerThread(TocToc tocToc) {
        this.tocToc = tocToc;
    }

    public void run() {
        try {
            this.installer = ApplicationManager.getApplicationManager().getInstaller(true);
            this.feedURL(JAD_URL, this.installer.addJad("toctoc.jad"));
            this.feedURL(JAR_URL, this.installer.addJar("toctoc.jar"));
        }
        catch (Exception e) {
            this.tocToc.reportNotAvailable();
            return;
        }
        try {
            this.installer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tocToc.notifyDestroyed();
    }

    private void feedURL(String url, OutputStream os) throws Exception {
        InputStream is = this.getFile(url);
        this.feedStream(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getFile(String url) throws Exception {
        HttpConnection httpConn = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)url, (int)1, (boolean)true);
            httpConn.setRequestMethod("GET");
            httpConn.setRequestProperty("User-Agent", "sony");
            int respCode = httpConn.getResponseCode();
            if (respCode != 200) {
                throw new IOException("URL dead");
            }
            InputStream inputStream = httpConn.openInputStream();
            return inputStream;
        }
        finally {
            if (httpConn != null) {
                httpConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedStream(InputStream is, OutputStream os) throws Exception {
        try {
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }
}

