/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.language;

import com.sonyericsson.fifa.view.language.UpdateLanguageListener;
import java.util.Vector;

public class Language {
    private String currentLocale = null;
    private Vector listeners = new Vector();

    public Language() {
        this.currentLocale = this.getLocale();
    }

    private String getLocale() {
        String locale = System.getProperty("microedition.locale");
        if (locale != null && locale.length() > 1) {
            locale = locale.substring(0, 2);
        }
        return locale;
    }

    private void fireLanguageChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            UpdateLanguageListener listener = (UpdateLanguageListener)this.listeners.elementAt(i);
            listener.updateLanguage();
            ++i;
        }
    }

    public String getCurrentLocale() {
        return this.currentLocale;
    }

    public void verifyLocaleChanged() {
        String locale = this.getLocale();
        if (!this.currentLocale.equals(locale)) {
            this.currentLocale = locale;
            this.fireLanguageChanged();
        }
    }

    public final void addLanguageListener(UpdateLanguageListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public final void removeLanguageListener(UpdateLanguageListener listener) {
        this.listeners.removeElement(listener);
    }
}

