/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.PlayerModelListener;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.components.forms.MyTeamForm;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.util.Vector;

public class PlayerView
extends FifaAbstractView
implements PlayerModelListener,
SelectableItemListener {
    private Team team;
    private static boolean isFirstSquadShow = true;
    private Squad squad;
    private int[] itemsNewsList;
    private MyTeamForm myTeamForm;
    private String teamCode;
    private String playerName;
    private Vector headlineImages;
    private static final String GROUP = "Player";

    public PlayerView(Model model, String teamCode, String playerName) {
        super(10, model);
        this.model = model;
        this.teamCode = teamCode;
        this.playerName = playerName;
        this.team = model.getTeam(teamCode);
        this.squad = this.team.getSquad();
        this.squad.setListerner(this);
        this.myTeamForm = ViewFactory.getMyTeamForm();
        this.myTeamForm.addGroup(GROUP);
        this.myTeamForm.hideTitle();
    }

    private int[] getPlayerNews() {
        int[] itemsNewsList = null;
        if (this.squad != null) {
            itemsNewsList = this.squad.getPlayerInfo();
        }
        return itemsNewsList;
    }

    private Vector getLatestNews() {
        Feed latestNews;
        if (this.team != null && (latestNews = this.team.getLatestNews()) != null) {
            return latestNews.getItems();
        }
        return null;
    }

    private void addListItems() {
        Vector itemList = this.getLatestNews();
        Enclosure enclosure = null;
        int count = 0;
        if (this.itemsNewsList != null && itemList != null && !itemList.isEmpty()) {
            int index = 0;
            int i = 0;
            while (this.itemsNewsList[i] != -1) {
                ++count;
                index = this.itemsNewsList[i];
                FeedItem item = (FeedItem)itemList.elementAt(index);
                if (item != null) {
                    enclosure = item.getEnclosure();
                    if (enclosure != null && enclosure.getThumbPath() != null) {
                        this.myTeamForm.addItem(item.getTitle(), item.getDescription(), enclosure.getThumbPath());
                        if (this.headlineImages == null) {
                            this.headlineImages = new Vector();
                        }
                        this.setHealineImages(i, enclosure.getPath());
                    } else {
                        this.myTeamForm.addItem(item.getTitle(), item.getDescription(), Images.getListIconDefault());
                    }
                }
                ++i;
            }
            if (count < FifaAbstractView.attributes.getMinPlayerItems()) {
                this.myTeamForm.addFakeItem(count);
            }
        }
        this.myTeamForm.removeWaitIndicator();
    }

    public void addComponents() {
        this.itemsNewsList = this.getPlayerNews();
        if (this.itemsNewsList[0] == -1) {
            this.myTeamForm.addTextAreaItem(FifaResources.getMessage("FANAPP_NO_NEWS_TXT"));
            this.myTeamForm.addFakeItem(1);
            this.myTeamForm.removeMiddleSoftkey();
            this.myTeamForm.setHeadline(this.getDefaultHeadLinePictures());
            this.myTeamForm.removeWaitIndicator();
        } else {
            this.addListItems();
            if (this.headlineImages != null) {
                this.myTeamForm.setHeadline(this.headlineImages);
            } else {
                this.myTeamForm.setHeadline(this.getDefaultHeadLinePictures());
            }
        }
        this.myTeamForm.setCrossfadePosition();
        this.myTeamForm.addCountryDataItem(this.playerName, String.valueOf(this.teamCode) + "_SMALL");
        this.myTeamForm.revalidate();
    }

    protected void doShow() throws ViewException {
        this.viewId = 10;
        if (isFirstSquadShow) {
            this.myTeamForm.showWaitIndicator(VerifyScreenDimension.getAttributesInstance().getWaitIndicatorHeight());
            isFirstSquadShow = false;
        } else {
            this.myTeamForm.startCrossfade();
        }
        this.myTeamForm.setKeyListener(this);
        this.myTeamForm.setTouchListener(this);
        this.myTeamForm.setSelectableItemListener(this);
        this.myTeamForm.show();
    }

    protected void doHide() {
        this.myTeamForm.pauseCrossfade();
        this.myTeamForm.setKeyListener(null);
        this.myTeamForm.setTouchListener(null);
        this.myTeamForm.setSelectableItemListener(null);
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        this.updateThumbnail(index, thumbnail);
    }

    public void selectedItem(int item, int subGroup) {
        if (subGroup == 0 && this.itemsNewsList != null) {
            TeamItemSelectedAction teamItemAction = new TeamItemSelectedAction(this.itemsNewsList[item], this.teamCode);
            this.fireViewActionPerformed(teamItemAction);
        }
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void playerInfoReady(int[] itemList) {
        this.updateView();
    }

    public void performSoftkey() {
        if (-7 == this.myTeamForm.getSelectedSoftkey()) {
            this.getLanguage().removeLanguageListener(this);
            this.squad.setListerner(null);
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        this.addComponents();
        this.myTeamForm.focusFirstItem(GROUP);
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        this.myTeamForm.setItemPicture(index, thumbnail.getThumbPath());
        this.setHealineImages(index, thumbnail.getPath());
    }

    private void setHealineImages(int index, String imagePath) {
        if (this.headlineImages != null) {
            if (this.headlineImages.size() < 3) {
                try {
                    Image img = Image.createImage(IOUtility.openFileInputStream(imagePath)).scaled(FifaAbstractView.attributes.getHeadlinePictureWidth(), FifaAbstractView.attributes.getHeadlinePictureHeight());
                    this.headlineImages.addElement(img);
                    this.myTeamForm.setHeadline(this.headlineImages);
                }
                catch (IOException e) {
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (this.headlineImages.size() == 2) {
                this.myTeamForm.startCrossfade();
            }
        }
    }

    protected void doClearFormText() {
        if (!this.myTeamForm.isTeamItems()) {
            this.myTeamForm.refreshAll();
            this.myTeamForm.addGroup(GROUP);
            this.myTeamForm.hideTitle();
            this.updateView();
        } else {
            this.myTeamForm.refreshAll();
            this.myTeamForm.addGroup(GROUP);
            this.myTeamForm.hideTitle();
        }
    }
}

