/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.MoreSelectedAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.components.forms.TeamForm;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.util.Vector;

public class TeamView
extends FifaAbstractView
implements TeamListener {
    private Model model = null;
    private Vector headlineImages;
    private String teamCode;
    private MoreSelectedAction moreSelectedAction;
    private TeamForm teamForm = ViewFactory.getTeamForm();
    private boolean isFirstUpdate = true;
    private boolean isFirstShow = true;

    public TeamView(Model model, String teamCode) {
        super(13, model);
        this.teamForm.addGroups();
        this.model = model;
        this.teamCode = teamCode;
        this.model.addTeamListener(teamCode, this);
        this.moreSelectedAction = new MoreSelectedAction(this.teamCode);
        this.teamForm.setHeadline(this.getDefaultHeadLinePictures());
        this.teamForm.setCrossfadePosition();
        this.headlineImages = new Vector();
    }

    protected void doShow() throws ViewException {
        this.viewId = 13;
        if (this.isFirstShow) {
            this.teamForm.showWaitIndicator();
        } else {
            this.teamForm.startCrossfade();
        }
        this.isFirstShow = false;
        this.model.addTeamListener(this.teamCode, this);
        this.teamForm.setSelectableItemListener(this);
        this.teamForm.setTouchListener(this);
        this.teamForm.setKeyListener(this);
        this.teamForm.show();
    }

    protected void doHide() {
        this.teamForm.removeWaitIndicator();
        this.teamForm.pauseCrossfade();
        this.teamForm.setKeyListener(null);
        this.teamForm.setTouchListener(null);
    }

    public void teamUpdateStarted() {
    }

    public void teamUpdateFinished(boolean newItemsAvailable, String teamCode) {
        this.updateView();
    }

    private void addComponents() {
        this.addNewsItems();
        this.addTeamItems();
    }

    private void addNewsItems() {
        Enclosure enclosure = null;
        int maxItensDisp = FifaAbstractView.attributes.getMaxItemsDisplayed();
        Vector items = this.model.getTeam(this.teamCode).getLatestNews().getItems();
        int countItems = items.size();
        int i = 0;
        while (i < countItems && i < maxItensDisp) {
            FeedItem item = (FeedItem)items.elementAt(i);
            enclosure = item.getEnclosure();
            if (enclosure != null && enclosure.getThumbPath() != null) {
                this.teamForm.addItem(item.getTitle(), item.getDescription(), enclosure.getThumbPath());
                this.setHealineImages(i, enclosure.getPath());
            } else {
                this.teamForm.addItem(item.getTitle(), item.getDescription(), Images.getListIconDefault());
            }
            ++i;
        }
        this.teamForm.addMoreItem();
        this.teamForm.addCountryDataItem(this.getTeamGroup(this.teamCode), String.valueOf(this.teamCode) + "_SMALL");
        this.teamForm.removeWaitIndicator();
    }

    private void addTeamItems() {
        this.teamForm.addSquadItem();
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        this.updateThumbnail(index, thumbnail);
    }

    public void selectedItem(int index, int subGroup) {
        if (subGroup == 0) {
            if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
                TeamItemSelectedAction teamItemAction = new TeamItemSelectedAction(index, this.teamCode);
                this.fireViewActionPerformed(teamItemAction);
            } else {
                this.fireViewActionPerformed(this.moreSelectedAction);
            }
        } else if (subGroup == 1) {
            switch (index) {
                case 0: {
                    DialogsManager.showComingSoonAlert();
                    try {
                        this.show();
                        break;
                    }
                    catch (ViewException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void performSoftkey() {
        if (-7 == this.teamForm.getSelectedSoftkey()) {
            this.getLanguage().removeLanguageListener(this);
            this.model.removeTeamListener(this.teamCode, this);
            this.fireViewActionPerformed(new BackAction());
        }
    }

    protected void doUpdateView() {
        if (this.isFirstUpdate) {
            this.isFirstUpdate = false;
            this.addComponents();
            this.teamForm.focusFirstItem();
            this.teamForm.revalidate();
        }
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
            this.teamForm.setItemPicture(index, thumbnail.getThumbPath());
        }
        this.setHealineImages(index, thumbnail.getPath());
    }

    private void setHealineImages(int index, String imagePath) {
        if (this.headlineImages != null) {
            if (this.headlineImages.size() < 3) {
                try {
                    Image img = Image.createImage(IOUtility.openFileInputStream(imagePath)).scaled(FifaAbstractView.attributes.getHeadlinePictureWidth(), FifaAbstractView.attributes.getHeadlinePictureHeight());
                    this.headlineImages.addElement(img);
                    this.teamForm.setHeadline(this.headlineImages);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.headlineImages.size() == 2) {
                this.teamForm.startCrossfade();
            }
        }
    }

    protected void doClearFormText() {
        if (!this.teamForm.isTeamItems()) {
            this.teamForm.refreshAll();
            this.teamForm.addGroups();
            this.isFirstUpdate = true;
            this.updateView();
        } else {
            this.teamForm.refreshAll();
            this.teamForm.addGroups();
            this.isFirstUpdate = true;
        }
    }

    public void teamUpdateFailed(byte reason) {
        boolean viewDisplayable = false;
        Team team = this.model.getTeam(this.teamCode);
        if (team != null && team.getLatestNews() != null && team.getLatestNews().getItems() != null && !team.getLatestNews().getItems().isEmpty()) {
            viewDisplayable = true;
            this.updateView();
        }
        this.fireViewActionPerformed(new UpdateFailureAction(reason, viewDisplayable));
    }
}

