/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model;

import com.sonyericsson.fifa.data.ConfLink;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.data.Squad;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.datastore.ConfigurationDB;
import com.sonyericsson.fifa.model.AbstractModel;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.model.NetAuth;
import com.sonyericsson.fifa.model.StartupConfiguration;
import com.sonyericsson.fifa.model.gameList.GameList;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentList;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.model.teamList.SquadListener;
import com.sonyericsson.fifa.model.teamList.TeamList;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTable;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.ConflinksHandler;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;

public class FifaModel
extends AbstractModel {
    private PreloadedContentList preloadedContentList;
    private TournamentTable tournamentTable;
    private String myTeamCode;
    private TeamList teamList;
    private GameList todayGameList;
    private NetAuth netAuth;
    private Vector confLinks;
    private ModelControllerListener listener;
    private String tournamentTabLink = null;
    static /* synthetic */ Class class$0;

    private PreloadedContentList getPreloadedContentList() {
        if (this.preloadedContentList == null) {
            this.preloadedContentList = new PreloadedContentList();
        }
        return this.preloadedContentList;
    }

    public PreloadedContent getPreloadedContent(int index) {
        return this.getPreloadedContentList().getPreloadedContent(index);
    }

    public Vector getPreloadedGames() {
        return this.getPreloadedContentList().getPreloadedGames();
    }

    public Vector getPreloadedLinks() {
        return this.getPreloadedContentList().getPreloadedLinks();
    }

    public Vector getPreloadedVideos() {
        return this.getPreloadedContentList().getPreloadedVideos();
    }

    public Vector getPreloadedPictures() {
        return this.getPreloadedContentList().getPreloadedPictures();
    }

    public void updatePreloadedContent() {
        this.getPreloadedContentList().updatePreloadedContent();
    }

    public boolean isPreloadedContentUpdated() {
        return this.getPreloadedContentList().isPreloadedContentUpdated();
    }

    public void updatePlayerInfo(Squad squad, String playerName, Feed feed) {
        squad.updatePlayer(feed, playerName);
    }

    public void addPreloadedContentListener(PreloadedContentListener listener) {
        this.getPreloadedContentList().addPreloadedContentListener(listener);
    }

    public void removePreloadedContentListener(PreloadedContentListener listener) {
        this.getPreloadedContentList().removePreloadedContentListener(listener);
    }

    private GameList getTodayGameList() {
        if (this.todayGameList == null) {
            this.todayGameList = new GameList();
        }
        return this.todayGameList;
    }

    public Vector getNotStartedGames() {
        return this.getTodayGameList().getNotStartedGames();
    }

    public Vector getOngoingGames() {
        return this.getTodayGameList().getOngoingGames();
    }

    public Vector getFinishedGames() {
        return this.getTodayGameList().getFinishedGames();
    }

    private TeamList getTeamList() {
        if (this.teamList == null) {
            this.teamList = new TeamList();
        }
        return this.teamList;
    }

    public Team getMyTeam() {
        return this.getTeam(this.myTeamCode);
    }

    public void setMyTeam(String teamCode) {
        this.myTeamCode = teamCode;
        this.getTeamList().setMyTeam(teamCode);
        ConfigurationDB configurationDB = new ConfigurationDB();
        StartupConfiguration startupConfiguration = configurationDB.retrieveConfiguration();
        startupConfiguration.setMyTeamCountryCode(teamCode);
        configurationDB.saveConfiguration(startupConfiguration);
    }

    public Team getTeam(String teamCode) {
        return this.getTeamList().getTeam(teamCode);
    }

    public void updateTeam(String teamCode, boolean isMyTeam) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            if (isMyTeam) {
                team.setScheduleUpdate();
            }
            team.updateLatestNews();
        }
    }

    public void updateSquadTeam(String teamCode) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.updateSquadInformation();
        }
    }

    public void initModel() {
    }

    public void updateTeamList() {
        this.getTeamList().updateTeamList();
    }

    public void addTeamListener(String teamCode, TeamListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.addTeamListener(listener);
        }
    }

    public void addSquadListener(String teamCode, SquadListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.addSquadListener(listener);
        }
    }

    public void removeSquadListener(String teamCode, SquadListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.removeSquadListener(listener);
        }
    }

    public void addModelControllerListener(ModelControllerListener listener) {
        this.listener = listener;
        this.getTeamList().setListerner(listener);
    }

    public void removeModelControllerListener() {
        this.listener = null;
        this.getTeamList().removeListener();
    }

    public void removeTeamListener(String teamCode, TeamListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.removeTeamListener(listener);
        }
    }

    private TournamentTable getTournamentTable() {
        if (this.tournamentTable == null) {
            this.tournamentTable = new TournamentTable();
        }
        return this.tournamentTable;
    }

    public Vector getTournamentGroups() {
        return this.getTournamentTable().getTournamentGroups();
    }

    public void updateTournamentContent() {
        this.getTournamentTable().updateTournamentContent(this.getTournamentLink());
    }

    public boolean isTournamentUpdated() {
        return this.getTournamentTable().isTournamentUpdated();
    }

    public void addTournamentTableListener(TournamentTableListener listener) {
        this.getTournamentTable().addTournamentTableListener(listener);
    }

    public void removeTournamentTableListener(TournamentTableListener listener) {
        this.getTournamentTable().removeTournamentTableListener(listener);
    }

    public String getGroupByTeamCode(String teamCode) {
        return this.getTournamentTable().getGroupByTeamCode(teamCode);
    }

    public boolean isNetworkingAuthorized() {
        ConfigurationDB configurationDB = new ConfigurationDB();
        StartupConfiguration startupConfiguration = configurationDB.retrieveConfiguration();
        boolean neverAsk = startupConfiguration.getYesNeverAsk();
        if (neverAsk) {
            return neverAsk;
        }
        return this.getNetAuth().isNetworkingAuthorized();
    }

    public void setNetworkingAuthorization(boolean auth) {
        this.getNetAuth().setNetworkingAuthorization(auth);
    }

    public boolean isRoamingAuthorized() {
        return this.getNetAuth().isRoamingAuthorized();
    }

    public void setRoamingAuthorization(boolean auth) {
        this.getNetAuth().setRoamingAuthorization(auth);
    }

    private NetAuth getNetAuth() {
        if (this.netAuth == null) {
            this.netAuth = new NetAuth();
        }
        return this.netAuth;
    }

    private String getTournamentLink() {
        if (this.tournamentTabLink == null && this.confLinks != null) {
            int i = 0;
            while (i < this.confLinks.size()) {
                ConfLink element = (ConfLink)this.confLinks.elementAt(i);
                if (element.getType() == 1) {
                    this.tournamentTabLink = element.url;
                }
                ++i;
            }
        }
        return this.tournamentTabLink;
    }

    public void updateConfLinks() {
        final ConflinksHandler handler = new ConflinksHandler();
        SaxParser parser = new SaxParser("/confLinks.xml", handler);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                Vector contentList = handler.getParsedConfLinks();
                if (contentList != null && !contentList.isEmpty()) {
                    FifaModel.this.confLinks = contentList;
                    FifaModel.this.fireConfLinkReady((byte)0);
                }
            }

            public void parserFailed(byte reason) {
                FifaModel.this.confLinks = null;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.model.FifaModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "updateConfLinks failed.");
                Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                FifaModel.this.fireConfLinkReady((byte)4);
            }
        };
        parser.addParserListener(listener);
        new Thread(parser).start();
    }

    public void setModelControllerListener(ModelControllerListener listener) {
        this.listener = listener;
    }

    private void fireConfLinkReady(byte reason) {
        if (this.listener != null) {
            this.listener.confLinkReady(reason);
        }
    }
}

