/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.ConfLink;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.ConfLinksContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConflinksHandler
extends DefaultHandler
implements ConfLinksContentProvider {
    private static final String CONFLINKS_TAG = "CONFLINKS";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_TYPE_ATTRIBUTE = "type";
    private static final String ITEM_URL_ATTRIBUTE = "url";
    private boolean xmlStartedCorrectly;
    private ConfLink confLink;
    private Vector confLinks;
    private boolean containTwitterCupLink;
    private boolean containTournamentTabLink;
    private boolean containTodayTabLink;
    private byte currentTypeByte = (byte)-1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (!this.xmlStartedCorrectly || !ITEM_TAG.equals(tagName) || this.currentTypeByte != -1) throw new RssInvalidFormatException();
            if (attributes == null) return;
            this.parseItem(attributes);
            return;
        } else {
            if (!CONFLINKS_TAG.equals(tagName)) throw new RssInvalidFormatException();
            this.xmlStartedCorrectly = true;
        }
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (ITEM_TAG.equals(qName) && this.currentTypeByte != -1 && this.confLink != null) {
                this.validateType(this.currentTypeByte);
                this.currentTypeByte = (byte)-1;
                this.getParsedConfLinks().addElement(this.confLink);
            } else if (CONFLINKS_TAG.equals(qName)) {
                this.xmlStartedCorrectly = false;
            }
        } else {
            throw new RssInvalidFormatException();
        }
    }

    private void parseItem(Attributes attributes) throws SAXException {
        int numberOfAttributes = attributes.getLength();
        this.confLink = new ConfLink();
        int i = 0;
        while (i < numberOfAttributes) {
            String attributeName = attributes.getQName(i).trim();
            String attributeValue = attributes.getValue(i).trim();
            if (attributeValue != null && !"".equals(attributeValue)) {
                if (ITEM_TYPE_ATTRIBUTE.equals(attributeName)) {
                    byte typeByte = ConfLink.getType(attributeValue);
                    this.confLink.setType(typeByte);
                    this.currentTypeByte = typeByte;
                } else if (ITEM_URL_ATTRIBUTE.equals(attributeName)) {
                    this.confLink.setUrl(attributeValue);
                }
            }
            ++i;
        }
        if (this.confLink.getType() != -1) {
            this.confLink.getUrl();
        }
    }

    private void validateType(byte typeByte) throws SAXException {
        if (typeByte == 2) {
            if (this.containTodayTabLink) {
                throw new RssInvalidFormatException();
            }
            this.containTodayTabLink = true;
        } else if (typeByte == 1) {
            if (this.containTournamentTabLink) {
                throw new RssInvalidFormatException();
            }
            this.containTournamentTabLink = true;
        } else if (typeByte == 0) {
            if (this.containTwitterCupLink) {
                throw new RssInvalidFormatException();
            }
            this.containTwitterCupLink = true;
        }
    }

    public Vector getParsedConfLinks() {
        if (this.confLinks == null) {
            this.confLinks = new Vector();
        }
        return this.confLinks;
    }
}

