/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view;

import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.forms.AboutForm;
import com.sonyericsson.fifa.view.components.forms.AboutLicenseForm;
import com.sonyericsson.fifa.view.components.forms.ArticleForm;
import com.sonyericsson.fifa.view.components.forms.AuthorizationForm;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sonyericsson.fifa.view.components.forms.ChangeTeamForm;
import com.sonyericsson.fifa.view.components.forms.DialogForm;
import com.sonyericsson.fifa.view.components.forms.GNULicenseForm;
import com.sonyericsson.fifa.view.components.forms.ListItemsForm;
import com.sonyericsson.fifa.view.components.forms.MainForm;
import com.sonyericsson.fifa.view.components.forms.MyTeamForm;
import com.sonyericsson.fifa.view.components.forms.SquadForm;
import com.sonyericsson.fifa.view.components.forms.TeamForm;
import com.sonyericsson.fifa.view.components.forms.WelcomeForm;
import com.sonyericsson.fifa.view.dialogs.DialogOkView;
import com.sonyericsson.fifa.view.dialogs.DialogYesNoView;
import com.sonyericsson.fifa.view.language.Language;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sonyericsson.fifa.view.tabs.AboutLicenseView;
import com.sonyericsson.fifa.view.tabs.AboutView;
import com.sonyericsson.fifa.view.tabs.ArticleView;
import com.sonyericsson.fifa.view.tabs.AuthorizationView;
import com.sonyericsson.fifa.view.tabs.ChangeTeamView;
import com.sonyericsson.fifa.view.tabs.EntertaimentView;
import com.sonyericsson.fifa.view.tabs.GNULicenseView;
import com.sonyericsson.fifa.view.tabs.MoreNewsView;
import com.sonyericsson.fifa.view.tabs.MyTeamView;
import com.sonyericsson.fifa.view.tabs.PlayerView;
import com.sonyericsson.fifa.view.tabs.SquadView;
import com.sonyericsson.fifa.view.tabs.TeamView;
import com.sonyericsson.fifa.view.tabs.TournamentView;
import com.sonyericsson.fifa.view.tabs.WelcomeView;

public class ViewFactory {
    private static BaseForm viewForm;
    private static ListItemsForm listItemsForm;
    private static Language language;
    private static ViewFactory viewFactory;
    private static Model model;
    private static EntertaimentView entertainmentView;
    private static MyTeamView myTeamView;
    private static TournamentView tournamentView;
    private static MainForm mainForm;

    public static ViewFactory getViewFactory(Model m) {
        if (viewFactory == null) {
            viewFactory = new ViewFactory();
            model = m;
        }
        return viewFactory;
    }

    public static WaitIndicator getWaitIndicator() {
        return new WaitIndicator();
    }

    public static BaseForm getFormComponent() {
        if (viewForm == null) {
            viewForm = new BaseForm();
        }
        return viewForm;
    }

    public static ArticleForm getArticleForm() {
        return new ArticleForm();
    }

    public static AboutView getAboutView() {
        return new AboutView(model);
    }

    public static AboutForm getAboutForm() {
        return new AboutForm();
    }

    public static TeamView getTeamView(String teamCode) {
        return new TeamView(model, teamCode);
    }

    public static TeamForm getTeamForm() {
        return new TeamForm();
    }

    public static AboutLicenseForm getAboutLicenseForm() {
        return new AboutLicenseForm();
    }

    public static AboutLicenseView getAboutLicenseView() {
        return new AboutLicenseView(model);
    }

    public static GNULicenseForm getGNULicenseForm() {
        return new GNULicenseForm();
    }

    public static GNULicenseView getGNULicenseView() {
        return new GNULicenseView(model);
    }

    public static ListItemsForm getListItemsForm() {
        if (listItemsForm == null) {
            listItemsForm = new ListItemsForm();
        }
        return listItemsForm;
    }

    public static MyTeamForm getMyTeamForm() {
        return new MyTeamForm();
    }

    public static SquadForm getSquadForm() {
        return new SquadForm();
    }

    public static synchronized Language getLanguage() {
        if (language == null) {
            language = new Language();
        }
        return language;
    }

    public static EntertaimentView getEntertainmentView() {
        if (entertainmentView == null) {
            entertainmentView = new EntertaimentView(model);
        }
        return entertainmentView;
    }

    public static ChangeTeamView getChangeTeamView() {
        return new ChangeTeamView(model);
    }

    public static MyTeamView getMyTeamView() {
        if (myTeamView == null) {
            myTeamView = new MyTeamView(model);
        }
        return myTeamView;
    }

    public static WelcomeView getWelcomeView() {
        return new WelcomeView(model);
    }

    public static TournamentView getTournamentView() {
        if (tournamentView == null) {
            tournamentView = new TournamentView(model);
        }
        return tournamentView;
    }

    public static SquadView getSquadView(String countryCode) {
        return new SquadView(model, countryCode);
    }

    public static PlayerView getPlayerView(String countryCode, String playerName) {
        return new PlayerView(model, countryCode, playerName);
    }

    public static MoreNewsView getMoreNewsView(String teamCode) {
        return new MoreNewsView(model, teamCode);
    }

    public static ArticleView getArticleView() {
        return new ArticleView(model);
    }

    public static VideoPlayerView getVideoPlayerView() {
        return new VideoPlayerView(4, model);
    }

    public static VideoPlayerViewHB209 getVideoPlayerViewHB209() {
        return new VideoPlayerViewHB209(14, model);
    }

    public static View getWarningView() {
        return null;
    }

    public static View getNextTabView(int index) {
        switch (index) {
            case 1: {
                return ViewFactory.getMyTeamView();
            }
            case 2: {
                return ViewFactory.getTournamentView();
            }
            case 3: {
                return ViewFactory.getEntertainmentView();
            }
        }
        return null;
    }

    public static ChangeTeamForm getChangeTeamForm() {
        return new ChangeTeamForm();
    }

    public static MainForm getMainForm() {
        if (mainForm == null) {
            mainForm = new MainForm();
        }
        return mainForm;
    }

    public static WelcomeForm getWelcomeForm() {
        return new WelcomeForm();
    }

    public static View getRoamingAlert() {
        return new DialogYesNoView(model, "FANAPP_WARNING_ROAMING_COSTS_TXT");
    }

    public static View getFlightModeAlert() {
        return new DialogOkView(model, "FANAPP_FLIGHT_MODE_TXT");
    }

    public static View getNoNetworkConnectionAlert() {
        return new DialogOkView(model, "FANAPP_ERROR_CONNECTION_FAILED_TXT");
    }

    public static View getNoDiskSpaceAlert() {
        return new DialogOkView(model, "FANAPP_ERROR_MEMORY_FULL_TXT");
    }

    public static View getNoAccessAlert() {
        return new DialogOkView(model, "FANAPP_INTERNAL_ERROR_TXT");
    }

    public static DialogForm getDialogForm(String message, int viewId) {
        return new DialogForm(message, viewId);
    }

    public static AuthorizationView getAuthorizationView() {
        return new AuthorizationView(model);
    }

    public static AuthorizationForm getAuthorizationForm() {
        return new AuthorizationForm();
    }

    public static View getComingSoonAlert() {
        return new DialogOkView(model, "FANAPP_ENTERTAINMENT_COMINGSOON_TXT");
    }
}

