/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.impl.midp.GameCanvasImplementation;
import com.sun.lwuit.util.Resources;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableGraphics;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImplementation
extends GameCanvasImplementation {
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private int id = 0;
    private static int idCounter = 0;

    public void getRGB(Object nativeImage, int[] arr, int offset, int x, int y, int width, int height) {
        if (nativeImage instanceof ScalableImage) {
            ScalableImage s = (ScalableImage)nativeImage;
            ScalableGraphics svgGraphics = ScalableGraphics.createInstance();
            int w = this.getImageWidth(nativeImage);
            int h = this.getImageHeight(nativeImage);
            javax.microedition.lcdui.Image i = javax.microedition.lcdui.Image.createImage((int)w, (int)h);
            Graphics gr = i.getGraphics();
            svgGraphics.bindTarget((Object)gr);
            svgGraphics.render(0, 0, s);
            svgGraphics.releaseTarget();
            i.getRGB(arr, offset, width, x, y, width, height);
        } else {
            super.getRGB(nativeImage, arr, offset, x, y, width, height);
        }
    }

    public Object scale(Object nativeImage, int width, int height) {
        if (nativeImage instanceof ScalableImage) {
            ScalableImage s = (ScalableImage)nativeImage;
            s.setViewportWidth(width);
            s.setViewportHeight(height);
            return s;
        }
        return super.scale(nativeImage, width, height);
    }

    public boolean isOpaque(Image lwuitImage, Object nativeImage) {
        if (nativeImage instanceof ScalableImage) {
            return false;
        }
        return super.isOpaque(lwuitImage, nativeImage);
    }

    public int getImageWidth(Object i) {
        if (i instanceof ScalableImage) {
            return ((ScalableImage)i).getViewportWidth();
        }
        return super.getImageWidth(i);
    }

    public int getImageHeight(Object i) {
        if (i instanceof ScalableImage) {
            return ((ScalableImage)i).getViewportHeight();
        }
        return super.getImageHeight(i);
    }

    public boolean animateImage(Object nativeImage, long lastFrame) {
        if (nativeImage instanceof SVGImage) {
            SVGImage im = (SVGImage)nativeImage;
            long currentTime = System.currentTimeMillis();
            im.incrementTime((float)(currentTime - lastFrame) / 1000.0f);
            return true;
        }
        return false;
    }

    public void drawImage(Object graphics, Object img, int x, int y) {
        if (img instanceof SVGImage) {
            ScalableGraphics svgGraphics = ScalableGraphics.createInstance();
            Graphics gr = (Graphics)graphics;
            gr.setClip(x + gr.getClipX(), y + gr.getClipY(), gr.getClipWidth(), gr.getClipHeight());
            svgGraphics.bindTarget((Object)gr);
            svgGraphics.render(x, y, (ScalableImage)((SVGImage)img));
            svgGraphics.releaseTarget();
        } else {
            super.drawImage(graphics, img, x, y);
        }
    }

    public Object getSVGDocument(Object svgImage) {
        return this.getSVGElement((SVGImage)svgImage);
    }

    private SVGSVGElement getSVGElement(SVGImage im) {
        SVGSVGElement retVal = null;
        Document dom = im.getDocument();
        retVal = (SVGSVGElement)dom.getElementById(this.getClass().getName() + this.id);
        if (retVal == null) {
            retVal = (SVGSVGElement)dom.createElementNS(SVG_NAMESPACE, "svg");
            this.id = idCounter++;
            retVal.setId(this.getClass().getName() + this.id);
        }
        return retVal;
    }

    public Object rotate(Object image, int degrees) {
        if (image instanceof SVGImage) {
            SVGSVGElement e = this.getSVGElement((SVGImage)image);
            SVGPoint p = e.getCurrentTranslate();
            p.setX((float)(-this.getImageWidth(image) / 2));
            p.setY((float)(-this.getImageHeight(image) / 2));
            e.setCurrentRotate((float)degrees);
            p.setX(0.0f);
            p.setY(0.0f);
            return image;
        }
        return super.rotate(image, degrees);
    }

    public boolean isSVGSupported() {
        return true;
    }

    private InputStream openResURL(String url) throws IOException {
        int pos = url.indexOf("!", 7);
        Resources r = Resources.open(url.substring(6, pos));
        return r.getData(url.substring(pos + 1));
    }

    public Object createSVGImage(String baseURL, byte[] data) throws IOException {
        ScalableImage instance = ScalableImage.createImage((InputStream)new ByteArrayInputStream(data), (ExternalResourceHandler)new Handler(baseURL));
        return instance;
    }

    class Handler
    implements ExternalResourceHandler {
        private String baseURL;

        public Handler(String baseURL) {
            this.baseURL = baseURL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestResource(ScalableImage i, String a) {
            InputStream s = null;
            try {
                if (a.indexOf(58) > -1) {
                    s = a.startsWith("res:") ? SVGImplementation.this.openResURL(a) : Connector.openInputStream((String)a);
                    i.requestCompleted(a, s);
                } else if (this.baseURL != null && this.baseURL.indexOf(58) > -1) {
                    String u = this.baseURL;
                    if (!this.baseURL.endsWith("/")) {
                        u = u + "/";
                    }
                    s = u.startsWith("res:") ? SVGImplementation.this.openResURL(u + a) : Connector.openInputStream((String)(u + a));
                    i.requestCompleted(a, s);
                } else {
                    s = Display.getInstance().getResourceAsStream(this.getClass(), a);
                    i.requestCompleted(a, s);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    s.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

