/*
 * Decompiled with CFR 0.152.
 */
package se.vitamin.ui;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import se.vitamin.ui.UI;
import se.vitamin.ui.Widget;
import se.vitamin.ui.Window;

public abstract class Menu
extends Widget {
    protected Vector _items = new Vector();
    private boolean _open = false;
    protected Font _font;
    private int _anchor = 0;
    protected int _currentIndex = 0;
    protected int _leftSpacing = 3;
    protected int _rightSpacing = 3;
    protected int _topSpacing = 3;

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean handleKeyDown(int key) {
        return false;
    }

    public boolean handleKeyUp(int key) {
        return false;
    }

    public boolean handleLongPress(int key) {
        return false;
    }

    public void setBackgroundColor(int color) {
        this._backgroundColor = color;
    }

    public void setActiveColor(int color) {
        this._activeColor = color;
    }

    public void setInactiveColor(int color) {
        this._inactiveColor = color;
    }

    public void setInactiveBackgroundColor(int color) {
        this._inactiveBackgroundColor = color;
    }

    public void paintBackground(Graphics g, int x, int y, int top) {
        g.setColor(this._inactiveBackgroundColor);
        g.fillRect(this._x, y + this._currentIndex * this._font.getHeight(), this._w + this._leftSpacing + this._rightSpacing, this._h);
        g.setColor(this._backgroundColor);
        g.fillRect(this._x, y, this._w + this._leftSpacing + this._rightSpacing, this._font.getHeight());
        g.setColor(this._borderColor);
        g.drawRect(this._x, y, this._w + this._leftSpacing + this._rightSpacing, this._h);
    }

    public void paint(Graphics g, int x, int y) {
        this._h = this._font.getHeight() * this._items.size();
        int top = this._y;
        if (this._anchor == 32) {
            top -= this._h;
        }
        this.paintBackground(g, x, top, this._topSpacing);
        g.setColor(this._inactiveColor);
        for (int i = 0; i < this._items.size(); ++i) {
            MenuItem item;
            if (i == this._currentIndex) {
                g.setColor(this._activeColor);
                item = (MenuItem)this._items.elementAt(i);
                g.drawString(UI.getString(item.str), this._x + this._leftSpacing, top, 0);
                top += this._font.getHeight();
                g.setColor(this._inactiveColor);
                continue;
            }
            item = (MenuItem)this._items.elementAt(i);
            g.drawString(UI.getString(item.str), this._x + this._leftSpacing, top, 0);
            top += this._font.getHeight();
        }
    }

    public void setSpacing(int left, int right, int top) {
        if (left >= 0) {
            this._leftSpacing = left;
        }
        if (right >= 0) {
            this._rightSpacing = right;
        }
        if (top >= 0) {
            this._topSpacing = top;
        }
    }

    public void setDimensions(int x, int y, int w, int h) {
    }

    public void setFont(Font f) {
    }

    public void update() {
    }

    public boolean isOpen() {
        return this._open;
    }

    public boolean toggleOpen() {
        this._open = !this._open;
        return this._open;
    }

    public void open() {
        this._open = true;
    }

    public void close() {
        this._open = false;
    }

    public int nextItem() {
        ++this._currentIndex;
        if (this._currentIndex >= this._items.size()) {
            this._currentIndex = this._items.size() - 1;
        }
        return ((MenuItem)this._items.elementAt((int)this._currentIndex)).id;
    }

    public int prevItem() {
        --this._currentIndex;
        if (this._currentIndex <= 0) {
            this._currentIndex = 0;
        }
        return ((MenuItem)this._items.elementAt((int)this._currentIndex)).id;
    }

    public int selectItem() {
        return ((MenuItem)this._items.elementAt((int)this._currentIndex)).id;
    }

    public void addItem(int id, int s) {
        MenuItem item = new MenuItem();
        item.id = id;
        item.str = s;
        this._items.addElement(item);
        int w = this._font.stringWidth(UI.getString(s));
        if (w > this._w) {
            this._w = w;
        }
    }

    public Menu(Window parent, int id, int x, int y, Font f, int anchor) {
        super(parent, id);
        this._font = f;
        this._x = x;
        this._y = y;
        this._anchor = anchor;
    }

    public void select() {
        System.out.println("Select " + this._id);
    }

    public class MenuItem {
        public int id;
        public int str;
    }
}

