/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.controller;

import com.sonyericsson.fifa.controller.AbstractController;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.datastore.ConfigurationDB;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.model.StartupConfiguration;
import com.sonyericsson.fifa.services.appmanager.RunGameService;
import com.sonyericsson.fifa.services.chapiservice.ChapiListener;
import com.sonyericsson.fifa.services.chapiservice.ChapiService;
import com.sonyericsson.fifa.services.upgrade.ApplicationUpgrade;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.AboutAction;
import com.sonyericsson.fifa.view.action.AboutLicenseAction;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.action.GNULicenseAction;
import com.sonyericsson.fifa.view.action.MoreSelectedAction;
import com.sonyericsson.fifa.view.action.NextTabAction;
import com.sonyericsson.fifa.view.action.OpenGameAction;
import com.sonyericsson.fifa.view.action.OpenLinkAction;
import com.sonyericsson.fifa.view.action.OpenVideoAction;
import com.sonyericsson.fifa.view.action.PlayerAction;
import com.sonyericsson.fifa.view.action.SelectedAction;
import com.sonyericsson.fifa.view.action.SelectedTeamAction;
import com.sonyericsson.fifa.view.action.SelectedTournamentTeamAction;
import com.sonyericsson.fifa.view.action.SquadAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.action.UpdateMyTeamAction;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sonyericsson.fifa.view.tabs.ArticleView;
import com.sonyericsson.fifa.view.tabs.EntertaimentView;
import com.sonyericsson.fifa.view.tabs.MyTeamView;
import com.sonyericsson.fifa.view.tabs.TournamentView;
import com.sonyericsson.fifa.view.tabs.WelcomeView;
import com.sun.lwuit.Display;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.microedition.io.ConnectionNotFoundException;

public class FifaController
extends AbstractController
implements ModelControllerListener {
    private final Stack viewStack = new Stack();

    public FifaController(Model model) {
        this.model = model;
    }

    public void start() {
        if (IOUtility.isMemoryAvailable()) {
            super.start();
            this.model.addModelControllerListener(this);
            this.model.start();
            this.model.updateConfLinks();
        } else {
            Logger.logInfo(this.getClass(), "No memory available at controller startup...");
            DialogsManager.showNoDiskSpaceAlert();
            this.fireControllerShutdown();
        }
    }

    public void doViewActionPerformed(Action action) {
        try {
            if (action instanceof SquadAction) {
                String teamCode = ((SquadAction)action).getTeamCode();
                Team team = this.model.getTeam(teamCode);
                if (team != null && team.getSquad() != null) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getSquadView(teamCode));
                } else if (this.isUpdateAuthorized()) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getSquadView(teamCode));
                    this.model.updateSquadTeam(teamCode);
                } else {
                    this.currentView.show();
                }
            } else if (!(action instanceof PlayerAction)) {
                if (action instanceof ChangeTeamAction) {
                    if (this.model.getMyTeam() != null) {
                        this.model.removeTeamListener(this.model.getMyTeam().getTeamCode(), ViewFactory.getMyTeamView());
                    }
                    if (this.model.isTournamentUpdated()) {
                        this.viewStack.push(this.currentView);
                        this.setCurrentView(ViewFactory.getChangeTeamView());
                    } else if (this.isUpdateAuthorized()) {
                        this.viewStack.push(this.currentView);
                        this.setCurrentView(ViewFactory.getChangeTeamView());
                        this.model.updateTournamentContent();
                    } else {
                        this.currentView.show();
                    }
                } else if (action instanceof SelectedTeamAction) {
                    String contryCode = ((SelectedTeamAction)action).getContryCode();
                    if (this.viewStack.elementAt(0) instanceof WelcomeView) {
                        ((WelcomeView)this.viewStack.elementAt(0)).destroy();
                    }
                    if (this.model.getMyTeam() == null) {
                        this.model.setMyTeam(contryCode);
                        this.doShowStartupView();
                    } else {
                        Team currentTeam = this.model.getMyTeam();
                        if (currentTeam != null && currentTeam.getTeamCode() != null && currentTeam.getTeamCode().equalsIgnoreCase(contryCode)) {
                            this.doShowPreviousView();
                        } else if (this.isUpdateAuthorized()) {
                            this.doChangeTeam(contryCode, true);
                        } else if (this.model.getTeam(contryCode).hasData()) {
                            this.doChangeTeam(contryCode, false);
                        } else {
                            this.doShowPreviousView();
                        }
                    }
                } else if (action instanceof SelectedTournamentTeamAction) {
                    String countryCode = ((SelectedTournamentTeamAction)action).getContryCode();
                    if (this.isUpdateAuthorized()) {
                        this.viewStack.push(this.currentView);
                        this.setCurrentView(ViewFactory.getTeamView(countryCode));
                        this.model.updateTeam(countryCode, false);
                    } else {
                        Team team = this.model.getTeam(countryCode);
                        if (team == null || team.getLatestNews() == null) {
                            this.currentView.show();
                        } else {
                            this.viewStack.push(this.currentView);
                            this.setCurrentView(ViewFactory.getTeamView(countryCode));
                            this.model.getTeam(countryCode).simulateUpdateFinished();
                        }
                    }
                } else if (action instanceof OpenLinkAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedLinks().elementAt(((SelectedAction)action).getIndex());
                    String link = content.getLink();
                    this.doShowBrowser(link);
                } else if (action instanceof OpenVideoAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedVideos().elementAt(((SelectedAction)action).getIndex());
                    this.doShowVideoPlayerView(content.getLink());
                } else if (action instanceof OpenGameAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedGames().elementAt(((SelectedAction)action).getIndex());
                    if (content.getTitle().indexOf("Panini") != -1) {
                        DialogsManager.showComingSoonAlert();
                        this.currentView.show();
                    } else if (SystemProperties.getPhonePlatform() == 2) {
                        ChapiService service = new ChapiService(content.getLink());
                        ChapiListener listener = new ChapiListener(){

                            public void operationResult(boolean result) {
                            }
                        };
                        service.setListener(listener);
                        new Thread(service).start();
                    } else {
                        new Thread(new RunGameService(content.getLink(), null)).start();
                    }
                } else if (action instanceof TeamItemSelectedAction) {
                    ArticleView articleView = ViewFactory.getArticleView();
                    articleView.updateData(((TeamItemSelectedAction)action).getIndex(), ((TeamItemSelectedAction)action).getTeamCode());
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(articleView);
                } else if (action instanceof MoreSelectedAction) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getMoreNewsView(((MoreSelectedAction)action).getTeamCode()));
                } else if (action instanceof BackAction) {
                    this.doShowPreviousView();
                } else if (action instanceof NextTabAction) {
                    byte index = ((NextTabAction)action).getIndexView();
                    this.setCurrentView(ViewFactory.getNextTabView(index));
                    if (this.currentView instanceof MyTeamView) {
                        if (this.model.getMyTeam().getLatestNews() == null) {
                            this.model.updateTeam(this.model.getMyTeam().getTeamCode(), true);
                        }
                    } else if (this.currentView instanceof TournamentView) {
                        if (!this.model.isTournamentUpdated()) {
                            this.model.updateTournamentContent();
                        }
                    } else if (this.currentView instanceof EntertaimentView && !this.model.isPreloadedContentUpdated()) {
                        this.model.updatePreloadedContent();
                    }
                } else if (action instanceof AboutAction) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getAboutView());
                } else if (action instanceof AboutLicenseAction) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getAboutLicenseView());
                } else if (action instanceof GNULicenseAction) {
                    this.viewStack.push(this.currentView);
                    this.setCurrentView(ViewFactory.getGNULicenseView());
                } else if (action instanceof UpdateMyTeamAction) {
                    this.model.getMyTeam().changeToNewData();
                } else if (action instanceof UpdateFailureAction) {
                    UpdateFailureAction failure = (UpdateFailureAction)action;
                    this.doHandleFaultOnCurrentView(failure.getReason(), failure.isViewDisplayable());
                }
            }
        }
        catch (ViewException e) {
            this.doShowNoAccessWarning();
        }
    }

    private void doHandleFaultOnCurrentView(byte reason, boolean viewDisplayable) {
        switch (reason) {
            case 4: {
                DialogsManager.showNoAccessAlert();
                break;
            }
            case 1: {
                DialogsManager.showNoNetworkConnectionAlert();
                break;
            }
            case 2: {
                DialogsManager.showNoDiskSpaceAlert();
                this.fireControllerShutdown();
                break;
            }
            default: {
                Logger.logError(this.getClass(), "doHandleFaultOnCurrentView: unexpected error: " + reason);
            }
        }
        if (viewDisplayable) {
            try {
                this.currentView.show();
            }
            catch (ViewException e) {
                this.doShowNoAccessWarning();
            }
        } else {
            this.doShowPreviousView();
        }
    }

    private boolean isUpdateAuthorized() {
        boolean authorization = true;
        authorization = this.isMemoryAvailable();
        if (authorization && SystemProperties.getPhonePlatform() != 2) {
            boolean bl = authorization = !this.isFlightMode();
        }
        if (authorization) {
            authorization = this.isNetworkingAuthorized();
        }
        if (authorization) {
            authorization = this.isRoamingAuthorized();
        }
        if (SystemProperties.getPhonePlatform() != 3 && SystemProperties.getPhonePlatform() != 0 && authorization && !IOUtility.hasInternetSettings()) {
            authorization = false;
        }
        if (authorization) {
            authorization = this.hasNetworkingConnection();
        }
        return authorization;
    }

    private boolean isMemoryAvailable() {
        boolean memoryAvailable = IOUtility.isMemoryAvailable();
        if (!memoryAvailable) {
            DialogsManager.showNoDiskSpaceAlert();
            this.fireControllerShutdown();
        }
        return memoryAvailable;
    }

    private boolean isFlightMode() {
        boolean flightMode = SystemProperties.isFlightMode();
        if (flightMode) {
            DialogsManager.showFlightModeAlert();
        }
        return flightMode;
    }

    private boolean isNetworkingAuthorized() {
        boolean auth = this.model.isNetworkingAuthorized();
        if (!auth) {
            byte userAuth = DialogsManager.getNetworkingAuthorization().getAuthorization();
            if (userAuth != 2) {
                auth = true;
            }
            if (userAuth == 0) {
                this.model.setNetworkingAuthorization(true);
            }
        }
        return auth;
    }

    private boolean isRoamingAuthorized() {
        if (SystemProperties.isRoaming()) {
            return DialogsManager.getRoamingAuthorization();
        }
        return true;
    }

    private void doShowPreviousView() {
        try {
            View newView = (View)this.viewStack.pop();
            this.setCurrentView(newView);
        }
        catch (EmptyStackException e) {
            this.fireControllerShutdown();
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    private void doShowNoAccessWarning() {
        DialogsManager.showNoAccessAlert();
        this.doShowPreviousView();
    }

    private void doShowBrowser(String url) {
        try {
            SystemProperties.platformRequest(url);
        }
        catch (ConnectionNotFoundException e) {
            Logger.logError(this.getClass(), "ConnectionNotFoundException: " + e.getMessage());
            this.viewStack.push(this.currentView);
            this.doShowNoAccessWarning();
        }
    }

    private void doShowVideoPlayerView(String videoPath) {
        int platform = SystemProperties.getPhonePlatform();
        block4 : switch (platform) {
            case 1: {
                int displayHeight = SystemProperties.getDisplayHeight();
                switch (displayHeight) {
                    case 432: {
                        try {
                            this.viewStack.push(this.currentView);
                            VideoPlayerViewHB209 videoViewHB209 = ViewFactory.getVideoPlayerViewHB209();
                            videoViewHB209.startVideo(videoPath);
                            this.setCurrentView(videoViewHB209);
                        }
                        catch (ViewException e) {
                            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        catch (IOException e) {
                            Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        catch (VideoPlayerException e) {
                            Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        break block4;
                    }
                }
                try {
                    this.viewStack.push(this.currentView);
                    VideoPlayerView videoView = ViewFactory.getVideoPlayerView();
                    videoView.startVideo(videoPath);
                    this.setCurrentView(videoView);
                }
                catch (ViewException e) {
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                catch (IOException e) {
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                catch (VideoPlayerException e) {
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                break;
            }
            case 2: {
                try {
                    Logger.logInfo(this.getClass(), "Symbian plat video path: " + videoPath);
                    SystemProperties.platformRequest(videoPath);
                }
                catch (ConnectionNotFoundException e) {
                    Logger.logError(this.getClass(), "ConnectionNotFoundException: " + e.getMessage());
                    this.viewStack.push(this.currentView);
                    this.doShowNoAccessWarning();
                }
                break;
            }
            default: {
                try {
                    this.viewStack.push(this.currentView);
                    VideoPlayerView videoView = ViewFactory.getVideoPlayerView();
                    videoView.startVideo(videoPath);
                    this.setCurrentView(videoView);
                    break;
                }
                catch (ViewException e) {
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                    break;
                }
                catch (IOException e) {
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                    break;
                }
                catch (VideoPlayerException e) {
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
            }
        }
    }

    public void confLinkReady(byte reason) {
        if (reason == 0) {
            this.model.updateTeamList();
            this.model.updateTournamentContent();
        } else {
            Logger.logError(this.getClass(), "confLinkReady, unexpected failure reason: " + reason);
            this.doHandleFaultOnCurrentView(reason, false);
        }
    }

    public void modelReady(byte reason) {
        if (reason == 0) {
            String myTeamCode = null;
            this.model.removeModelControllerListener();
            ConfigurationDB configurationDB = new ConfigurationDB();
            StartupConfiguration startupConfiguration = configurationDB.retrieveConfiguration();
            myTeamCode = startupConfiguration.getMyTeamCountryCode();
            if (myTeamCode != null) {
                this.model.setMyTeam(myTeamCode);
            }
            this.doShowStartupView();
        } else {
            Logger.logError(this.getClass(), "modelReady, unexpected failure reason: " + reason);
            this.doHandleFaultOnCurrentView(reason, false);
        }
    }

    private void removeAllViews() {
        while (this.viewStack.size() > 0) {
            View view = (View)this.viewStack.pop();
            if (!(view instanceof MyTeamView)) continue;
            ((MyTeamView)view).focusFirstItem();
        }
    }

    private void doChangeTeam(String countryCode, boolean update) {
        this.removeAllViews();
        if (this.model.getMyTeam() != null) {
            this.model.getMyTeam().cancelScheduledUpdate();
        }
        this.model.setMyTeam(countryCode);
        ViewFactory.getMyTeamView().setFirstUpdate(true);
        try {
            this.setCurrentView(ViewFactory.getMyTeamView());
            if (update) {
                this.model.updateTeam(countryCode, true);
            } else {
                this.model.getMyTeam().simulateUpdateFinished();
            }
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    private void doShowStartupView() {
        this.viewStack.removeAllElements();
        try {
            Team myTeam = this.model.getMyTeam();
            String myTeamCode = null;
            if (myTeam != null) {
                myTeamCode = myTeam.getTeamCode();
            }
            if (myTeamCode == null) {
                this.setCurrentView(ViewFactory.getWelcomeView());
            } else {
                ViewFactory.getMyTeamView().setFirstUpdate(true);
                this.setCurrentView(ViewFactory.getMyTeamView());
                boolean authorized = this.isUpdateAuthorized();
                this.currentView.show();
                if (this.model.getTeam(myTeamCode).hasData()) {
                    this.model.getTeam(myTeamCode).simulateUpdateFinished();
                }
                if (authorized) {
                    this.model.updateTeam(myTeamCode, true);
                    if (!ApplicationUpgrade.isUpdateStarted()) {
                        ApplicationUpgrade.start();
                    }
                } else if (myTeam.getLatestNews() == null) {
                    this.fireControllerShutdown();
                }
            }
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "Exception: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    public final void showCurrentView() {
        if (this.currentView != null) {
            this.currentView.showNotify();
        }
    }

    public final void pauseCurrentView() {
        if (this.currentView != null) {
            Display.getInstance().keyReleased(0);
            this.currentView.pausedNotify();
        }
    }

    private boolean hasNetworkingConnection() {
        boolean hasNet = IOUtility.hasNetworkingConnection();
        if (!hasNet) {
            DialogsManager.showNoNetworkConnectionAlert();
        }
        return hasNet;
    }
}

