/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.utils;

import com.sonyericsson.fifa.data.TeamCode;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.datastore.FeedDB;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.IOUtility;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FeedFileCleaner {
    private static final Hashtable protectedFiles = new Hashtable();
    private static final Vector allFiles = new Vector();
    private static final String ALL_FILES = "*";
    private static String rootFolder = Configuration.getDownloadImageDirectory();

    private static void addProtectedFeed(Feed newFeed) {
        if (newFeed != null) {
            Vector items = newFeed.getItems();
            int size = items.size();
            int i = 0;
            while (i < size) {
                FeedFileCleaner.put(((FeedItem)items.elementAt(i)).getEnclosure().getPath(), true);
                FeedFileCleaner.put(((FeedItem)items.elementAt(i)).getEnclosure().getThumbPath(), true);
                ++i;
            }
        }
    }

    public static void cleanUpFeedFiles() {
        FeedDB db = null;
        int i = 0;
        while (i < TeamCode.TEAMS.length) {
            try {
                db = new FeedDB(TeamCode.TEAMS[i]);
                Feed feed = db.retrieveFeed();
                FeedFileCleaner.addProtectedFeed(feed);
            }
            catch (Exception feed) {
                // empty catch block
            }
            ++i;
        }
        Vector files = FeedFileCleaner.filterFiles(rootFolder, ALL_FILES);
        int size = files.size();
        int i2 = 0;
        while (i2 < size) {
            String path = (String)files.elementAt(i2);
            boolean protect = FeedFileCleaner.get(path);
            if (!protect) {
                IOUtility.deleteFiles(path);
            }
            ++i2;
        }
    }

    private static void put(String filePath, boolean protect) {
        if (filePath != null) {
            protectedFiles.put(filePath, new Boolean(protect));
        }
    }

    private static boolean get(String key) {
        Object obj = protectedFiles.get(key);
        if (obj != null) {
            return (Boolean)obj;
        }
        return false;
    }

    private static Vector filterFiles(String path, String filter) {
        if (path != null) {
            Enumeration files = null;
            FileConnection fileConnection = null;
            try {
                try {
                    fileConnection = (FileConnection)Connector.open((String)path, (int)3);
                    if (fileConnection.exists()) {
                        if (fileConnection.isDirectory()) {
                            files = fileConnection.list(filter, true);
                            while (files.hasMoreElements()) {
                                FeedFileCleaner.filterFiles(String.valueOf(path) + (String)files.nextElement(), filter);
                            }
                        } else {
                            allFiles.addElement(fileConnection.getURL());
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        fileConnection.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    fileConnection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return allFiles;
    }
}

