/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.list.Item;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import java.io.IOException;

public class ListItem
extends Item {
    private Label icon = null;
    protected Container iconContainer = null;
    private String action = null;
    static final Image[] borderImage = new Image[2];
    public static final String SHOW_HEADLINE = "show";
    public static final String HIDE_HEADLINE = "hide";
    private static final String BORDER_UNSELECTED = "border_unselected.png";
    private static final String BORDER_SELECTED = "border_selected.png";
    protected final Attributes attributes = VerifyScreenDimension.getAttributesInstance();

    public ListItem() {
        this(null, null, null);
    }

    public ListItem(String firstLineText, String secondLineText, String imagePath) {
        this.setLayout(new BoxLayout(1));
        this.getStyle().setBgTransparency(0);
        this.setTitleText(firstLineText);
        this.setSubtitleText(secondLineText);
        try {
            ListItem.borderImage[0] = Image.createImage(IOUtility.getImageFromRES(BORDER_SELECTED));
            ListItem.borderImage[1] = Image.createImage(IOUtility.getImageFromRES(BORDER_UNSELECTED));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getIconContainer().addComponent(this.getIcon());
        this.addComponent(this.getIconContainer());
        this.addComponent(this.getTitle());
        this.setFocus(false);
        this.setFocusable(true);
        this.setPicture(imagePath);
    }

    protected Container getIconContainer() {
        if (this.iconContainer == null) {
            this.iconContainer = new Container(new BoxLayout(2));
            this.iconContainer.setPreferredSize(new Dimension(this.attributes.getPhotoPlayerDimension(), this.attributes.getPhotoPlayerDimension()));
            this.iconContainer.getStyle().setPadding(0, 0, 0, 0);
            this.iconContainer.getStyle().setMargin(this.attributes.getListItemIconContainerTopPad(), this.attributes.getListItemIconContainerBottomPad(), 5, 5);
            this.iconContainer.getStyle().setBgImage(borderImage[1]);
        }
        return this.iconContainer;
    }

    private Label getIcon() {
        if (this.icon == null) {
            this.icon = new Label();
            this.icon.setAlignment(4);
            this.icon.setPreferredSize(new Dimension(this.attributes.getPhotoPlayerDimension() - 2, this.attributes.getPhotoPlayerDimension() - 2));
            this.icon.setSize(this.icon.getPreferredSize());
            this.icon.getStyle().setBorder(Border.createEmpty());
            this.icon.getStyle().setBgTransparency(0);
            this.icon.getStyle().setPadding(0, 0, 0, 0);
            this.icon.getStyle().setMargin(this.attributes.getListItemIconTopPad(), this.attributes.getListItemIconBottomPad(), this.attributes.getListItemIconLeftPad(), this.attributes.getListItemIconRightPad());
        }
        return this.icon;
    }

    public void setIconMargin(int top, int bottom, int left, int right) {
        this.iconContainer.getStyle().setMargin(top, bottom, left, right);
    }

    public void setListItemDimension(int width, int height) {
        if (width >= 0 && height >= 0) {
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public void setItemDimension(int width, int height) {
        if (width >= 0 && height >= 0) {
            this.setDimension(width, height);
        }
    }

    public void alignToRightInHeadline() {
        int minMargin = 6;
        int posX = VerifyScreenDimension.getAttributesInstance().getWidth() - this.getPreferredW() - 15;
        if (posX >= minMargin) {
            this.setX(posX);
        } else {
            this.setX(minMargin);
        }
    }

    public void setPicture(String picturePath) {
        if (picturePath != null && picturePath.length() > 0) {
            try {
                Image img = Image.createImage(IOUtility.openFileInputStream(picturePath));
                this.getIcon().setIcon(img);
            }
            catch (IOException e) {
                this.getIcon().setIcon(Images.getListIconDefault());
            }
            catch (Exception e) {
                Logger.logError(this.getClass(), "Exception to read image " + picturePath);
            }
            this.getIconContainer().getStyle().setBgImage(borderImage[1]);
        }
    }

    public void setPicture(Image icon) {
        this.getIcon().setIcon(icon);
        this.getIconContainer().getStyle().setBgImage(borderImage[1]);
    }

    protected void focusGained() {
        super.focusGained();
        this.getStyle().setBgImage(Images.getHighlightImg());
        this.getIconContainer().getStyle().setBgImage(borderImage[0]);
    }

    public void setBackgroundHighlightImg() {
        this.getStyle().setBgImage(Images.getHighlightImg());
    }

    protected void focusLost() {
        super.focusLost();
        this.getIconContainer().getStyle().setBgImage(borderImage[1]);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setIconDimension(int width, int height) {
        this.getIcon().setPreferredSize(new Dimension(width, height));
        this.getIconContainer().setPreferredSize(new Dimension(width, height));
    }

    public void setRoundedAndWhiteBorder() {
        this.getStyle().setBgTransparency(255);
        this.getStyle().setBorder(Border.createRoundBorder(10, 10, 0xFFFFFF));
    }

    public void removePicture() {
        this.removeComponent(this.getIconContainer());
    }
}

