/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sun.lwuit.Container;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import java.io.IOException;

class Title
extends Container {
    private Label title = null;
    private Label subtitle = null;
    private Label optionList = null;
    private Image background = null;

    public Title() {
        this.setFocus(false);
        this.setFocusable(false);
        this.setLayout(new BoxLayout(2));
        FifaLookAndFeelManager.configToTitleStyle(this);
        this.init();
        this.addComponent(this.title);
        this.addComponent(this.subtitle);
        this.getStyle().setBgImage(this.background);
    }

    private void init() {
        if (this.title == null) {
            this.title = new Label();
            FifaLookAndFeelManager.configToFirstLineStyle(this.title);
            FifaLookAndFeelManager.configToTransparencyStyle(this.title);
        }
        if (this.subtitle == null) {
            this.subtitle = new Label();
            FifaLookAndFeelManager.configToSecondLineStyle(this.subtitle);
            FifaLookAndFeelManager.configToTransparencyStyle(this.subtitle);
        }
        if (this.optionList == null) {
            this.optionList = new Label();
            FifaLookAndFeelManager.configToOptionListLineStyle(this.optionList);
            FifaLookAndFeelManager.configToTransparencyStyle(this.optionList);
        }
    }

    public void configFirstLineBlack() {
        if (this.title != null) {
            FifaLookAndFeelManager.configToFirstLineBlackStyle(this.title);
        }
    }

    public void setDimension(int width, int height) {
        if (width >= 0 && height >= 0) {
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public void setTitleText(String titleText) {
        if (this.title != null) {
            this.title.setText(titleText);
        }
    }

    public void setSubtitleText(String subtitleText) {
        if (this.subtitle != null) {
            this.subtitle.setText(subtitleText);
        }
    }

    public void setOptionListText(String optionText) {
        if (this.optionList != null) {
            this.optionList.setText(optionText);
        }
    }

    public void setBackground(String backgroundImagePath) throws IOException {
        this.background = Image.createImage(IOUtility.getImageFromRES(backgroundImagePath));
        this.getStyle().setBgImage(this.background);
    }

    public void alignTitleToCenter() {
        this.title.setAlignment(4);
    }

    public void setTitlePadding(int orientation, int gap) {
        if (orientation >= 0 && gap >= 0) {
            this.title.getStyle().setPadding(orientation, gap);
        }
    }

    public void setSubtitlePadding(int orientation, int gap) {
        if (orientation >= 0 && gap >= 0) {
            this.subtitle.getStyle().setPadding(orientation, gap);
        }
    }

    public void setBackground(Image backgroundImage) {
        this.background = backgroundImage;
        this.getStyle().setBgImage(this.background);
    }

    public Label getTitle() {
        return this.title;
    }

    public Label getSubtitle() {
        return this.subtitle;
    }

    public void setTitleFont(Font font) {
        if (font != null) {
            this.title.getStyle().setFont(font);
        }
    }
}

