/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.components.forms.ArticleForm;
import java.io.IOException;
import java.util.Vector;

public class ArticleView
extends FifaAbstractView {
    private ArticleForm articleForm = ViewFactory.getArticleForm();
    private FeedItem item;

    public ArticleView(Model model) {
        super(7, model);
    }

    protected void doHide() {
        super.doHide();
        this.articleForm.setKeyListener(null);
        this.articleForm.setTouchListener(null);
    }

    protected void doShow() throws ViewException {
        this.articleForm.show();
        this.articleForm.setKeyListener(this);
        this.articleForm.setTouchListener(this);
    }

    public void onKeyPressed(int keyCode) {
        this.performSoftkey();
    }

    public void onTouchPressed(int valX, int valY) {
        this.performSoftkey();
    }

    public void updateData(int index, String teamCode) {
        Vector items = this.model.getTeam(teamCode).getLatestNews().getItems();
        if (items != null) {
            this.item = (FeedItem)items.elementAt(index);
            this.updateView();
        }
    }

    public void performSoftkey() {
        if (-7 == this.articleForm.getSelectedSoftkey()) {
            BackAction backAction = new BackAction();
            this.fireViewActionPerformed(backAction);
        }
    }

    protected void doUpdateView() {
        if (this.item != null) {
            this.articleForm.setTitle(this.item.getTitle());
            this.articleForm.setDescription(this.item.getDescription());
            String picturePath = this.item.getEnclosure().getPath();
            try {
                if (picturePath == null) {
                    this.articleForm.setPicture(Images.getArticleIconDefault());
                } else {
                    this.articleForm.setPicture(picturePath);
                }
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "Error to read image: " + picturePath);
                this.articleForm.setPicture(Images.getArticleIconDefault());
            }
        }
    }

    protected void doClearFormText() {
        this.articleForm.refreshAll();
        this.articleForm.revalidate();
    }
}

