/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaAbstractView;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.action.AboutAction;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.action.MoreSelectedAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.action.UpdateMyTeamAction;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sonyericsson.fifa.view.tabs.BackgroundTask;
import com.sonyericsson.fifa.view.tabs.TabView;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.util.Vector;

public class MyTeamView
extends TabView
implements TeamListener {
    private Model model = null;
    private boolean isShowingWaitIndicator = false;
    private boolean isFirstUpdate = true;
    private boolean isFirstShow = true;
    private boolean isFirstCrossfadePositioning = true;
    private boolean updateOrdered = false;
    private Vector headlineImages;
    private String teamCode;
    public static final String FLAG_NAME = "_SMALL";
    public boolean isTickerVisible;

    public MyTeamView(Model model) {
        super(1, model);
        this.model = model;
        this.headlineImages = new Vector();
        this.mainForm.myTeamAddGroups();
    }

    protected int getNextTab() {
        return 2;
    }

    protected int getPreviousTab() {
        return 3;
    }

    protected void doShow() throws ViewException {
        this.teamCode = this.model.getMyTeam().getTeamCode();
        this.model.addTeamListener(this.teamCode, this);
        this.viewId = 1;
        if (this.isFirstShow) {
            this.isShowingWaitIndicator = true;
            if (this.selectedItem) {
                this.mainForm.showWaitIndicator(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"));
            }
        } else if (!this.isShowingWaitIndicator) {
            if (this.model.getMyTeam().isTeamNewsUpdating()) {
                this.isTickerVisible = true;
                this.mainForm.addFeedTicker(false);
            } else {
                if (this.model.getMyTeam().isTeamNewsUpdatedWithNewItems()) {
                    this.isTickerVisible = true;
                    this.mainForm.addFeedTicker(true);
                } else if (this.isTickerVisible) {
                    this.isTickerVisible = false;
                    this.mainForm.removeFeedTicker();
                }
                if (!this.selectedItem) {
                    this.focusFirstItem();
                }
            }
        }
        this.isFirstShow = false;
        this.selectedItem = false;
        this.mainForm.show();
        this.mainForm.startCrossfade(0);
        this.mainForm.addSelectedItemListener(this);
        this.mainForm.setKeyListener(this);
        this.mainForm.setTouchListener(this);
    }

    public void focusFirstItem() {
        this.mainForm.focusFirstItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), true);
    }

    protected void doHide() {
        super.doHide();
        this.mainForm.pauseCrossfade(0);
    }

    public void teamUpdateStarted() {
        new BackgroundTask(){

            public void performTask() {
                if (!MyTeamView.this.isShowingWaitIndicator) {
                    MyTeamView.this.isTickerVisible = true;
                    MyTeamView.this.mainForm.addFeedTicker(false);
                    if (MyTeamView.this.mainForm.isFirstItemFocused(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"))) {
                        MyTeamView.this.focusFirstItem();
                    }
                }
            }
        }.start();
    }

    public void teamUpdateFinished(final boolean newItemsAvailable, String teamCodeUpdated) {
        if (teamCodeUpdated.compareTo(this.teamCode) == 0) {
            new BackgroundTask(){

                public void performTask() {
                    if (newItemsAvailable) {
                        MyTeamView.this.updateView();
                    } else {
                        if (MyTeamView.this.isTickerVisible && !MyTeamView.this.model.getMyTeam().isTeamNewsUpdatedWithNewItems()) {
                            MyTeamView.this.mainForm.removeFeedTicker();
                            MyTeamView.this.isTickerVisible = false;
                        }
                        if (MyTeamView.this.isFirstUpdate) {
                            MyTeamView.this.headlineImages.removeAllElements();
                            MyTeamView.this.updateView();
                        }
                    }
                    if (MyTeamView.this.mainForm.isFirstItemFocused(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT")) && !MyTeamView.this.model.getMyTeam().isTeamNewsUpdating()) {
                        MyTeamView.this.focusFirstItem();
                    }
                }
            }.start();
        }
    }

    private void addComponents() {
        this.mainForm.setMyTeamHeadline(this.getDefaultHeadLinePictures());
        if (this.isFirstCrossfadePositioning) {
            this.mainForm.setCrossfadePosition(0, FifaAbstractView.attributes.getCrossfadeImageBoderPosX());
            this.isFirstCrossfadePositioning = false;
        }
        this.mainForm.addCountryDataItem(this.getTeamGroup(this.teamCode), String.valueOf(this.teamCode) + FLAG_NAME);
        this.addNewsItems();
        this.addTeamItems();
        this.focusFirstItem();
    }

    private void addNewsItems() {
        Enclosure enclosure = null;
        int maxItensDisp = FifaAbstractView.attributes.getMaxItemsDisplayed();
        Vector items = this.model.getTeam(this.teamCode).getLatestNews().getItems();
        int countItems = items.size();
        int i = 0;
        while (i < countItems && i < maxItensDisp) {
            FeedItem item = (FeedItem)items.elementAt(i);
            enclosure = item.getEnclosure();
            if (enclosure != null && enclosure.getThumbPath() != null) {
                this.mainForm.addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), item.getTitle(), SystemProperties.escapeHTML(item.getDescription()), enclosure.getThumbPath());
                this.setHealineImages(i, enclosure.getPath());
            } else {
                this.mainForm.addItem(0, FifaResources.getMessage("FANAPP_MYTEAM_TITLE_NEWS_TXT"), item.getTitle(), SystemProperties.escapeHTML(item.getDescription()), Images.getListIconDefault());
            }
            ++i;
        }
        this.mainForm.addMoreItem();
    }

    private void addTeamItems() {
        this.mainForm.addSquadItem();
        this.mainForm.addChangeTeamItem();
        this.mainForm.addAboutItem();
    }

    public void thumbnailDownloaded(int index, Enclosure thumbnail) {
        this.updateThumbnail(index, thumbnail);
    }

    public void selectedItem(int index, int subGroup) {
        this.selectedItem = true;
        if (subGroup == 0) {
            if (this.isTickerVisible) {
                --index;
            }
            if (index == -1) {
                if (this.isTickerVisible) {
                    this.isTickerVisible = false;
                    this.mainForm.removeFeedTicker();
                }
                this.updateOrdered = true;
                this.fireViewActionPerformed(new UpdateMyTeamAction());
            } else if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
                TeamItemSelectedAction teamItemAction = new TeamItemSelectedAction(index, this.teamCode);
                this.fireViewActionPerformed(teamItemAction);
            } else {
                this.fireViewActionPerformed(new MoreSelectedAction(this.teamCode));
            }
        } else if (subGroup == 1) {
            switch (index) {
                case 0: {
                    DialogsManager.showComingSoonAlert();
                    try {
                        this.show();
                    }
                    catch (ViewException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    this.fireViewActionPerformed(new ChangeTeamAction());
                    break;
                }
                case 2: {
                    this.fireViewActionPerformed(new AboutAction());
                }
            }
        }
    }

    public void performSoftkey() {
    }

    protected void doUpdateView() {
        if (this.isFirstShow) {
            this.headlineImages.removeAllElements();
            this.addComponents();
            this.isFirstShow = false;
        } else if (this.isFirstUpdate || this.updateOrdered) {
            this.isTickerVisible = false;
            this.isFirstUpdate = false;
            this.updateOrdered = false;
            this.mainForm.myTeamRemoveAll();
            this.headlineImages.removeAllElements();
            this.isShowingWaitIndicator = false;
            this.addComponents();
            this.mainForm.show();
        } else if (!this.isShowingWaitIndicator) {
            this.isTickerVisible = true;
            this.mainForm.addFeedTicker(true);
        }
        this.mainForm.revalidate();
    }

    public void setFirstUpdate(boolean isFirstUpdate) {
        this.mainForm.refreshAll(0, false);
        this.isFirstUpdate = isFirstUpdate;
        this.isFirstShow = true;
    }

    protected void doUpdateThumbnail(int index, Enclosure thumbnail) {
        if (index < FifaAbstractView.attributes.getMaxItemsDisplayed()) {
            this.mainForm.setItemPicture(index, thumbnail.getThumbPath());
        }
        this.setHealineImages(index, thumbnail.getPath());
    }

    private void setHealineImages(int index, String imagePath) {
        if (this.headlineImages != null) {
            if (this.headlineImages.size() < 3) {
                try {
                    Image img = Image.createImage(IOUtility.openFileInputStream(imagePath)).scaled(FifaAbstractView.attributes.getHeadlinePictureWidth(), FifaAbstractView.attributes.getHeadlinePictureHeight());
                    this.headlineImages.addElement(img);
                    this.mainForm.setMyTeamHeadline(this.headlineImages);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.headlineImages.size() == 2) {
                this.mainForm.startCrossfade(0);
            }
        }
    }

    protected void doClearFormText() {
        if (!this.mainForm.isGroupEmpty(0)) {
            this.mainForm.refreshAll(0, true);
            this.isFirstShow = true;
            this.updateView();
        } else {
            this.mainForm.refreshAll(0, true);
        }
    }

    public void teamUpdateFailed(byte reason) {
        Team myTeam = this.model.getMyTeam();
        if (myTeam != null && myTeam.getLatestNews() != null) {
            this.fireViewActionPerformed(new UpdateFailureAction(reason, true));
            new BackgroundTask(){

                public void performTask() {
                    if (MyTeamView.this.isShowingWaitIndicator) {
                        if (MyTeamView.this.isFirstUpdate) {
                            MyTeamView.this.headlineImages.removeAllElements();
                        }
                        MyTeamView.this.updateView();
                    } else if (MyTeamView.this.isTickerVisible) {
                        MyTeamView.this.isTickerVisible = false;
                        MyTeamView.this.mainForm.removeFeedTicker();
                    }
                }
            }.start();
        } else {
            this.fireViewActionPerformed(new UpdateFailureAction(reason, false));
        }
    }
}

