/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.Painter;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;
import java.util.Vector;

public class Form
extends Container {
    Command selectMenuItem;
    Command cancelMenuItem;
    private Painter glassPane;
    private Container contentPane = new Container(new FlowLayout());
    private Label title = new Label("", "Title");
    private MenuBar menuBar = new MenuBar();
    private Command selectCommand;
    private Command defaultCommand;
    private Component dragged;
    private Command backCommand;
    static boolean comboLock;
    private Command clearCommand;
    private Vector animatableComponents;
    private Vector internalAnimatableComponents;
    static int leftSK;
    static int rightSK;
    static int rightSK2;
    static int backSK;
    static int clearSK;
    static int backspaceSK;
    private Component focused;
    private Vector mediaComponents;
    private Transition transitionInAnimator;
    private Transition transitionOutAnimator;
    private EventDispatcher commandListener;
    private EventDispatcher pointerPressedListeners;
    private EventDispatcher pointerReleasedListeners;
    private EventDispatcher pointerDraggedListeners;
    private Form previousForm;
    private boolean tint;
    private int tintColor;
    private Vector focusDownSequence;
    private Vector focusRightSequence;
    private Hashtable keyListeners;
    private Hashtable gameKeyListeners;
    private boolean cyclicFocus = true;
    private int tactileTouchDuration;

    public Form() {
        super(new BorderLayout());
        this.setUIID("Form");
        this.setVisible(false);
        Style formStyle = this.getStyle();
        int w = Display.getInstance().getDisplayWidth() - (formStyle.getMargin(this.isRTL(), 1) + formStyle.getMargin(this.isRTL(), 3));
        int h = Display.getInstance().getDisplayHeight() - (formStyle.getMargin(false, 0) + formStyle.getMargin(false, 2));
        this.setWidth(w);
        this.setHeight(h);
        this.setPreferredSize(new Dimension(w, h));
        this.title.setEndsWith3Points(false);
        super.addComponent("North", (Component)this.title);
        super.addComponent("Center", (Component)this.contentPane);
        super.addComponent("South", (Component)this.menuBar);
        this.contentPane.setUIID("ContentPane");
        this.contentPane.setScrollableY(true);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.initLaf(laf);
        this.tintColor = laf.getDefaultFormTintColor();
        this.selectMenuItem = this.createMenuSelectCommand();
        this.cancelMenuItem = this.createMenuCancelCommand();
        formStyle.setBgTransparency(255);
    }

    public void setMenuStyle(Style s) {
        this.menuBar.setStyle(s);
    }

    public void setSoftButtonStyle(Style s) {
        this.menuBar.setUnSelectedStyle(s);
    }

    public Style getSoftButtonStyle() {
        return this.menuBar.getStyle();
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void sizeChanged(int w, int h) {
    }

    void sizeChangedInternal(int w, int h) {
        this.sizeChanged(w, h);
        this.setSize(new Dimension(w, h));
        this.setShouldCalcPreferredSize(true);
        this.doLayout();
        this.repaint();
    }

    public void setGlassPane(Painter glassPane) {
        this.glassPane = glassPane;
        this.repaint();
    }

    public Painter getGlassPane() {
        return this.glassPane;
    }

    public void setTitleStyle(Style s) {
        this.title.setUnSelectedStyle(s);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void setTitleComponent(Label title) {
        super.replace(this.title, title);
        this.title = title;
    }

    public void setTitleComponent(Label title, Transition t) {
        super.replace(this.title, title, t);
        this.title = title;
    }

    public void addKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    private void addKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        Integer code;
        Vector<ActionListener> vec;
        if (keyListeners == null) {
            keyListeners = new Hashtable();
        }
        if ((vec = (Vector<ActionListener>)keyListeners.get(code = new Integer(keyCode))) == null) {
            vec = new Vector<ActionListener>();
            vec.addElement(listener);
            keyListeners.put(code, vec);
            return;
        }
        if (!vec.contains(listener)) {
            vec.addElement(listener);
        }
    }

    private void removeKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        if (keyListeners == null) {
            return;
        }
        Integer code = new Integer(keyCode);
        Vector vec = (Vector)keyListeners.get(code);
        if (vec == null) {
            return;
        }
        vec.removeElement(listener);
        if (vec.size() == 0) {
            keyListeners.remove(code);
        }
    }

    public void addGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            this.gameKeyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    public int getSoftButtonCount() {
        return this.menuBar.getSoftButtons().length;
    }

    public Button getSoftButton(int offset) {
        return this.menuBar.getSoftButtons()[offset];
    }

    public Style getMenuStyle() {
        return this.menuBar.getMenuStyle();
    }

    public Style getTitleStyle() {
        return this.title.getStyle();
    }

    Form getPreviousForm() {
        return this.previousForm;
    }

    void initLaf(LookAndFeel laf) {
        this.transitionOutAnimator = laf.getDefaultFormTransitionOut();
        this.transitionInAnimator = laf.getDefaultFormTransitionIn();
    }

    void clearFocusVectors() {
        this.focusDownSequence = null;
        this.focusRightSequence = null;
    }

    void setDraggedComponent(Component dragged) {
        this.dragged = dragged;
    }

    synchronized void initFocusRight() {
        if (this.focusRightSequence == null) {
            this.focusRightSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusRightSequence, true);
        }
    }

    synchronized void initFocusDown() {
        if (this.focusDownSequence == null) {
            this.focusDownSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusDownSequence, false);
        }
    }

    private void addSortedComponentRight(Vector components, Component c) {
        int componentCount = components.size();
        int componentX = c.getAbsoluteX();
        int bestSpot = 0;
        boolean rtl = this.isRTL();
        Component scrollableParent = this.findScrollableAncestor(c);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = (Component)components.elementAt(iter);
            Component currentScrollParent = this.findScrollableAncestor(current);
            if (currentScrollParent == scrollableParent) {
                if (this.isInSameRow(current, c)) {
                    int currentX = current.getAbsoluteX();
                    if (!rtl && currentX > componentX || rtl && currentX < componentX) continue;
                    bestSpot = iter + 1;
                    continue;
                }
            } else {
                Component tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                Component tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (!rtl && tempCurrentScrollParent.getAbsoluteX() > tempScrollableParent.getAbsoluteX() || rtl && tempCurrentScrollParent.getAbsoluteX() < tempScrollableParent.getAbsoluteX()) continue;
                if (this.isInSameRow(tempCurrentScrollParent, tempScrollableParent)) {
                    bestSpot = iter + 1;
                    continue;
                }
            }
            if (current.getAbsoluteY() >= c.getAbsoluteY()) continue;
            bestSpot = iter + 1;
        }
        components.insertElementAt(c, bestSpot);
    }

    private Component findScrollableAncestor(Component c) {
        if ((c = c.getParent()) == null || c.isScrollable()) {
            return c;
        }
        return this.findScrollableAncestor(c);
    }

    private void addSortedComponentDown(Vector components, Component c) {
        int componentCount = components.size();
        int componentY = c.getAbsoluteY();
        int bestSpot = 0;
        boolean rtl = this.isRTL();
        Component scrollableParent = this.findScrollableAncestor(c);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = (Component)components.elementAt(iter);
            Component currentScrollParent = this.findScrollableAncestor(current);
            if (currentScrollParent == scrollableParent) {
                if (this.isInSameColumn(current, c)) {
                    int currentY = current.getAbsoluteY();
                    if (currentY > componentY) continue;
                    bestSpot = iter + 1;
                    continue;
                }
            } else {
                Component tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                Component tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (tempCurrentScrollParent.getAbsoluteY() > tempScrollableParent.getAbsoluteY()) continue;
                if (this.isInSameColumn(tempCurrentScrollParent, tempScrollableParent)) {
                    bestSpot = iter + 1;
                    continue;
                }
            }
            if ((rtl || current.getAbsoluteX() >= c.getAbsoluteX()) && (!rtl || current.getAbsoluteX() <= c.getAbsoluteX())) continue;
            bestSpot = iter + 1;
        }
        components.insertElementAt(c, bestSpot);
    }

    private boolean isInSameColumn(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), source.getWidth(), Integer.MAX_VALUE, dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private boolean isInSameRow(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), Integer.MAX_VALUE, source.getHeight(), dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private void addSortedComponent(Vector components, Component c, boolean toTheRight) {
        if (toTheRight) {
            this.addSortedComponentRight(components, c);
        } else {
            this.addSortedComponentDown(components, c);
        }
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command clearCommand) {
        this.clearCommand = clearCommand;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    public void setBackCommand(Command backCommand) {
        this.backCommand = backCommand;
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    private void findAllFocusable(Container c, Vector v, boolean toTheRight) {
        int size = c.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container) {
                this.findAllFocusable((Container)current, v, toTheRight);
            }
            if (!current.isFocusable()) continue;
            this.addSortedComponent(v, current, toTheRight);
        }
    }

    public Form(String title) {
        this();
        this.title.setText(title);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setBgImage(Image bgImage) {
        this.getStyle().setBgImage(bgImage);
    }

    public void setLayout(Layout layout) {
        this.contentPane.setLayout(layout);
    }

    public void setTitle(String title) {
        this.title.setText(title);
        if (this.isInitialized() && this.title.isTickerEnabled()) {
            if (this.title.shouldTickerStart()) {
                this.title.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
            } else if (this.title.isTickerRunning()) {
                this.title.stopTicker();
            }
        }
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.contentPane.addComponent(constraints, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.contentPane.addComponent(index, constraints, cmp);
    }

    public void addComponent(int index, Component cmp) {
        this.contentPane.addComponent(index, cmp);
    }

    public void replace(Component current, Component next, Transition t) {
        this.contentPane.replace(current, next, t);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.contentPane.replaceAndWait(current, next, t);
    }

    public void removeComponent(Component cmp) {
        this.contentPane.removeComponent(cmp);
    }

    void registerMediaComponent(Component mediaCmp) {
        if (this.mediaComponents == null) {
            this.mediaComponents = new Vector();
        }
        if (!this.mediaComponents.contains(mediaCmp)) {
            this.mediaComponents.addElement(mediaCmp);
        }
    }

    public final boolean hasMedia() {
        return this.mediaComponents != null && this.mediaComponents.size() > 0;
    }

    void deregisterMediaComponent(Component mediaCmp) {
        this.mediaComponents.removeElement(mediaCmp);
    }

    public void registerAnimated(Animation cmp) {
        if (this.animatableComponents == null) {
            this.animatableComponents = new Vector();
        }
        if (!this.animatableComponents.contains(cmp)) {
            this.animatableComponents.addElement(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void registerAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents == null) {
            this.internalAnimatableComponents = new Vector();
        }
        if (!this.internalAnimatableComponents.contains(cmp)) {
            this.internalAnimatableComponents.addElement(cmp);
        }
        Display.getInstance().notifyDisplay();
    }

    void deregisterAnimatedInternal(Animation cmp) {
        if (this.internalAnimatableComponents != null) {
            this.internalAnimatableComponents.removeElement(cmp);
        }
    }

    public void deregisterAnimated(Animation cmp) {
        if (this.animatableComponents != null) {
            this.animatableComponents.removeElement(cmp);
        }
    }

    int getFocusPosition(Component c) {
        this.initFocusDown();
        return this.focusDownSequence.indexOf(c);
    }

    int getFocusCount() {
        this.initFocusDown();
        return this.focusDownSequence.size();
    }

    void repaintAnimations() {
        if (this.animatableComponents != null) {
            this.loopAnimations(this.animatableComponents, null);
        }
        if (this.internalAnimatableComponents != null) {
            this.loopAnimations(this.internalAnimatableComponents, this.animatableComponents);
        }
    }

    private void loopAnimations(Vector v, Vector notIn) {
        for (int iter = 0; iter < v.size(); ++iter) {
            Animation c = (Animation)v.elementAt(iter);
            if (c == null || notIn != null && notIn.contains(c) || !c.animate()) continue;
            if (c instanceof Component) {
                Rectangle rect = ((Component)c).getDirtyRegion();
                if (rect != null) {
                    Dimension d = rect.getSize();
                    if (d == null) continue;
                    ((Component)c).repaint(rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
                    continue;
                }
                ((Component)c).repaint();
                continue;
            }
            Display.getInstance().repaint(c);
        }
    }

    boolean hasAnimations() {
        return this.animatableComponents != null && this.animatableComponents.size() > 0 || this.internalAnimatableComponents != null && this.internalAnimatableComponents.size() > 0;
    }

    public void refreshTheme() {
        if (this.menuBar != null) {
            this.menuBar.refreshTheme();
        }
        if (this.title != null) {
            this.title.refreshTheme();
        }
        super.refreshTheme();
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    public Transition getTransitionInAnimator() {
        return this.transitionInAnimator;
    }

    public void setTransitionInAnimator(Transition transitionInAnimator) {
        this.transitionInAnimator = transitionInAnimator;
    }

    public Transition getTransitionOutAnimator() {
        return this.transitionOutAnimator;
    }

    public void setTransitionOutAnimator(Transition transitionOutAnimator) {
        this.transitionOutAnimator = transitionOutAnimator;
    }

    public void setCommandListener(ActionListener commandListener) {
        if (commandListener == null) {
            this.commandListener = null;
            return;
        }
        this.addCommandListener(commandListener);
    }

    public void addCommandListener(ActionListener l) {
        if (this.commandListener == null) {
            this.commandListener = new EventDispatcher();
        }
        this.commandListener.addListener(l);
    }

    public void removeCommandListener(ActionListener l) {
        this.commandListener.removeListener(l);
    }

    protected void actionCommand(Command cmd) {
    }

    public void dispatchCommand(Command cmd, ActionEvent ev) {
        cmd.actionPerformed(ev);
        if (!ev.isConsumed()) {
            this.actionCommandImpl(cmd, ev);
        }
    }

    void actionCommandImpl(Command cmd) {
        this.actionCommandImpl(cmd, new ActionEvent(cmd));
    }

    void actionCommandImpl(Command cmd, ActionEvent ev) {
        if (cmd == null) {
            return;
        }
        if (comboLock) {
            if (cmd == this.cancelMenuItem) {
                this.actionCommand(cmd);
                return;
            }
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
            return;
        }
        if (cmd != this.selectCommand) {
            if (this.commandListener != null) {
                this.commandListener.fireActionEvent(ev);
                if (ev.isConsumed()) {
                    return;
                }
            }
            this.actionCommand(cmd);
        } else {
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
        }
    }

    void initFocused() {
        if (this.focused == null) {
            this.setFocused(this.findFirstFocusable(this.contentPane));
            this.layoutContainer();
            this.initFocusDown();
            if (this.focusDownSequence == null) {
                this.initFocusDown();
                if (this.focusDownSequence.size() > 0) {
                    this.setFocused((Component)this.focusDownSequence.elementAt(0));
                }
            } else if (this.focusDownSequence.size() > 0) {
                this.setFocused((Component)this.focusDownSequence.elementAt(0));
            }
        }
    }

    public void show() {
        this.show(false);
    }

    public void showBack() {
        this.show(true);
    }

    private void show(boolean reverse) {
        if (this.transitionOutAnimator == null && this.transitionInAnimator == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initFocused();
        this.onShow();
        this.tint = false;
        Display.getInstance().setCurrent(this, reverse);
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.tactileTouchDuration = UIManager.getInstance().getLookAndFeel().getTactileTouchDuration();
        if (this.title.getText() != null && this.title.shouldTickerStart()) {
            this.title.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
        }
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        if (this.contentPane != null) {
            this.contentPane.setSmoothScrolling(smoothScrolling);
        }
    }

    public boolean isSmoothScrolling() {
        return this.contentPane.isSmoothScrolling();
    }

    public int getScrollAnimationSpeed() {
        return this.contentPane.getScrollAnimationSpeed();
    }

    public void setScrollAnimationSpeed(int animationSpeed) {
        this.contentPane.setScrollAnimationSpeed(animationSpeed);
    }

    protected void onShow() {
    }

    protected void onShowCompleted() {
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal, boolean reverse) {
        Display.getInstance().flushEdt();
        if (this.previousForm == null) {
            Dialog previousDialog;
            this.previousForm = Display.getInstance().getCurrent();
            if (this.previousForm == null) {
                this.previousForm = new Form();
                this.previousForm.show();
            } else if (this.previousForm instanceof Dialog && (previousDialog = (Dialog)this.previousForm).isDisposed()) {
                this.previousForm = Display.getInstance().getCurrentUpcoming();
            }
            this.previousForm.tint = true;
        }
        Painter p = this.getStyle().getBgPainter();
        if (top > 0 || bottom > 0 || left > 0 || right > 0) {
            Style titleStyle = this.title.getStyle();
            Style contentStyle = this.contentPane.getUnselectedStyle();
            if (includeTitle) {
                titleStyle.setMargin(0, top, true);
                titleStyle.setMargin(2, 0, true);
                titleStyle.setMargin(1, left, true);
                titleStyle.setMargin(3, right, true);
                contentStyle.setMargin(0, 0, true);
                contentStyle.setMargin(2, bottom, true);
                contentStyle.setMargin(1, left, true);
                contentStyle.setMargin(3, right, true);
            } else {
                titleStyle.setMargin(0, 0, true);
                titleStyle.setMargin(2, 0, true);
                titleStyle.setMargin(1, 0, true);
                titleStyle.setMargin(3, 0, true);
                contentStyle.setMargin(0, top, true);
                contentStyle.setMargin(2, bottom, true);
                contentStyle.setMargin(1, left, true);
                contentStyle.setMargin(3, right, true);
            }
            if (p instanceof Component.BGPainter && ((Component.BGPainter)p).getPreviousForm() != null) {
                ((Component.BGPainter)p).setPreviousForm(this.previousForm);
                ((Component.BGPainter)p).setParent(this);
            } else {
                Component.BGPainter b = new Component.BGPainter(this, p);
                b.setIgnorCoordinates(true);
                this.getStyle().setBgPainter(b);
                b.setPreviousForm(this.previousForm);
            }
            this.revalidate();
        }
        this.initFocused();
        if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initComponentImpl();
        Display.getInstance().setCurrent(this, reverse);
        this.onShow();
        if (modal) {
            Display.getInstance().invokeAndBlock(new RunnableWrapper(this, p, reverse));
            if (Display.getInstance().isVirtualKeyboardShowingSupported()) {
                Display.getInstance().setShowVirtualKeyboard(false);
            }
        }
    }

    void showModal(boolean reverse) {
        this.showDialog(true, reverse);
    }

    void showDialog(boolean modal, boolean reverse) {
        int h = Display.getInstance().getDisplayHeight() - this.menuBar.getPreferredH() - this.title.getPreferredH();
        int w = Display.getInstance().getDisplayWidth();
        int topSpace = h / 100 * 20;
        int bottomSpace = h / 100 * 10;
        int sideSpace = w / 100 * 20;
        this.showModal(topSpace, bottomSpace, sideSpace, sideSpace, true, modal, reverse);
    }

    void dispose() {
        this.disposeImpl();
    }

    boolean isDisposed() {
        return false;
    }

    void disposeImpl() {
        if (this.previousForm != null) {
            this.previousForm.tint = false;
            if (this.previousForm instanceof Dialog) {
                if (!((Dialog)this.previousForm).isDisposed()) {
                    Display.getInstance().setCurrent(this.previousForm, false);
                }
            } else {
                Display.getInstance().setCurrent(this.previousForm, false);
            }
            this.previousForm = null;
        }
    }

    boolean isMenu() {
        return false;
    }

    void repaint(Component cmp) {
        if (this.isVisible()) {
            Display.getInstance().repaint(cmp);
        }
    }

    public final Form getComponentForm() {
        return this;
    }

    void hideMenu() {
        super.removeComponent(this.menuBar);
    }

    void restoreMenu() {
        if (this.menuBar.getParent() == null) {
            super.addComponent("South", (Component)this.menuBar);
        }
    }

    public void setFocused(Component focused) {
        if (this.focused == focused && focused != null) {
            this.focused.repaint();
            return;
        }
        Component oldFocus = this.focused;
        this.focused = focused;
        boolean triggerRevalidate = false;
        if (oldFocus != null && !(triggerRevalidate = this.changeFocusState(oldFocus, false)) && oldFocus.getParent() != null) {
            oldFocus.repaint();
        }
        if (focused != null && this.focused == focused) {
            boolean bl = triggerRevalidate = this.changeFocusState(focused, true) || triggerRevalidate;
            if (!triggerRevalidate) {
                focused.repaint();
            }
        }
        if (triggerRevalidate) {
            this.revalidate();
        }
    }

    private boolean changeFocusState(Component cmp, boolean gained) {
        Dimension d;
        boolean trigger = false;
        Style selected = cmp.getSelectedStyle();
        Style unselected = cmp.getUnselectedStyle();
        if (!selected.getFont().equals(unselected.getFont()) || selected.getPadding(false, 0) != unselected.getPadding(false, 0) || selected.getPadding(false, 2) != unselected.getPadding(false, 2) || selected.getPadding(this.isRTL(), 3) != unselected.getPadding(this.isRTL(), 3) || selected.getPadding(this.isRTL(), 1) != unselected.getPadding(this.isRTL(), 1) || selected.getMargin(false, 0) != unselected.getMargin(false, 0) || selected.getMargin(false, 2) != unselected.getMargin(false, 2) || selected.getMargin(this.isRTL(), 3) != unselected.getMargin(this.isRTL(), 3) || selected.getMargin(this.isRTL(), 1) != unselected.getMargin(this.isRTL(), 1)) {
            trigger = true;
        }
        int prefW = 0;
        int prefH = 0;
        if (trigger) {
            d = cmp.getPreferredSize();
            prefW = d.getWidth();
            prefH = d.getHeight();
        }
        if (gained) {
            cmp.setFocus(true);
            cmp.fireFocusGained();
            this.fireFocusGained(cmp);
        } else {
            cmp.setFocus(false);
            cmp.fireFocusLost();
            this.fireFocusLost(cmp);
        }
        if (trigger) {
            cmp.setShouldCalcPreferredSize(true);
            d = cmp.getPreferredSize();
            if (prefW != d.getWidth() || prefH != d.getHeight()) {
                cmp.setShouldCalcPreferredSize(false);
                trigger = false;
            }
        }
        return trigger;
    }

    private Component findFirstFocusable(Container c) {
        int size = c.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            Component cmp;
            Component current = c.getComponentAt(iter);
            if (current.isFocusable()) {
                return current;
            }
            if (!(current instanceof Container) || (cmp = this.findFirstFocusable((Container)current)) == null) continue;
            return cmp;
        }
        return null;
    }

    public Component getFocused() {
        return this.focused;
    }

    protected void longKeyPress(int keyCode) {
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.longKeyPress(keyCode);
        }
    }

    protected void longPointerPress(int x, int y) {
        if (this.focused != null && this.focused.contains(x, y) && this.focused.getComponentForm() == this) {
            this.focused.longPointerPress(x, y);
        }
    }

    public void keyPressed(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK && this.clearCommand != null || keyCode == backspaceSK && this.clearCommand != null || Display.getInstance().isThirdSoftButton() && game == 8) {
            this.menuBar.keyPressed(keyCode);
            return;
        }
        if (this.focused != null) {
            this.focused.keyPressed(keyCode);
            if (this.focused == null) {
                this.initFocused();
                return;
            }
            if (this.focused.handlesInput()) {
                return;
            }
            if (this.focused.getComponentForm() == this) {
                if (this.focused != null && this.focused.handlesInput()) {
                    return;
                }
                this.updateFocus(Display.getInstance().getGameAction(keyCode));
            } else {
                this.initFocused();
            }
        } else {
            this.initFocused();
            if (this.focused == null) {
                this.contentPane.moveScrollTowards(Display.getInstance().getGameAction(keyCode), null);
                return;
            }
        }
    }

    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public void keyReleased(int keyCode) {
        Command defaultCmd;
        int game = Display.getInstance().getGameAction(keyCode);
        if (keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK && this.clearCommand != null || keyCode == backspaceSK && this.clearCommand != null || Display.getInstance().isThirdSoftButton() && game == 8) {
            this.menuBar.keyReleased(keyCode);
            return;
        }
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.keyReleased(keyCode);
        }
        if (game == 8 && (defaultCmd = this.getDefaultCommand()) != null) {
            defaultCmd.actionPerformed(new ActionEvent(defaultCmd, keyCode));
            this.actionCommandImpl(defaultCmd);
        }
        this.fireKeyEvent(this.keyListeners, keyCode);
        this.fireKeyEvent(this.gameKeyListeners, game);
    }

    private void fireKeyEvent(Hashtable keyListeners, int keyCode) {
        Vector listeners;
        if (keyListeners != null && (listeners = (Vector)keyListeners.get(new Integer(keyCode))) != null) {
            ActionEvent evt = new ActionEvent(this, keyCode);
            for (int iter = 0; iter < listeners.size(); ++iter) {
                ((ActionListener)listeners.elementAt(iter)).actionPerformed(evt);
                if (!evt.isConsumed()) continue;
                return;
            }
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.focused != null) {
            this.focused.keyRepeated(keyCode);
            int game = Display.getInstance().getGameAction(keyCode);
            if (!(this.focused.handlesInput() || game != 6 && game != 1 && game != 2 && game != 5)) {
                this.keyPressed(keyCode);
                this.keyReleased(keyCode);
            }
        } else {
            this.keyPressed(keyCode);
            this.keyReleased(keyCode);
        }
    }

    private void tactileTouchVibe(Component cmp) {
        if (this.tactileTouchDuration > 0 && cmp.isTactileTouch()) {
            Display.getInstance().vibrate(this.tactileTouchDuration);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.menuBar.contains(x, y)) {
            Component cmp = this.menuBar.getComponentAt(x, y);
            if (cmp != null) {
                cmp.pointerPressed(x, y);
                this.tactileTouchVibe(cmp);
            }
            return;
        }
        Component cmp = this.contentPane.getComponentAt(x, y);
        if (cmp != null && cmp.isFocusable()) {
            this.setFocused(cmp);
            cmp.pointerPressed(x, y);
            this.tactileTouchVibe(cmp);
        }
    }

    public void addPointerPressedListener(ActionListener l) {
        if (this.pointerPressedListeners == null) {
            this.pointerPressedListeners = new EventDispatcher();
        }
        this.pointerPressedListeners.addListener(l);
    }

    public void removePointerPressedListener(ActionListener l) {
        if (this.pointerPressedListeners != null) {
            this.pointerPressedListeners.removeListener(l);
        }
    }

    public void addPointerReleasedListener(ActionListener l) {
        if (this.pointerReleasedListeners == null) {
            this.pointerReleasedListeners = new EventDispatcher();
        }
        this.pointerReleasedListeners.addListener(l);
    }

    public void removePointerReleasedListener(ActionListener l) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.removeListener(l);
        }
    }

    public void addPointerDraggedListener(ActionListener l) {
        if (this.pointerDraggedListeners == null) {
            this.pointerDraggedListeners = new EventDispatcher();
        }
        this.pointerDraggedListeners.addListener(l);
    }

    public void removePointerDraggedListener(ActionListener l) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.removeListener(l);
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.pointerDraggedListeners != null) {
            this.pointerDraggedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.dragged != null) {
            this.dragged.pointerDragged(x, y);
            return;
        }
        Component cmp = this.contentPane.getComponentAt(x, y);
        if (cmp != null) {
            if (cmp.isFocusable()) {
                this.setFocused(cmp);
            }
            cmp.pointerDragged(x, y);
            cmp.repaint();
        }
    }

    public void pointerHoverReleased(int[] x, int[] y) {
        Component cmp = this.contentPane.getComponentAt(x[0], y[0]);
        if (cmp != null) {
            if (cmp.isFocusable()) {
                this.setFocused(cmp);
            }
            cmp.pointerHoverReleased(x, y);
            cmp.repaint();
        }
    }

    public void pointerHover(int[] x, int[] y) {
        Component cmp = this.contentPane.getComponentAt(x[0], y[0]);
        if (cmp != null) {
            if (cmp.isFocusable()) {
                this.setFocused(cmp);
            }
            cmp.pointerHover(x, y);
            cmp.repaint();
        }
    }

    public boolean isSingleFocusMode() {
        this.initFocusDown();
        return this.focusDownSequence.size() == 1;
    }

    public void pointerReleased(int x, int y) {
        if (this.pointerReleasedListeners != null) {
            this.pointerReleasedListeners.fireActionEvent(new ActionEvent(this, x, y));
        }
        if (this.dragged == null) {
            if (this.menuBar.contains(x, y)) {
                Component cmp = this.menuBar.getComponentAt(x, y);
                if (cmp != null) {
                    cmp.pointerReleased(x, y);
                }
                return;
            }
            Component cmp = this.contentPane.getComponentAt(x, y);
            if (cmp != null) {
                cmp.pointerReleased(x, y);
                if (cmp.isFocusable()) {
                    this.setFocused(cmp);
                }
            }
        } else {
            this.dragged.pointerReleased(x, y);
            this.dragged = null;
        }
    }

    public void setScrollableY(boolean scrollableY) {
        this.getContentPane().setScrollableY(scrollableY);
    }

    public void setScrollableX(boolean scrollableX) {
        this.getContentPane().setScrollableX(scrollableX);
    }

    public int getComponentIndex(Component cmp) {
        return this.getContentPane().getComponentIndex(cmp);
    }

    public void addCommand(Command cmd, int offset) {
        this.menuBar.addCommand(cmd, offset);
    }

    public int getCommandCount() {
        return this.menuBar.getCommandCount();
    }

    public Command getCommand(int index) {
        return this.menuBar.getCommand(index);
    }

    public void addCommand(Command cmd) {
        this.menuBar.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this.menuBar.removeCommand(cmd);
    }

    public void setCyclicFocus(boolean cyclicFocus) {
        this.cyclicFocus = cyclicFocus;
    }

    public boolean isCyclicFocus() {
        return this.cyclicFocus;
    }

    private void updateFocus(int gameAction) {
        Component focused = this.getFocused();
        switch (gameAction) {
            case 6: {
                Component down = focused.getNextFocusDown();
                if (down != null && down.getComponentForm() == this) {
                    focused = down;
                    break;
                }
                this.initFocusDown();
                int i = this.focusDownSequence.indexOf(focused) + 1;
                if (this.focusDownSequence.size() <= 0) break;
                if (i == this.focusDownSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusDownSequence.size() - 1;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 1: {
                Component up = focused.getNextFocusUp();
                if (up != null && up.getComponentForm() == this) {
                    focused = up;
                    break;
                }
                this.initFocusDown();
                if (this.focusDownSequence.size() <= 0) break;
                int i = this.focusDownSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusDownSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 5: {
                Component right = focused.getNextFocusRight();
                if (right != null && right.getComponentForm() == this) {
                    focused = right;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) + 1;
                if (i == this.focusRightSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusRightSequence.size() - 1;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            case 2: {
                Component left = focused.getNextFocusLeft();
                if (left != null && left.getComponentForm() == this) {
                    focused = left;
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusRightSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            default: {
                return;
            }
        }
        if (this.moveScrollTowards(gameAction, focused)) {
            this.setFocused(focused);
        }
    }

    boolean moveScrollTowards(int direction, Component c) {
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            return parent.moveScrollTowards(direction, c);
        }
        return true;
    }

    public void scrollComponentToVisible(Component c) {
        this.initFocused();
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            parent.scrollComponentToVisible(c);
            return;
        }
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuBar.setMenuCellRenderer(menuCellRenderer);
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
    }

    void requestFocus(Component cmp) {
        if (cmp.isFocusable() && this.contains(cmp)) {
            this.scrollComponentToVisible(cmp);
            this.setFocused(cmp);
        }
    }

    protected Command createSelectCommand() {
        return new Command(UIManager.getInstance().localize("select", "Select"));
    }

    protected Command createMenuSelectCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("select", "Select"), lf.getMenuIcons()[0]);
    }

    public void setRTL(boolean r) {
        super.setRTL(r);
        this.contentPane.setRTL(r);
    }

    protected Command createMenuCancelCommand() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        return new Command(UIManager.getInstance().localize("cancel", "Cancel"), lf.getMenuIcons()[1]);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        super.paint(g);
        if (this.tint) {
            g.setColor(this.tintColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight(), (byte)(this.tintColor >> 24 & 0xFF));
        }
    }

    public void setScrollable(boolean scrollable) {
        this.contentPane.setScrollable(scrollable);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mediaComponents != null) {
            int size = this.mediaComponents.size();
            for (int i = 0; i < size; ++i) {
                Component mediaCmp = (Component)this.mediaComponents.elementAt(i);
                mediaCmp.setVisible(visible);
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    void addSelectCommand(String selectText) {
        if (Display.getInstance().isThirdSoftButton()) {
            if (this.selectCommand == null) {
                this.selectCommand = this.createSelectCommand();
            }
            this.selectCommand.setCommandName(selectText);
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (Display.getInstance().isThirdSoftButton()) {
            this.removeCommand(this.selectCommand);
        }
    }

    public void setMenuTransitions(Transition transitionIn, Transition transitionOut) {
        this.menuBar.setTransitions(transitionIn, transitionOut);
    }

    protected String paramString() {
        return super.paramString() + ", title = " + this.title + ", visible = " + this.isVisible();
    }

    protected Command showMenuDialog(Dialog menu) {
        int marginLeft = (int)((float)this.getWidth() * 0.25f);
        int marginRight = 0;
        boolean rtl = this.isRTL();
        if (this.isReverseSoftButtons()) {
            marginRight = marginLeft;
            marginLeft = 0;
        }
        int height = this.getHeight() / 2;
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            marginLeft = 0;
            marginRight = 0;
        }
        return menu.show(height, 0, marginLeft, marginRight, true);
    }

    protected boolean isReverseSoftButtons() {
        LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
        if (this.isRTL()) {
            return !lf.isReverseSoftButtons();
        }
        return lf.isReverseSoftButtons();
    }

    protected int calculateTouchCommandGridColumns(Container grid) {
        int count = grid.getComponentCount();
        int maxWidth = 0;
        for (int iter = 0; iter < count; ++iter) {
            Component c = grid.getComponentAt(iter);
            Style s = c.getUnselectedStyle();
            maxWidth = Math.max(maxWidth, c.getPreferredW() + s.getPadding(false, 1) + s.getPadding(false, 3) + s.getMargin(false, 1) + s.getMargin(false, 3));
        }
        return Math.max(2, this.getWidth() / maxWidth);
    }

    protected Button createTouchCommandButton(Command c) {
        Button b = new Button(c);
        b.setTactileTouch(true);
        b.setTextPosition(2);
        b.setAlignment(4);
        b.setUIID("TouchCommand");
        return b;
    }

    protected Component createCommandComponent(Vector commands) {
        if (UIManager.getInstance().getLookAndFeel().isTouchMenus()) {
            Container menu = new Container();
            for (int iter = 0; iter < commands.size(); ++iter) {
                Command c = (Command)commands.elementAt(iter);
                menu.addComponent(this.createTouchCommandButton(c));
            }
            int cols = this.calculateTouchCommandGridColumns(menu);
            menu.setLayout(new GridLayout(Math.max(1, commands.size() / cols + commands.size() % cols != 0 ? 1 : 0), cols));
            return menu;
        }
        return this.createCommandList(commands);
    }

    protected List createCommandList(Vector commands) {
        List l = new List(commands);
        l.setUIID("CommandList");
        Component c = (Component)((Object)l.getRenderer());
        c.setUIID("Command");
        c = l.getRenderer().getListFocusComponent(l);
        c.setUIID("CommandFocus");
        l.setFixedSelection(1);
        return l;
    }

    Command getComponentSelectedCommand(Component cmp) {
        if (cmp instanceof List) {
            List l = (List)cmp;
            return (Command)l.getSelectedItem();
        }
        if ((cmp = cmp.getComponentForm().getFocused()) instanceof Button) {
            return ((Button)cmp).getCommand();
        }
        return null;
    }

    MenuBar getMenuBar() {
        return this.menuBar;
    }

    static {
        leftSK = -6;
        rightSK = -7;
        rightSK2 = -7;
        backSK = -11;
        clearSK = -8;
        backspaceSK = -8;
    }

    class MenuBar
    extends Container
    implements ActionListener {
        private Command menuCommand;
        private Vector commands = new Vector();
        private Button[] soft;
        private Command[] softCommand;
        private Button left;
        private Button right;
        private Button main;
        private ListCellRenderer menuCellRenderer;
        private Transition transitionIn;
        private Transition transitionOut;
        private Component commandList;
        private Style menuStyle;
        private int topMargin;
        private int bottomMargin;

        public MenuBar() {
            LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
            this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
            this.setUnSelectedStyle(UIManager.getInstance().getComponentStyle("SoftButton"));
            this.menuCommand = new Command(UIManager.getInstance().localize("menu", "Menu"), lf.getMenuIcons()[2]);
            if (lf.getDefaultMenuTransitionIn() != null || lf.getDefaultMenuTransitionOut() != null) {
                this.transitionIn = lf.getDefaultMenuTransitionIn();
                this.transitionOut = lf.getDefaultMenuTransitionOut();
            } else {
                this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
                this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
            }
            this.menuCellRenderer = lf.getMenuRenderer();
            if (Display.getInstance().getImplementation().getSoftkeyCount() > 1) {
                Button b;
                if (Display.getInstance().isThirdSoftButton()) {
                    this.setLayout(new GridLayout(1, 3));
                    this.soft = new Button[]{this.createSoftButton(), this.createSoftButton(), this.createSoftButton()};
                    this.main = this.soft[0];
                    this.main.setAlignment(4);
                    this.left = this.soft[1];
                    this.right = this.soft[2];
                    if (Form.this.isRTL()) {
                        this.addComponent(this.right);
                        this.addComponent(this.main);
                        this.addComponent(this.left);
                    } else {
                        this.addComponent(this.left);
                        this.addComponent(this.main);
                        this.addComponent(this.right);
                    }
                    if (Form.this.isReverseSoftButtons()) {
                        b = this.soft[1];
                        this.soft[1] = this.soft[2];
                        this.soft[2] = b;
                    }
                } else {
                    this.setLayout(new GridLayout(1, 2));
                    this.soft = new Button[]{this.createSoftButton(), this.createSoftButton()};
                    this.main = this.soft[0];
                    this.left = this.soft[0];
                    this.right = this.soft[1];
                    if (Form.this.isRTL()) {
                        this.addComponent(this.right);
                        this.addComponent(this.left);
                    } else {
                        this.addComponent(this.left);
                        this.addComponent(this.right);
                    }
                    if (Form.this.isReverseSoftButtons()) {
                        b = this.soft[0];
                        this.soft[0] = this.soft[1];
                        this.soft[1] = b;
                    }
                }
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    this.soft[iter].setEndsWith3Points(false);
                }
            } else if (Display.getInstance().isThirdSoftButton()) {
                this.setLayout(new GridLayout(1, 3));
                this.soft = new Button[]{this.createSoftButton(), this.createSoftButton(), this.createSoftButton()};
                this.main = this.soft[0];
                this.main.setAlignment(4);
                this.left = this.soft[1];
                this.right = this.soft[2];
                this.addComponent(this.left);
                this.addComponent(this.main);
                this.addComponent(this.right);
                if (Form.this.isReverseSoftButtons()) {
                    Button b = this.soft[1];
                    this.soft[1] = this.soft[2];
                    this.soft[2] = b;
                }
            } else {
                this.soft = new Button[]{this.createSoftButton()};
            }
            if (this.left != null) {
                if (Form.this.isRTL()) {
                    this.left.setAlignment(3);
                    this.right.setAlignment(1);
                } else {
                    this.left.setAlignment(1);
                    this.right.setAlignment(3);
                }
            }
            this.softCommand = new Command[this.soft.length];
        }

        private void updateCommands() {
            if (this.soft.length > 1) {
                this.soft[0].setText("");
                this.soft[1].setText("");
                this.soft[0].setIcon(null);
                this.soft[1].setIcon(null);
                int commandSize = this.commands.size();
                if (this.soft.length > 2) {
                    this.soft[2].setText("");
                    if (commandSize > 2) {
                        this.softCommand[2] = commandSize > 3 ? this.menuCommand : (Command)this.commands.elementAt(this.commands.size() - 3);
                        this.soft[2].setText(this.softCommand[2].getCommandName());
                        this.soft[2].setIcon(this.softCommand[2].getIcon());
                    } else {
                        this.softCommand[2] = null;
                    }
                }
                if (commandSize > 0) {
                    this.softCommand[0] = (Command)this.commands.elementAt(this.commands.size() - 1);
                    this.soft[0].setText(this.softCommand[0].getCommandName());
                    this.soft[0].setIcon(this.softCommand[0].getIcon());
                    if (commandSize > 1) {
                        this.softCommand[1] = this.soft.length == 2 && commandSize > 2 ? this.menuCommand : (Command)this.commands.elementAt(this.commands.size() - 2);
                        this.soft[1].setText(this.softCommand[1].getCommandName());
                        this.soft[1].setIcon(this.softCommand[1].getIcon());
                    } else {
                        this.softCommand[1] = null;
                    }
                } else {
                    this.softCommand[0] = null;
                    this.softCommand[1] = null;
                }
                if (commandSize == 1 && Form.this.isVisible()) {
                    Form.this.revalidate();
                }
                this.repaint();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            Object src = evt.getSource();
            if (this.commandList == null) {
                Button source = (Button)src;
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    if (source != this.soft[iter]) continue;
                    if (this.softCommand[iter] == this.menuCommand) {
                        this.showMenu();
                        return;
                    }
                    if (this.softCommand[iter] != null) {
                        ActionEvent e = new ActionEvent(this.softCommand[iter]);
                        this.softCommand[iter].actionPerformed(e);
                        if (!e.isConsumed()) {
                            Form.this.actionCommandImpl(this.softCommand[iter]);
                        }
                    }
                    return;
                }
            } else {
                Container parent;
                if (src instanceof Button) {
                    for (int iter = 0; iter < this.soft.length; ++iter) {
                        if (src != this.soft[iter]) continue;
                        for (parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                            if (!(parent instanceof Dialog)) continue;
                            ((Dialog)parent).actionCommand(this.softCommand[iter]);
                            return;
                        }
                    }
                }
                Command c = Form.this.getComponentSelectedCommand(this.commandList);
                for (parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Dialog)) continue;
                    ((Dialog)parent).actionCommand(c);
                    return;
                }
            }
        }

        private Button createSoftButton() {
            Button b = new Button();
            b.addActionListener(this);
            b.setFocusPainted(false);
            b.setFocusable(false);
            b.setTactileTouch(true);
            this.updateSoftButtonStyle(b);
            return b;
        }

        private void updateSoftButtonStyle(Button b) {
            Style s = new Style(this.getUnselectedStyle());
            b.setUnSelectedStyle(s);
            b.setPressedStyle(s);
            s.setBgImage(null);
            s.setBorder(null);
            s.setBackgroundType((byte)1);
            if (this.soft != null && this.soft.length > 1) {
                s.setMargin(this.topMargin, this.bottomMargin, 2, 2);
            } else {
                s.setMargin(0, 0, 0, 0);
                s.setPadding(0, 0, 0, 0);
            }
            s.setBgTransparency(0);
        }

        public void setUnSelectedStyle(Style style) {
            this.topMargin = style.getMargin(false, 0);
            this.bottomMargin = style.getMargin(false, 2);
            style.setMargin(0, 0, true);
            style.setMargin(2, 0, true);
            super.setUnSelectedStyle(style);
            if (this.soft != null) {
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    this.updateSoftButtonStyle(this.soft[iter]);
                }
            }
        }

        protected Dimension calcPreferredSize() {
            if (this.soft.length > 1) {
                Dimension d = super.calcPreferredSize();
                if ((this.soft[0].getText() == null || this.soft[0].getText().equals("")) && (this.soft[1].getText() == null || this.soft[1].getText().equals("")) && this.soft[0].getIcon() == null && this.soft[1].getIcon() == null) {
                    d.setHeight(0);
                }
                return d;
            }
            return super.calcPreferredSize();
        }

        public void setTransitions(Transition transitionIn, Transition transitionOut) {
            this.transitionIn = transitionIn;
            this.transitionOut = transitionOut;
        }

        private void showMenu() {
            Form upcoming;
            Command result;
            Dialog d = new Dialog();
            d.setDisposeWhenPointerOutOfBounds(true);
            d.setDialogStyle(new Style(this.menuStyle));
            d.setMenu(true);
            d.setSoftButtonStyle(new Style(Form.this.getSoftButtonStyle()));
            this.menuStyle.removeStyleListener(d.getContentPane());
            d.setTransitionInAnimator(this.transitionIn);
            d.setTransitionOutAnimator(this.transitionOut);
            d.setLayout(new BorderLayout());
            d.setScrollable(false);
            ((Form)d).menuBar.commandList = Form.this.createCommandComponent(this.commands);
            if (this.menuCellRenderer != null && ((Form)d).menuBar.commandList instanceof List) {
                ((List)((Form)d).menuBar.commandList).setListCellRenderer(this.menuCellRenderer);
            }
            d.getContentPane().getStyle().setMargin(0, 0, 0, 0);
            d.addComponent("Center", ((Form)d).menuBar.commandList);
            if (Display.getInstance().isThirdSoftButton()) {
                d.addCommand(Form.this.selectMenuItem);
                d.addCommand(Form.this.cancelMenuItem);
            } else {
                d.addCommand(Form.this.cancelMenuItem);
                if (this.soft.length > 1) {
                    d.addCommand(Form.this.selectMenuItem);
                }
            }
            d.setClearCommand(Form.this.cancelMenuItem);
            d.setBackCommand(Form.this.cancelMenuItem);
            if (((Form)d).menuBar.commandList instanceof List) {
                ((List)((Form)d).menuBar.commandList).addActionListener(((Form)d).menuBar);
            }
            if ((result = Form.this.showMenuDialog(d)) != Form.this.cancelMenuItem) {
                Command c = null;
                if (result == Form.this.selectMenuItem) {
                    c = Form.this.getComponentSelectedCommand(((Form)d).menuBar.commandList);
                    if (c != null) {
                        ActionEvent e = new ActionEvent(c);
                        c.actionPerformed(e);
                    }
                } else {
                    c = result;
                    if (!UIManager.getInstance().getLookAndFeel().isTouchMenus() && (c = result) != null) {
                        ActionEvent e = new ActionEvent(c);
                        c.actionPerformed(e);
                    }
                }
                if (c != null) {
                    Form.this.actionCommandImpl(c);
                }
            }
            if (((Form)d).menuBar.commandList instanceof List) {
                ((List)((Form)d).menuBar.commandList).removeActionListener(((Form)d).menuBar);
            }
            if ((upcoming = Display.getInstance().getCurrentUpcoming()) == Form.this) {
                d.disposeImpl();
            } else {
                Form.this.tint = upcoming instanceof Dialog;
            }
        }

        public Button[] getSoftButtons() {
            return this.soft;
        }

        public String getUIID() {
            return "SoftButton";
        }

        public void addCommand(Command cmd) {
            if (this.commands.contains(cmd)) {
                return;
            }
            if (this.soft.length > 2 && cmd == Form.this.getDefaultCommand()) {
                this.commands.addElement(cmd);
            } else {
                this.commands.insertElementAt(cmd, 0);
            }
            this.updateCommands();
        }

        public Command getCommand(int index) {
            return (Command)this.commands.elementAt(index);
        }

        public int getCommandCount() {
            return this.commands.size();
        }

        public void addCommand(Command cmd, int index) {
            if (this.commands.contains(cmd)) {
                return;
            }
            this.commands.insertElementAt(cmd, index);
            this.updateCommands();
        }

        public void removeAllCommands() {
            this.commands.removeAllElements();
            this.updateCommands();
        }

        public void removeCommand(Command cmd) {
            this.commands.removeElement(cmd);
            this.updateCommands();
        }

        public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
            this.menuCellRenderer = menuCellRenderer;
        }

        public Style getMenuStyle() {
            return this.menuStyle;
        }

        public void keyPressed(int keyCode) {
            if (this.commands.size() > 0) {
                if (keyCode == leftSK) {
                    if (this.left != null) {
                        this.left.pressed();
                    }
                } else if (keyCode == rightSK || keyCode == rightSK2) {
                    if (this.right != null) {
                        this.right.pressed();
                    }
                } else if (Display.getInstance().getGameAction(keyCode) == 8) {
                    this.main.pressed();
                }
            }
        }

        public void keyReleased(int keyCode) {
            if (this.commands.size() > 0) {
                if (Display.getInstance().getImplementation().getSoftkeyCount() < 2 && keyCode == leftSK) {
                    if (this.commandList != null) {
                        for (Container parent = this.commandList.getParent(); parent != null; parent = parent.getParent()) {
                            if (!(parent instanceof Dialog) || !((Dialog)parent).isMenu()) continue;
                            return;
                        }
                    }
                    this.showMenu();
                    return;
                }
                if (keyCode == leftSK) {
                    if (this.left != null) {
                        this.left.released();
                    }
                    return;
                }
                if (keyCode == rightSK || keyCode == rightSK2) {
                    if (this.right != null) {
                        this.right.released();
                    }
                    return;
                }
                if (Display.getInstance().getGameAction(keyCode) == 8) {
                    this.main.released();
                    return;
                }
            }
            Command c = null;
            if (keyCode == backSK) {
                c = Form.this.getBackCommand();
            } else if (keyCode == clearSK || keyCode == backspaceSK) {
                c = Form.this.getClearCommand();
            }
            if (c != null) {
                ActionEvent ev = new ActionEvent(c, keyCode);
                c.actionPerformed(ev);
                if (!ev.isConsumed()) {
                    Form.this.actionCommandImpl(c);
                }
            }
        }

        public void refreshTheme() {
            super.refreshTheme();
            if (this.menuStyle.isModified()) {
                this.menuStyle.merge(UIManager.getInstance().getComponentStyle("Menu"));
            } else {
                this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
            }
            if (this.menuCellRenderer != null) {
                List tmp = new List();
                tmp.setListCellRenderer(this.menuCellRenderer);
                tmp.refreshTheme();
            }
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.updateSoftButtonStyle(this.soft[iter]);
            }
            this.revalidate();
        }
    }
}

