/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.appmanager;

import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.fifa.utils.Logger;

public class RunGameService
implements Runnable {
    private String appName;
    private String appVendor;

    public RunGameService(String appName, String appVendor) {
        this.appName = appName;
        this.appVendor = appVendor;
    }

    public void startGame() {
        Application app = this.getJavaApplication(this.appName, this.appVendor);
        if (app != null) {
            app.start();
        }
    }

    private Application getJavaApplication(String appName, String appVendor) {
        Application result = null;
        if (appName != null && appVendor != null) {
            try {
                result = ApplicationManager.getApplicationManager().getApplication(appName, appVendor);
            }
            catch (Exception e) {
                Logger.logInfo(this.getClass(), "Exception: " + e.getMessage());
            }
        } else if (appName != null) {
            result = this.getJavaApplication(appName);
        }
        return result;
    }

    private Application getJavaApplication(String appName) {
        Application result = null;
        Application[] instaledApps = null;
        try {
            instaledApps = ApplicationManager.getApplicationManager().getApplications();
        }
        catch (Exception e) {
            Logger.logInfo(this.getClass(), "Exception: " + e.getMessage());
            e.printStackTrace();
        }
        if (instaledApps != null && instaledApps.length != 0) {
            int i = 0;
            while (i < instaledApps.length) {
                if (instaledApps[i].getSuiteName().equals(appName)) {
                    result = instaledApps[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void run() {
        this.startGame();
    }
}

