/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.viewservices;

import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.services.viewservices.FilterListener;
import java.util.Vector;

public class FilterService
implements Runnable {
    private FilterListener listener;
    private Feed feed;
    private String termToSearch;

    public FilterService(Feed feed, String termToSearch) {
        this.feed = feed;
        this.termToSearch = termToSearch.trim().toLowerCase();
    }

    public void setFilterListener(FilterListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void removeListener() {
        this.listener = null;
    }

    public void run() {
        this.performSearch();
    }

    private void performSearch() {
        Vector items;
        int[] feedIndexes = new int[50];
        int index = 0;
        if (this.feed != null && this.termToSearch != null && !this.termToSearch.trim().equals("") && (items = this.feed.getItems()) != null) {
            int i = 0;
            while (i < items.size()) {
                FeedItem item = (FeedItem)items.elementAt(i);
                String title = item.getTitle().toLowerCase();
                String description = item.getDescription().toLowerCase();
                if (title.indexOf(this.termToSearch) != -1 || description.indexOf(this.termToSearch) != -1) {
                    feedIndexes[index] = i;
                    ++index;
                }
                ++i;
            }
        }
        feedIndexes[index] = -1;
        if (this.listener != null) {
            this.listener.filterResult(feedIndexes);
        }
    }
}

