/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.tabs;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.action.SelectedTournamentTeamAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.tabs.TabView;
import java.util.Enumeration;
import java.util.Vector;

public class TournamentView
extends TabView
implements TournamentTableListener {
    private final Vector availableTeams = new Vector();
    private Vector groupName;

    public TournamentView(Model model) {
        super(2, model);
        this.mainForm.tournamentAddGroups(this.getGroupVector(true));
        if (model.isTournamentUpdated()) {
            this.updateView();
        }
        model.addTournamentTableListener(this);
    }

    protected int getNextTab() {
        return 3;
    }

    protected int getPreviousTab() {
        return 1;
    }

    private Vector getGroupVector(boolean boolCreateNew) {
        if (boolCreateNew) {
            this.groupName = new Vector();
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPB_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPC_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPD_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPE_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPF_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPG_TXT"));
            this.groupName.addElement(FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPH_TXT"));
        }
        return this.groupName;
    }

    protected void doShow() throws ViewException {
        this.viewId = 2;
        if (!this.selectedItem) {
            this.mainForm.focusFirstItem(1, FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"), false);
        }
        this.selectedItem = false;
        this.mainForm.show();
        this.mainForm.setKeyListener(this);
        this.mainForm.setTouchListener(this);
        this.mainForm.addSelectedItemListener(this);
    }

    public void tournamentTableUpdated() {
        this.updateView();
    }

    public void selectedItem(int item, int subgroup) {
        if (item >= 0 && subgroup >= 0) {
            this.selectedItem = true;
            String countryCode = (String)this.availableTeams.elementAt(item + subgroup * 4);
            SelectedTournamentTeamAction action = new SelectedTournamentTeamAction(countryCode);
            this.fireViewActionPerformed(action);
        }
    }

    public void performSoftkey() {
    }

    protected void doUpdateView() {
        Vector tournamentGroups = this.model.getTournamentGroups();
        if (tournamentGroups != null) {
            Enumeration groups = tournamentGroups.elements();
            while (groups.hasMoreElements()) {
                Group group = (Group)groups.nextElement();
                if (group == null) continue;
                Enumeration teams = group.getTeams().keys();
                while (teams.hasMoreElements()) {
                    String teamCode = (String)teams.nextElement();
                    String groupName = FifaResources.getMessage("FANAPP_TOURNAMSTATUS_" + group.getGroupName() + "_TXT");
                    this.mainForm.addItem(1, groupName, FifaResources.getMessage("FANAPP_TEAMNAME_" + teamCode + "_TXT"), null, String.valueOf(FifaResources.getImageFolder()) + teamCode + ".png");
                    this.availableTeams.addElement(teamCode);
                }
            }
        }
        this.mainForm.removeWaitIndicator(1);
        this.mainForm.focusFirstItem(1, FifaResources.getMessage("FANAPP_TOURNAMSTATUS_GROUPA_TXT"), true);
        this.mainForm.revalidate();
    }

    protected void doClearFormText() {
        if (!this.mainForm.isGroupEmpty(1)) {
            this.mainForm.refreshAll(1, true);
            this.mainForm.tournamentAddGroups(this.getGroupVector(true));
            this.updateView();
        } else {
            this.mainForm.refreshAll(1, true);
            this.mainForm.tournamentAddGroups(this.getGroupVector(true));
        }
    }

    public void tournamentTableUpdateFailed(byte reason) {
        this.fireViewActionPerformed(new UpdateFailureAction(reason, this.model.isTournamentUpdated()));
    }
}

