/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.PreloadedContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.services.viewservices.playnow.PlaynowUrlService;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PreloadedHandler
extends DefaultHandler
implements PreloadedContentProvider {
    private static final String CONTENT_TAG = "CONTENT";
    private static final String LINK_TAG = "LINKS";
    private static final String GAMES_TAG = "GAMES";
    private static final String VIDEOS_TAG = "VIDEOS";
    private static final String PICTURES_TAG = "PICTURES";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_TITLE_ATTRIBUTE = "title";
    private static final String ITEM_SUBTITLE_ATTRIBUTE = "subtitle";
    private static final String ITEM_ICON_ATTRIBUTE = "icon";
    private static final String ITEM_LINK_ATTRIBUTE = "link";
    private Vector preloadedContentVector;
    private boolean xmlStartedCorrectly;
    private PreloadedContent currentContent;
    private byte currentContentType = (byte)-1;
    private boolean containLinkTag = false;
    private boolean containVideoTag = false;
    private boolean containGameTag = false;
    private boolean containPictureTag = false;

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        if (!this.xmlStartedCorrectly) {
            if (CONTENT_TAG.equals(tagName)) {
                this.xmlStartedCorrectly = true;
                return;
            }
            Logger.logError(this.getClass(), "Error on parsing preloaded XML - Not started correctly");
            throw new RssInvalidFormatException();
        }
        if (this.xmlStartedCorrectly && (LINK_TAG.equals(tagName) || GAMES_TAG.equals(tagName) || VIDEOS_TAG.equals(tagName) || PICTURES_TAG.equals(tagName))) {
            if (this.currentContentType != -1) throw new RssInvalidFormatException();
            this.currentContentType = this.getTypeContent(tagName);
            return;
        }
        if (!this.xmlStartedCorrectly) return;
        if (!ITEM_TAG.equals(tagName)) return;
        if (this.currentContentType == -1) {
            throw new RssInvalidFormatException();
        }
        if (attributes == null) return;
        this.parseItem(attributes);
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (LINK_TAG.equals(qName) && this.currentContentType == 2) {
                if (!this.containLinkTag) {
                    this.currentContentType = (byte)-1;
                    this.containLinkTag = true;
                }
            } else if (GAMES_TAG.equals(qName) && this.currentContentType == 0) {
                if (!this.containGameTag) {
                    this.currentContentType = (byte)-1;
                    this.containGameTag = true;
                }
            } else if (VIDEOS_TAG.equals(qName) && this.currentContentType == 1) {
                if (!this.containVideoTag) {
                    this.currentContentType = (byte)-1;
                    this.containVideoTag = true;
                }
            } else if (PICTURES_TAG.equals(qName) && this.currentContentType == 3) {
                if (!this.containPictureTag) {
                    this.currentContentType = (byte)-1;
                    this.containPictureTag = true;
                }
            } else if (ITEM_TAG.equals(qName) && this.currentContentType != -1 && this.currentContent != null) {
                this.getPreloadedContent().addElement(this.currentContent);
                this.currentContent = null;
            } else if (CONTENT_TAG.equals(qName)) {
                this.xmlStartedCorrectly = false;
            }
        } else {
            throw new RssInvalidFormatException();
        }
    }

    public Vector getPreloadedContent() {
        if (this.preloadedContentVector == null) {
            this.preloadedContentVector = new Vector();
        }
        return this.preloadedContentVector;
    }

    private void parseItem(Attributes attributes) throws SAXException {
        int numberOfAttributes = attributes.getLength();
        this.currentContent = new PreloadedContent();
        int i = 0;
        while (i < numberOfAttributes) {
            String attributeName = attributes.getQName(i).trim();
            String attributeValue = attributes.getValue(i).trim();
            if (attributeValue != null && !"".equals(attributeValue)) {
                if (ITEM_TITLE_ATTRIBUTE.equals(attributeName)) {
                    this.currentContent.setTitle(attributeValue);
                } else if (ITEM_SUBTITLE_ATTRIBUTE.equals(attributeName)) {
                    this.currentContent.setSubtitle(attributeValue);
                } else if (ITEM_LINK_ATTRIBUTE.equals(attributeName)) {
                    if (this.currentContent.getTitle().equalsIgnoreCase("PlayNow")) {
                        this.currentContent.setLink(PlaynowUrlService.getPlaynowURL(Integer.parseInt(System.getProperty("com.sonyericsson.net.cmcc"))));
                    } else {
                        this.currentContent.setLink(attributeValue);
                    }
                } else if (ITEM_ICON_ATTRIBUTE.equals(attributeName)) {
                    this.currentContent.setIcon(String.valueOf(Configuration.getPreloadedImagesDirectory()) + attributeValue);
                }
            }
            ++i;
        }
        if (this.currentContent.getTitle() == null || this.currentContent.getLink() == null) {
            Logger.logError(this.getClass(), "Warning - parsing preloaded XML - Item does not contain required attributes");
        }
        this.currentContent.setType(this.currentContentType);
    }

    private byte getTypeContent(String tagName) throws SAXException {
        int typeContent = -1;
        if (tagName.equals(LINK_TAG)) {
            if (this.containLinkTag) {
                Logger.logError(this.getClass(), "Error on parsing preloaded XML - XML cannot contain more than one LINKS tag");
                throw new RssInvalidFormatException();
            }
            typeContent = 2;
        } else if (tagName.equals(GAMES_TAG)) {
            if (this.containGameTag) {
                throw new RssInvalidFormatException();
            }
            typeContent = 0;
        } else if (tagName.equals(VIDEOS_TAG)) {
            if (this.containVideoTag) {
                throw new RssInvalidFormatException();
            }
            typeContent = 1;
        } else if (tagName.equals(PICTURES_TAG)) {
            if (this.containPictureTag) {
                throw new RssInvalidFormatException();
            }
            typeContent = 3;
        }
        return (byte)typeContent;
    }
}

