/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class BaseProtocolHandler {
    private static final String UA = "UA";
    private static final String USER_AGENT = "User-Agent";
    private static final String UID = "UID";
    private static final String AL = "Accept-Language";
    private static final String NW = "Network";
    private static final String CT = "Content-Type";
    public static final String ROOT = "MiTV";
    public static final String RETURN_CODE = "ReturnCode";
    public static final String RETURN_MS = "ReturnMessage";
    public static final String CHANNEL = "Channel";
    public static final String CHANNEL_ID = "ChannelId";
    public static final String CHANNEL_TP = "ChannelType";
    public static final String CHANNEL_NM = "ChannelName";
    public static final String CHANNEL_POS = "ChannelPosition";
    public static final String CHANNEL_LG = "ChannelLogo";
    public static final String ACCESS_ALLOWED = "AccessAllowed";
    public static final String PROGRAM = "Program";
    public static final String PROGRAM_HTTP = "ProgramHTTP";
    public static final String PROGRAM_ID = "programId";
    public static final String PROGRAM_RTSP = "ProgramRTSP";
    public static final String PROGRAM_SDP = "programSDP";
    public static final String PPV = "PPV";
    public static final String CONDITIONS = "TermsAndConditions";
    public static final String SUB_ID = "SubscriptionId";
    public static final String SUB_NM = "SubscriptionName";
    public static final String PRICE = "Price";
    public static final String CURRENCY = "Currency";
    public static final String DURATION = "Duration";
    public static final String DESC = "ShortDescription";
    public static final String SUB_MS = "SubscribeMessage";
    public static final String VMCHANNEL_URL = "VMChannelListURL";
    public static final String TITLE = "Title";
    public static final String PROGRAM_LOGO = "ProgramLogo";
    public static final String DETAILS_URL = "ProgramDetailsURL";
    public static final String START_TIME = "PublishedStartTime";
    public static final String END_TIME = "PublishedEndTime";
    public static final String ACCESS_ALLOWED_YES = "yes";
    public static final String ACCESS_ALLOWED_NO = "no";
    private HttpConnection httpCon;
    protected String url;
    public String mNumber;
    public String returnCode;
    public String returnMS;
    public int statusCode = 0;
    private final String userAgent;

    public BaseProtocolHandler() {
        this.userAgent = "Nokia-1";
    }

    protected InputStream openInputStream() {
        block18: {
            if (this.init()) {
                ByteArrayInputStream byteArrayInputStream;
                try {
                    ByteArrayInputStream bis;
                    InputStream is = this.httpCon.openInputStream();
                    byte[] ch = new byte[512];
                    int n = 0;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    while ((n = is.read(ch)) != -1) {
                        os.write(ch, 0, n);
                    }
                    is.close();
                    byte[] bu = os.toByteArray();
                    if (bu == null || bu.length <= 0) {
                        this.statusCode = 2;
                        return null;
                    }
                    os.close();
                    byteArrayInputStream = bis = new ByteArrayInputStream(bu);
                }
                catch (IOException e) {
                    this.statusCode = 3;
                    break block18;
                }
                finally {
                    if (this.httpCon != null) {
                        try {
                            this.httpCon.close();
                            this.httpCon = null;
                        }
                        catch (IOException iOException) {}
                    }
                }
                return byteArrayInputStream;
            }
        }
        return null;
    }

    private boolean init() {
        if (this.url == null || !this.url.startsWith("http")) {
            this.statusCode = 1;
            return false;
        }
        try {
            this.httpCon = (HttpConnection)Connector.open((String)this.url);
            this.httpCon.setRequestMethod("GET");
            this.httpCon.setRequestProperty(USER_AGENT, this.getUA());
            this.httpCon.setRequestProperty(AL, "en");
            this.httpCon.setRequestProperty(UA, this.userAgent);
            this.httpCon.setRequestProperty(UID, this.mNumber);
            this.httpCon.setRequestProperty(NW, "HD");
            this.httpCon.setRequestProperty(CT, "text/xml;charset=UTF-8");
            return true;
        }
        catch (IOException e) {
            this.statusCode = 3;
            return false;
        }
    }

    private String getUA() {
        StringBuffer sbu = new StringBuffer();
        sbu.append("MiTV/2.00 (MIDP-1.0 MIDP-2.0; N;");
        String str = System.getProperty("microedition.platform");
        if (str == null) {
            return "Nokia-1";
        }
        sbu.append(str).append(";en)");
        return sbu.toString();
    }
}

