/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import com.sonyericsson.starhub.protocol.BaseProtocolHandler;
import com.sonyericsson.starhub.protocol.bean.ChannelInfo;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChannelListHandler
extends BaseProtocolHandler {
    private static final String PLAY_LIST = "Playlist";
    private static final String CHANNEL_LOGO_HEAD = "http://";
    private ChannelXMLParser handler;
    public SAXParser parser;

    public ChannelInfo[] getChannelList(String url) {
        this.url = url;
        ChannelInfo[] channels = new ChannelInfo[]{};
        InputStream is = this.openInputStream();
        if (is != null) {
            try {
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.handler == null) {
                    this.handler = new ChannelXMLParser();
                }
                this.parser.parse(is, (DefaultHandler)this.handler);
                this.returnMS = this.handler.returnMs;
                this.returnCode = this.handler.returnCode;
                Vector vc = this.handler.getObjs();
                if (vc != null) {
                    channels = new ChannelInfo[vc.size()];
                    int i = 0;
                    while (i < vc.size()) {
                        Hashtable channelInfo = (Hashtable)vc.elementAt(i);
                        ChannelInfo channel = new ChannelInfo();
                        channel.accessAllowed = ((String)channelInfo.get("AccessAllowed")).equals("yes");
                        channel.id = (String)channelInfo.get("ChannelId");
                        channel.logo = (String)channelInfo.get("ChannelLogo");
                        channel.name = (String)channelInfo.get("ChannelName");
                        channel.position = (String)channelInfo.get("ChannelPosition");
                        channel.type = (String)channelInfo.get("ChannelType");
                        channels[i] = channel;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.statusCode = 5;
            }
        }
        return channels;
    }

    private static class ChannelXMLParser
    extends DefaultHandler {
        private static final int SIZE_CHANNELS = 10;
        private static final int SIZE_PROPERTIES = 6;
        private String currentTag;
        private Hashtable currentObj;
        private Vector objs;
        public String returnMs;
        public String returnCode;

        private ChannelXMLParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentTag == null) {
                return;
            }
            if ("ReturnCode".equals(this.currentTag)) {
                this.returnCode = String.valueOf(ch, start, length);
            } else if ("ReturnMessage".equals(this.currentTag)) {
                this.returnMs = String.valueOf(ch, start, length);
            } else if (this.currentObj != null) {
                this.currentObj.put(this.currentTag, String.valueOf(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            System.out.println("ChannelXMLParser.endDocument()");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentTag = null;
            if ("Channel".equals(qName)) {
                String type = (String)this.currentObj.get("ChannelLogo");
                String logo = (String)this.currentObj.get("ChannelLogo");
                if (!type.equals(ChannelListHandler.PLAY_LIST) && logo != null && logo.startsWith(ChannelListHandler.CHANNEL_LOGO_HEAD)) {
                    this.objs.addElement(this.currentObj);
                }
                this.currentObj = null;
            }
        }

        public void startDocument() throws SAXException {
            this.objs = new Vector(10);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"MiTV".equals(qName)) {
                if ("Channel".equals(qName)) {
                    this.currentObj = new Hashtable(6);
                } else {
                    this.currentTag = qName;
                }
            }
        }

        public Vector getObjs() {
            return this.objs;
        }
    }
}

