/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import com.sonyericsson.starhub.protocol.BaseProtocolHandler;
import com.sonyericsson.starhub.protocol.bean.ViewChannel;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OverviewHandler
extends BaseProtocolHandler {
    private OverviewXMLParser handler;
    private SAXParser parser;

    public ViewChannel[] getViewChannelList(String url) {
        this.url = url;
        ViewChannel[] channels = new ViewChannel[]{};
        InputStream is = this.openInputStream();
        if (is != null) {
            try {
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.handler == null) {
                    this.handler = new OverviewXMLParser();
                }
                this.parser.parse(is, (DefaultHandler)this.handler);
                this.returnMS = this.handler.returnMs;
                this.returnCode = this.handler.returnCode;
                Vector vc = this.handler.getObjs();
                if (vc != null) {
                    channels = new ViewChannel[vc.size()];
                    int i = 0;
                    while (i < vc.size()) {
                        Hashtable channelInfo = (Hashtable)vc.elementAt(i);
                        ViewChannel channel = new ViewChannel();
                        channel.id = (String)channelInfo.get("ChannelId");
                        channel.programDetailsUrl = (String)channelInfo.get("ProgramDetailsURL");
                        channel.programId = (String)channelInfo.get("programId");
                        channel.programLogo = (String)channelInfo.get("ProgramLogo");
                        channel.publishedEndTime = (String)channelInfo.get("PublishedEndTime");
                        channel.publishedStartTime = (String)channelInfo.get("PublishedStartTime");
                        channel.title = (String)channelInfo.get("Title");
                        channel.vmChannelUrl = (String)channelInfo.get("VMChannelListURL");
                        channel.duration = (String)channelInfo.get("Duration");
                        channels[i] = channel;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.statusCode = 5;
            }
        }
        return channels;
    }

    private static class OverviewXMLParser
    extends DefaultHandler {
        private static final int SIZE_CHANNELS = 10;
        private static final int SIZE_PROPERTIES = 9;
        private String currentTag;
        private Hashtable currentObj;
        private Vector objs;
        public String returnMs;
        public String returnCode;

        private OverviewXMLParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentTag == null) {
                return;
            }
            if ("ReturnCode".equals(this.currentTag)) {
                this.returnCode = String.valueOf(ch, start, length);
            } else if ("ReturnMessage".equals(this.currentTag)) {
                this.returnMs = String.valueOf(ch, start, length);
            } else if (this.currentObj != null) {
                this.currentObj.put(this.currentTag, String.valueOf(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            System.out.println("ChannelXMLParser.endDocument()");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentTag = null;
            if ("Channel".equals(qName)) {
                this.objs.addElement(this.currentObj);
                this.currentObj = null;
            }
        }

        public void startDocument() throws SAXException {
            this.objs = new Vector(10);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"MiTV".equals(qName)) {
                if ("Channel".equals(qName)) {
                    this.currentObj = new Hashtable(9);
                } else if ("Program".equals(qName)) {
                    if (this.currentObj != null) {
                        String pid = attributes.getValue("programId");
                        this.currentObj.put("programId", pid);
                    }
                } else {
                    this.currentTag = qName;
                }
            }
        }

        public Vector getObjs() {
            return this.objs;
        }
    }
}

