/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import com.sonyericsson.starhub.protocol.BaseProtocolHandler;
import com.sonyericsson.starhub.protocol.bean.ProgramInfo;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProgramListHandler
extends BaseProtocolHandler {
    private ProgramListXMLParser handler;
    public SAXParser parser;

    public ProgramInfo[] getProgramList(String url) {
        this.url = url;
        ProgramInfo[] programs = new ProgramInfo[]{};
        InputStream is = this.openInputStream();
        if (is != null) {
            try {
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.handler == null) {
                    this.handler = new ProgramListXMLParser();
                }
                this.parser.parse(is, (DefaultHandler)this.handler);
                this.returnMS = this.handler.returnMs;
                this.returnCode = this.handler.returnCode;
                Vector vc = this.handler.getObjs();
                if (vc != null) {
                    programs = new ProgramInfo[vc.size()];
                    int i = 0;
                    while (i < vc.size()) {
                        Hashtable channelInfo = (Hashtable)vc.elementAt(i);
                        ProgramInfo program = new ProgramInfo();
                        program.programDetailsUrl = (String)channelInfo.get("ProgramDetailsURL");
                        program.programId = (String)channelInfo.get("programId");
                        program.programLogo = (String)channelInfo.get("ProgramLogo");
                        program.publishedEndTime = (String)channelInfo.get("PublishedEndTime");
                        program.publishedStartTime = (String)channelInfo.get("PublishedStartTime");
                        program.title = (String)channelInfo.get("Title");
                        program.vmChannelUrl = (String)channelInfo.get("VMChannelListURL");
                        program.duration = (String)channelInfo.get("Duration");
                        programs[i] = program;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.statusCode = 5;
            }
        }
        return programs;
    }

    private static class ProgramListXMLParser
    extends DefaultHandler {
        private static final int SIZE_CHANNELS = 10;
        private static final int SIZE_PROPERTIES = 8;
        private String currentTag;
        private Hashtable currentObj;
        private Vector objs;
        public String returnMs;
        public String returnCode;

        private ProgramListXMLParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentTag == null || "ChannelId".equals(this.currentTag)) {
                return;
            }
            if ("ReturnCode".equals(this.currentTag)) {
                this.returnCode = String.valueOf(ch, start, length);
            } else if ("ReturnMessage".equals(this.currentTag)) {
                this.returnMs = String.valueOf(ch, start, length);
            } else if (this.currentObj != null) {
                this.currentObj.put(this.currentTag, String.valueOf(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            System.out.println("ChannelXMLParser.endDocument()");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentTag = null;
            if ("Program".equals(qName)) {
                this.objs.addElement(this.currentObj);
                this.currentObj = null;
            }
        }

        public void startDocument() throws SAXException {
            this.objs = new Vector(10);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"MiTV".equals(qName) && !"Channel".equals(qName)) {
                if ("Program".equals(qName)) {
                    this.currentObj = new Hashtable(8);
                    String pid = attributes.getValue("programId");
                    this.currentObj.put("programId", pid);
                } else {
                    this.currentTag = qName;
                }
            }
        }

        public Vector getObjs() {
            return this.objs;
        }
    }
}

