/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import com.sonyericsson.starhub.protocol.BaseProtocolHandler;
import com.sonyericsson.starhub.protocol.bean.SubInfo;
import com.sonyericsson.tvm.log.Log;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SubInfoHandler
extends BaseProtocolHandler {
    public String termsAndConditions;
    private SubInfoXMLParser handler;
    public SAXParser parser;

    public SubInfo[] getSubInfos(String url) {
        this.url = url;
        SubInfo[] subinfos = new SubInfo[]{};
        InputStream is = this.openInputStream();
        if (is != null) {
            try {
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.handler == null) {
                    this.handler = new SubInfoXMLParser();
                }
                this.parser.parse(is, (DefaultHandler)this.handler);
                this.returnMS = this.handler.returnMs;
                this.returnCode = this.handler.returnCode;
                Log.debug("return code: " + this.returnCode);
                this.termsAndConditions = this.handler.conditions;
                Vector vc = this.handler.getObjs();
                if (vc != null) {
                    subinfos = new SubInfo[vc.size()];
                    int i = 0;
                    while (i < vc.size()) {
                        Hashtable channelInfo = (Hashtable)vc.elementAt(i);
                        SubInfo info = new SubInfo();
                        info.currency = (String)channelInfo.get("Currency");
                        info.desc = (String)channelInfo.get("ShortDescription");
                        info.duration = (String)channelInfo.get("Duration");
                        info.price = (String)channelInfo.get("Price");
                        info.subId = (String)channelInfo.get("SubscriptionId");
                        info.subName = (String)channelInfo.get("SubscriptionName");
                        subinfos[i] = info;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.statusCode = 5;
            }
        }
        return subinfos;
    }

    private static class SubInfoXMLParser
    extends DefaultHandler {
        private static final int SIZE_CHANNELS = 10;
        private static final int SIZE_PROPERTIES = 6;
        private String currentTag;
        private Hashtable currentObj;
        private Vector objs;
        public String returnMs;
        public String returnCode;
        public String conditions;

        private SubInfoXMLParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentTag == null) {
                return;
            }
            if ("ReturnCode".equals(this.currentTag)) {
                this.returnCode = String.valueOf(ch, start, length);
            } else if ("ReturnMessage".equals(this.currentTag)) {
                this.returnMs = String.valueOf(ch, start, length);
            } else if ("TermsAndConditions".equals(this.currentTag)) {
                this.conditions = String.valueOf(ch, start, length);
            } else if (this.currentObj != null) {
                this.currentObj.put(this.currentTag, String.valueOf(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            System.out.println("ChannelXMLParser.endDocument()");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentTag = null;
            if ("PPV".equals(qName)) {
                this.objs.addElement(this.currentObj);
                this.currentObj = null;
            }
        }

        public void startDocument() throws SAXException {
            this.objs = new Vector(10);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"MiTV".equals(qName)) {
                if ("PPV".equals(qName)) {
                    this.currentObj = new Hashtable(6);
                } else {
                    this.currentTag = qName;
                }
            }
        }

        public Vector getObjs() {
            return this.objs;
        }
    }
}

