/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.starhub.protocol;

import com.sonyericsson.starhub.protocol.BaseProtocolHandler;
import com.sonyericsson.starhub.protocol.bean.VMChannel;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VMChannelListHandler
extends BaseProtocolHandler {
    private VMChannelXMLParser handler;
    public SAXParser parser;

    public VMChannel[] getVMChannelList(String url) {
        this.url = url;
        VMChannel[] programs = new VMChannel[]{};
        InputStream is = this.openInputStream();
        if (is != null) {
            try {
                if (this.parser == null) {
                    this.parser = SAXParserFactory.newInstance().newSAXParser();
                }
                if (this.handler == null) {
                    this.handler = new VMChannelXMLParser();
                }
                this.parser.parse(is, (DefaultHandler)this.handler);
                this.returnMS = this.handler.returnMs;
                this.returnCode = this.handler.returnCode;
                Vector vc = this.handler.getObjs();
                if (vc != null) {
                    programs = new VMChannel[vc.size()];
                    int i = 0;
                    while (i < vc.size()) {
                        Hashtable channelInfo = (Hashtable)vc.elementAt(i);
                        VMChannel program = new VMChannel();
                        program.id = (String)channelInfo.get("ChannelId");
                        program.programHTTP = (String)channelInfo.get("ProgramHTTP");
                        program.programId = (String)channelInfo.get("programId");
                        program.programRTSP = (String)channelInfo.get("ProgramRTSP");
                        program.programSDP = (String)channelInfo.get("programSDP");
                        programs[i] = program;
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                this.statusCode = 5;
            }
        }
        return programs;
    }

    private static class VMChannelXMLParser
    extends DefaultHandler {
        private static final int SIZE_CHANNELS = 10;
        private static final int SIZE_PROPERTIES = 3;
        private String currentTag;
        private Hashtable currentObj;
        private Vector objs;
        public String returnMs;
        public String returnCode;

        private VMChannelXMLParser() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.currentTag == null) {
                return;
            }
            if ("ReturnCode".equals(this.currentTag)) {
                this.returnCode = String.valueOf(ch, start, length);
            } else if ("ReturnMessage".equals(this.currentTag)) {
                this.returnMs = String.valueOf(ch, start, length);
            } else if (this.currentObj != null) {
                this.currentObj.put(this.currentTag, String.valueOf(ch, start, length));
            }
        }

        public void endDocument() throws SAXException {
            System.out.println("ChannelXMLParser.endDocument()");
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.currentTag = null;
            if ("Channel".equals(qName)) {
                String rtsp = (String)this.currentObj.get("ProgramRTSP");
                if (rtsp != null && !rtsp.trim().equals("")) {
                    this.objs.addElement(this.currentObj);
                }
                this.currentObj = null;
            }
        }

        public void startDocument() throws SAXException {
            this.objs = new Vector(10);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"MiTV".equals(qName)) {
                if ("Channel".equals(qName)) {
                    this.currentObj = new Hashtable(3);
                } else if ("Program".equals(qName)) {
                    if (this.currentObj != null) {
                        String pid = attributes.getValue("programId");
                        this.currentObj.put("programId", pid);
                    }
                } else {
                    this.currentTag = qName;
                }
            }
        }

        public Vector getObjs() {
            return this.objs;
        }
    }
}

