/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.mitv;

import com.sonyericsson.starhub.protocol.ChannelListHandler;
import com.sonyericsson.starhub.protocol.MsisdnHandler;
import com.sonyericsson.starhub.protocol.ProgramListHandler;
import com.sonyericsson.starhub.protocol.SubInfoHandler;
import com.sonyericsson.starhub.protocol.SubscribeHandler;
import com.sonyericsson.starhub.protocol.VMChannelListHandler;
import com.sonyericsson.starhub.protocol.bean.ChannelInfo;
import com.sonyericsson.starhub.protocol.bean.ProgramInfo;
import com.sonyericsson.starhub.protocol.bean.SubInfo;
import com.sonyericsson.starhub.protocol.bean.VMChannel;
import com.sonyericsson.tvm.log.Log;
import com.sonyericsson.tvm.mitv.MiTVStub;
import com.sonyericsson.tvm.mitv.exception.MiTvException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MiTVStubImpl
implements MiTVStub {
    private static final String ERROR_200_INFO = "Problem with billing system";
    private static final String ERROR_201_INFO = "Sorry, we could not subscribe you to this service.Please try again.";
    private static final String ERROR_202_INFO = "Sorry, a problem occurs during unsubscribe.";
    private static final String ERROR_206_INFO = "Unknown program (in programDetails request) (NO_CONTENT)";
    private static final String ERROR_300_INFO = "Sorry, the service is currently not available.Please try again later";
    private static final String ERROR_301_INFO = "Sorry, we are not able to get program information at this time.Please try again later (DATABASE_PB).";
    private static final String ERROR_303_INFO = "Authentication error.";
    private static final String APIERRORCODE = "exceptiion code:";
    private static final String ERROR_200 = "200";
    private static final String ERROR_201 = "201";
    private static final String ERROR_202 = "202";
    private static final String ERROR_206 = "206";
    private static final String ERROR_300 = "300";
    private static final String ERROR_301 = "301";
    private static final String ERROR_303 = "303";
    private static final String NORMAL_CODE = "0";
    private static final String ERROR_100 = "100";
    private static final MiTVStubImpl instance = new MiTVStubImpl();
    private static final String DEST_SMS = "sms://6757";
    private static final String SMS_CONTENT = "livetv";
    private static final String MSISDN_URL = "http://203.117.16.174/se/getmsisdn.php";
    private String server = "http://193.23.132.8/MiTV/";
    private String mNumber;
    private SAXParser parser;
    public String returnMs;
    public String returnCode;

    private MiTVStubImpl() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            // empty catch block
        }
    }

    public static MiTVStubImpl getInstance(String server) {
        if (server != null && server.trim().length() > 0) {
            MiTVStubImpl.instance.server = server;
        }
        return instance;
    }

    public ChannelInfo[] getAllChannels() throws MiTvException {
        this.init();
        String url = String.valueOf(this.server) + "channelList.do";
        ChannelListHandler handler = new ChannelListHandler();
        handler.mNumber = this.mNumber;
        handler.parser = this.parser;
        ChannelInfo[] list = handler.getChannelList(url);
        if (handler.statusCode != 0) {
            throw new MiTvException(APIERRORCODE + handler.statusCode);
        }
        this.returnMs = handler.returnMS;
        this.returnCode = handler.returnCode;
        String errorInfo = this.getErrorInfo(this.returnCode);
        if (errorInfo != null) {
            throw new MiTvException(errorInfo);
        }
        return list;
    }

    public String getChannelUrl(String id, boolean accessAllowed) throws MiTvException {
        this.init();
        String url = String.valueOf(this.server) + "VMChannelList.do?channelId=" + id + "&accessCheck=";
        url = accessAllowed ? String.valueOf(url) + "no" : String.valueOf(url) + "yes";
        VMChannelListHandler handler = new VMChannelListHandler();
        handler.mNumber = this.mNumber;
        handler.parser = this.parser;
        VMChannel[] vList = handler.getVMChannelList(url);
        if (handler.statusCode != 0) {
            throw new MiTvException(APIERRORCODE + handler.statusCode);
        }
        this.returnMs = handler.returnMS;
        this.returnCode = handler.returnCode;
        String errorInfo = this.getErrorInfo(this.returnCode);
        if (errorInfo != null) {
            throw new MiTvException(errorInfo);
        }
        if (vList.length > 0) {
            return vList[0].programRTSP;
        }
        return null;
    }

    public ProgramInfo[] getGuide(String cId) throws MiTvException {
        this.init();
        String url = String.valueOf(this.server) + "overview.do?startDateTime=";
        Calendar c = Calendar.getInstance();
        url = String.valueOf(url) + MiTVStubImpl.getStartTime(c) + "&endDateTime=" + this.getEndTime(c) + "&channelId=" + cId;
        ProgramListHandler handler = new ProgramListHandler();
        handler.mNumber = this.mNumber;
        handler.parser = this.parser;
        ProgramInfo[] list = handler.getProgramList(url);
        if (handler.statusCode != 0) {
            throw new MiTvException(APIERRORCODE + handler.statusCode);
        }
        this.returnMs = handler.returnMS;
        this.returnCode = handler.returnCode;
        String errorInfo = this.getErrorInfo(this.returnCode);
        if (errorInfo != null) {
            throw new MiTvException(errorInfo);
        }
        return list;
    }

    public SubInfo getSubscribeInfo(String id) throws MiTvException {
        this.init();
        String url = String.valueOf(this.server) + "subscriptionInfo.do?channelId=" + id;
        Log.info(url);
        SubInfoHandler handler = new SubInfoHandler();
        handler.mNumber = this.mNumber;
        handler.parser = this.parser;
        SubInfo[] sus = handler.getSubInfos(url);
        if (handler.statusCode != 0) {
            throw new MiTvException(APIERRORCODE + handler.statusCode);
        }
        this.returnMs = handler.returnMS;
        this.returnCode = handler.returnCode;
        String errorInfo = this.getErrorInfo(this.returnCode);
        if (errorInfo != null) {
            throw new MiTvException(errorInfo);
        }
        SubInfo info = new SubInfo();
        if (sus.length > 0) {
            info = sus[0];
        }
        info.condition = handler.termsAndConditions;
        return info;
    }

    public boolean subscribe(String id) throws MiTvException {
        this.init();
        String url = String.valueOf(this.server) + "subscribe.do?subscriptionId=" + id;
        SubscribeHandler handler = new SubscribeHandler();
        handler.mNumber = this.mNumber;
        handler.parser = this.parser;
        handler.getSubscribeMs(url);
        if (handler.statusCode != 0) {
            throw new MiTvException(APIERRORCODE + handler.statusCode);
        }
        this.returnMs = handler.returnMS;
        this.returnCode = handler.returnCode;
        String errorInfo = this.getErrorInfo(this.returnCode);
        if (errorInfo != null) {
            throw new MiTvException(errorInfo);
        }
        return NORMAL_CODE.equals(this.returnCode.trim());
    }

    private String getErrorInfo(String errorCode) {
        String info = null;
        if (!(errorCode == null || errorCode.trim().equals("") || ERROR_100.equals(errorCode.trim()) || NORMAL_CODE.equals(errorCode.trim()))) {
            info = String.valueOf(errorCode) + this.returnMs;
        }
        return info;
    }

    public boolean sendMessage() {
        MessageConnection mcconn = null;
        try {
            mcconn = (MessageConnection)Connector.open((String)DEST_SMS);
            TextMessage tm = (TextMessage)mcconn.newMessage("text");
            tm.setAddress(DEST_SMS);
            tm.setPayloadText(SMS_CONTENT);
            mcconn.send((Message)tm);
            return true;
        }
        catch (IOException e) {
            Log.error(e.toString());
            return false;
        }
        finally {
            if (mcconn != null) {
                try {
                    mcconn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getStartTime(Calendar c) {
        StringBuffer bu = new StringBuffer();
        bu.append(c.get(1)).append("-");
        int month = c.get(2) + 1;
        if (month < 10) {
            bu.append(NORMAL_CODE).append(month).append("-");
        } else {
            bu.append(month).append("-");
        }
        int day = c.get(5);
        if (day < 10) {
            bu.append(NORMAL_CODE).append(day).append("T");
        } else {
            bu.append(day).append("T");
        }
        int hour = c.get(11);
        if (hour < 10) {
            bu.append(NORMAL_CODE).append(hour).append(":");
        } else {
            bu.append(hour).append(":");
        }
        int minute = c.get(12);
        if (minute < 10) {
            bu.append(NORMAL_CODE).append(minute).append(":");
        } else {
            bu.append(minute).append(":");
        }
        int second = c.get(13);
        if (second < 10) {
            bu.append(NORMAL_CODE).append(second);
        } else {
            bu.append(second);
        }
        return bu.toString();
    }

    private String getEndTime(Calendar c) {
        int hour = c.get(11);
        c.set(11, hour + 1);
        return MiTVStubImpl.getStartTime(c);
    }

    private void init() {
        if (this.mNumber != null) {
            return;
        }
        MsisdnHandler handler = new MsisdnHandler();
        try {
            InputStream is;
            if (this.parser == null) {
                this.parser = SAXParserFactory.newInstance().newSAXParser();
            }
            if ((is = this.openMsisdnResponse()) != null) {
                this.parser.parse(is, (DefaultHandler)handler);
                this.mNumber = handler.getNumber();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private InputStream openMsisdnResponse() {
        HttpConnection httpConn = null;
        try {
            httpConn = (HttpConnection)Connector.open((String)MSISDN_URL);
            InputStream is = httpConn.openInputStream();
            if (httpConn.getLength() > 0L) {
                byte[] bytes = new byte[512];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int n = 0;
                while ((n = is.read(bytes, 0, bytes.length)) != -1) {
                    os.write(bytes, 0, n);
                }
                bytes = null;
                ByteArrayInputStream bis = new ByteArrayInputStream(os.toByteArray());
                os.close();
                ByteArrayInputStream byteArrayInputStream = bis;
                return byteArrayInputStream;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpConn != null) {
                try {
                    httpConn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

