/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.res;

import com.sonyericsson.tvm.log.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

public class Images {
    private static final String REAL_SERVER_IP = "193.23.132.8";
    private static final String LOCALHOST = "localhost";
    private static final String FORMAT = "image/jpeg";
    private static final String QUALITY = "quality";
    private static final int IMAGE_QUALITY = 75;
    private static final String IMAGE_FORMAT_CONTROL = "javax.microedition.amms.control.ImageFormatControl";
    private static final String IMAGE_TRANSFORM_CONTROL = "javax.microedition.amms.control.imageeffect.ImageTransformControl";
    public static final Image TIPS = Images.createImage("/bg/tips.png");
    public static final Image TIPS_BLUR = Images.createImage("/bg/tips_No_Shadow.png");
    public static final Image TIPS01 = Images.createImage("/bg/tips01.png");
    public static final Image TIPS02 = Images.createImage("/bg/tips02.png");
    public static final Image TIPS03 = Images.createImage("/bg/tips03.png");
    public static final Image TIPS04 = Images.createImage("/bg/tips04.png");
    public static final Image LSK = Images.createImage("/icon/lsk.png");
    public static final Image PENDING_FG = Images.createImage("/textbox/loading_bar.png");
    public static final Image PENDING_BG = Images.createImage("/textbox/loading_background_white.png");
    public static final Image DUMMY_IMG = Images.createImage("/icon/summy_channel_icon.png");
    public static final Image LEFT = Images.createImage("/icon/arrow.png");
    public static final Image LEFT_BLUR = Images.blurImage(LEFT);
    public static final Image LEFT_PRESSED = Images.createImage("/icon/arrow_Pressed.png");
    public static final Image RIGHT = Images.createFlipImage(LEFT);
    public static final Image RIGHT_BLUR = Images.blurImage(RIGHT);
    public static final Image RIGHT_PRESSED = Images.createFlipImage(LEFT_PRESSED);
    private static MediaProcessor mp;
    private static ImageTransformControl transform;

    public static Image createImage(String filename) {
        try {
            return Image.createImage((String)filename);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Image createConnectionImage(String uri) {
        uri = Images.replaceLocalhost(uri);
        DataInputStream is = null;
        try {
            int ch;
            is = Connector.openDataInputStream((String)uri);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = ((InputStream)is).read()) != -1) {
                os.write(ch);
            }
            byte[] bytes = os.toByteArray();
            os.close();
            Image image = Image.createImage((byte[])bytes, (int)0, (int)bytes.length);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String replaceLocalhost(String uri) {
        int index = uri.indexOf(LOCALHOST);
        if (index != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append(uri.substring(0, index));
            sb.append(REAL_SERVER_IP);
            sb.append(uri.substring(index + LOCALHOST.length()));
            uri = sb.toString();
        }
        return uri;
    }

    public static byte[] getOnlineBuffer(String uri) {
        InputStream is = null;
        ByteArrayOutputStream os = null;
        uri = Images.replaceLocalhost(uri);
        try {
            int ch;
            Log.info("img url: " + uri);
            is = Connector.openDataInputStream((String)uri);
            os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static Image createFlipImage(Image image) {
        if (image == null) {
            return null;
        }
        return Image.createImage((Image)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (int)3);
    }

    public static Image enlargeImage(Image in, int width, int height) {
        try {
            Images.createMediaProcessor();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            mp.setInput((Object)in);
            mp.setOutput((OutputStream)outputStream);
            transform = Images.getTransformControl();
            int origWidth = transform.getSourceWidth();
            int origHeight = transform.getSourceHeight();
            transform.setEnabled(true);
            transform.setSourceRect(0, 0, origWidth, origHeight);
            transform.setTargetSize(width, height, 0);
            ImageFormatControl fc = Images.getFormatControl();
            fc.setFormat(FORMAT);
            fc.setParameter(QUALITY, 75);
            mp.complete();
            ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
            return Image.createImage((InputStream)is);
        }
        catch (Exception e) {
            e.printStackTrace();
            return in;
        }
    }

    private static ImageFormatControl getFormatControl() {
        return (ImageFormatControl)mp.getControl(IMAGE_FORMAT_CONTROL);
    }

    private static ImageTransformControl getTransformControl() {
        return (ImageTransformControl)mp.getControl(IMAGE_TRANSFORM_CONTROL);
    }

    private static void createMediaProcessor() throws MediaException {
        mp = null;
        mp = GlobalManager.createMediaProcessor((String)"image/raw");
    }

    public static Image blurImage(Image img) {
        int alf = 5;
        if (img == null) {
            System.out.println("alfImage");
            return null;
        }
        if (alf < 0) {
            alf = 0;
        } else if (alf > 10) {
            alf = 10;
        }
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        int[] RGBData = new int[imgW * imgH];
        img.getRGB(RGBData, 0, imgW, 0, 0, imgW, imgH);
        int tmp = alf * 255 / 10 << 24 | 0xFFFFFF;
        int i = 0;
        while (i < RGBData.length) {
            int n = i++;
            RGBData[n] = RGBData[n] & tmp;
        }
        Image o_Img = Image.createRGBImage((int[])RGBData, (int)imgW, (int)imgH, (boolean)true);
        return o_Img;
    }
}

