/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.rms;

import com.sonyericsson.tvm.log.Log;
import com.sonyericsson.tvm.ui.item.Channel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordManager {
    private static final String RS_CHANNEL_ID = "channel";
    private static final String RS_REMIND_ID = "Remind";
    private static final String RS_UPGRADE_ID = "Upgrade";
    private static final int SINGLETON_ID = 1;
    private static RecordStore rsNoRemind;
    private static RecordStore rsUpgrade;
    private static RecordStore rsChannel;

    private RecordManager() {
    }

    public static boolean getNoRemind() {
        boolean noRemind;
        block13: {
            noRemind = false;
            try {
                try {
                    rsNoRemind = RecordStore.openRecordStore((String)RS_REMIND_ID, (boolean)true);
                    byte[] noRemindBuffer = RecordManager.readNoRemind();
                    if (noRemindBuffer != null) {
                        DataInputStream is = new DataInputStream(new ByteArrayInputStream(noRemindBuffer));
                        noRemind = is.readBoolean();
                        is.close();
                        Object var2_3 = null;
                    }
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (rsNoRemind == null) break block13;
                    try {
                        rsNoRemind.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (rsNoRemind != null) {
                    try {
                        rsNoRemind.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return noRemind;
    }

    public static boolean updateAvailable() {
        try {
            rsUpgrade = RecordStore.openRecordStore((String)RS_UPGRADE_ID, (boolean)true);
            boolean bl = rsUpgrade != null && rsUpgrade.getNumRecords() > 0;
            return bl;
        }
        catch (Exception e) {
            Log.error(e.toString());
        }
        finally {
            if (rsUpgrade != null) {
                try {
                    rsUpgrade.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                rsUpgrade = null;
            }
        }
        return false;
    }

    public static String getUpgradeUrl() {
        String url;
        block21: {
            url = null;
            FilterInputStream is = null;
            try {
                try {
                    rsUpgrade = RecordStore.openRecordStore((String)RS_UPGRADE_ID, (boolean)true);
                    if (rsUpgrade == null || rsUpgrade.getNumRecords() <= 0) break block21;
                    byte[] buffer = RecordManager.readUpgradeUrl();
                    if (buffer != null) {
                        is = new DataInputStream(new ByteArrayInputStream(buffer));
                        url = ((DataInputStream)is).readUTF();
                        Log.debug("get" + url);
                        break block21;
                    }
                    Log.debug("get null url");
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (rsUpgrade != null) {
                        try {
                            rsUpgrade.closeRecordStore();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        rsUpgrade = null;
                    }
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    is = null;
                }
            }
            finally {
                if (rsUpgrade != null) {
                    try {
                        rsUpgrade.closeRecordStore();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    rsUpgrade = null;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    is = null;
                }
            }
        }
        return url;
    }

    public static void deleteUpgradeUrl() {
        block12: {
            try {
                try {
                    RecordStore.deleteRecordStore((String)RS_UPGRADE_ID);
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (rsUpgrade == null) break block12;
                    try {
                        rsUpgrade.closeRecordStore();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    rsUpgrade = null;
                }
            }
            finally {
                if (rsUpgrade != null) {
                    try {
                        rsUpgrade.closeRecordStore();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    rsUpgrade = null;
                }
            }
        }
    }

    private static byte[] readUpgradeUrl() throws RecordStoreNotOpenException, RecordStoreException {
        try {
            return rsUpgrade.getRecord(1);
        }
        catch (InvalidRecordIDException e) {
            Log.error(e.toString());
            return null;
        }
    }

    public static void setUpgradeUrl(String url) {
        block20: {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream writor = new DataOutputStream(os);
            try {
                try {
                    Log.debug(url);
                    rsUpgrade = RecordStore.openRecordStore((String)RS_UPGRADE_ID, (boolean)true);
                    writor.writeUTF(url);
                    writor.flush();
                    byte[] bytes = os.toByteArray();
                    Log.debug("bytes length: " + bytes.length);
                    os = null;
                    rsUpgrade.addRecord(bytes, 0, bytes.length);
                    Log.debug("add record");
                    bytes = null;
                    Log.debug("set successfully");
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (rsUpgrade != null) {
                        try {
                            rsUpgrade.closeRecordStore();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (writor == null) break block20;
                    try {
                        writor.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    writor = null;
                }
            }
            finally {
                if (rsUpgrade != null) {
                    try {
                        rsUpgrade.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
                if (writor != null) {
                    try {
                        writor.close();
                    }
                    catch (IOException iOException) {}
                    writor = null;
                }
            }
        }
    }

    private static byte[] readNoRemind() throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        if (rsNoRemind != null && rsNoRemind.getNumRecords() > 0) {
            return rsNoRemind.getRecord(1);
        }
        return null;
    }

    public static void setNoRemind(boolean noRemind) {
        block13: {
            try {
                try {
                    rsNoRemind = RecordStore.openRecordStore((String)RS_REMIND_ID, (boolean)true);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    DataOutputStream writor = new DataOutputStream(os);
                    writor.writeBoolean(noRemind);
                    byte[] bytes = os.toByteArray();
                    writor.close();
                    writor = null;
                    byte[] record = RecordManager.readNoRemind();
                    if (record != null) {
                        rsNoRemind.deleteRecord(1);
                        record = null;
                    }
                    rsNoRemind.addRecord(bytes, 0, bytes.length);
                    bytes = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (rsNoRemind == null) break block13;
                    try {
                        rsNoRemind.closeRecordStore();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (rsNoRemind != null) {
                    try {
                        rsNoRemind.closeRecordStore();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static boolean openChannelStore() {
        try {
            rsChannel = RecordStore.openRecordStore((String)RS_CHANNEL_ID, (boolean)true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void addChannel(byte[] data) {
        if (rsChannel != null) {
            try {
                rsChannel.addRecord(data, 0, data.length);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setChannel(int id, byte[] data) {
        if (rsChannel != null) {
            try {
                try {
                    rsChannel.getRecord(id);
                    rsChannel.setRecord(id, data, 0, data.length);
                }
                catch (InvalidRecordIDException e) {
                    rsChannel.addRecord(data, 0, data.length);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] getChannel(int id) {
        if (rsChannel != null) {
            try {
                return rsChannel.getRecord(id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] getChannelImage(int id) {
        if (rsChannel != null) {
            FilterInputStream reader = null;
            try {
                byte[] data = rsChannel.getRecord(id);
                reader = new DataInputStream(new ByteArrayInputStream(data));
                ((DataInputStream)reader).readUTF();
                ((DataInputStream)reader).readUTF();
                ((DataInputStream)reader).readLong();
                int len = ((DataInputStream)reader).readInt();
                if (len > 0) {
                    int i = 0;
                    while (i < len) {
                        ((DataInputStream)reader).readUTF();
                        ++i;
                    }
                }
                if ((len = ((DataInputStream)reader).readInt()) > 0) {
                    byte[] bytes = new byte[len];
                    ((DataInputStream)reader).read(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static void removeAllChannels() {
        RecordManager.closeChannelStore();
        try {
            RecordStore.deleteRecordStore((String)RS_CHANNEL_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Channel[] getAllChannels() {
        if (rsChannel != null) {
            try {
                int size = rsChannel.getNumRecords();
                if (size > 0) {
                    Channel[] channels = new Channel[size];
                    int i = 0;
                    while (i < size) {
                        channels[i] = Channel.deSerialize(rsChannel.getRecord(i + 1));
                        ++i;
                    }
                    return channels;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Channel[0];
    }

    public static boolean existChannelStore() {
        try {
            rsChannel = RecordStore.openRecordStore((String)RS_CHANNEL_ID, (boolean)false);
            boolean bl = rsChannel != null && rsChannel.getNumRecords() > 0;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            RecordManager.closeChannelStore();
        }
        return false;
    }

    public static synchronized void closeChannelStore() {
        if (rsChannel != null) {
            try {
                rsChannel.closeRecordStore();
                rsChannel = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

