/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import com.sonyericsson.tvm.ui.IBaseMIDlet;
import com.sonyericsson.tvm.ui.item.Channel;
import com.sonyericsson.tvm.ui.item.ChannelHost;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FocusView
extends AbstractHomescreenCanvas {
    private static final int FOCUS_FRAME_COLOR = 7978800;
    private static final int FRAME_COLOR = 0xFFFFFF;
    private static final int FRAME_COLOR_BLUR = 0x707470;
    private static final int ARROW_MARGIN = 4;
    private static final int ARROW_PADDING = 4;
    private static final int BUTTOM_HEIGHT = 80;
    private static final int WIDTH_ICON_FOCUS = 74;
    private static final int HEIGHT_ICON_FOCUS = 56;
    private static final int WIDTH_ICON = 37;
    private static final int HEIGHT_ICON = 28;
    private static final int WIDTH_ARROW = 10;
    private static final int TEXT_DESC_X = 20;
    private static final int ITEM_DESC_FONT_HEIGHT = Strings.CONTENT_FONT.getHeight();
    private static final int STYLE_TEXT = 65;
    private static final int STYLE_DESC = 68;
    private static final int STYLE_IMAGE = 3;
    private static final int STYLE_ARROW_LEFT = 6;
    private static final int STYLE_ARROW_RIGHT = 10;
    private static final int STYLE_IMAGE_BG = 33;
    public static final Font TITLE_FONT = Font.getFont((int)0, (int)1, (int)8);
    private static final int FREQUENCY = 20;
    private static final int ANIMATION_PERIOD = 250;
    private static final int SHOW_TIP_PERIOD = 200;
    private static final int REFRESH_PERIOD = 30;
    private static final int TIP_MAX_FRAME = 5;
    private static final int FOCUS_MAX_FRAMES = 3;
    private static final int DISTANCE_NORMAL = 40;
    private static final int LOST_FOCUS_DELAY = 18000;
    private static final int LOST_FOCUS_CHECK_INTERVAL = 1000;
    private static final int INITAL = 0;
    private static final int ANIMATE = 1;
    private static final int ENLARGE = 2;
    private static final int SHOW_TIP = 3;
    private static final int SHOW_TEXT = 4;
    private static final int STAND_BY = 5;
    private final int channelButtom;
    private final int channelHCenter;
    private final int tipButtom;
    private final int channelTop;
    private final int height;
    private final int width;
    private final int tipHeight;
    private final int channelLeft;
    private final int vCenter;
    private final int tipTop;
    private final int titleLine;
    private final int descLine;
    private final int channelWidth;
    private final int channelRight;
    private final int rightArrowLeft;
    private final int rightArrowRight;
    private ChannelHost host;
    private Image leftArrow;
    private Image rightArrow;
    private int xOffset;
    private static Timer timer;
    private Image tipBG;
    private Image focusIcon;
    private Image tmpImage;
    private int state;
    public boolean isBlur;
    private long lastActiveTime;
    private int left2x;
    private int left1x;
    private int right1x;
    private int right2x;
    private int tmpx;
    private RefreshTask refreshTask;
    private TimerTask autoLostFocus;
    private IBaseMIDlet midlet;

    public FocusView(IBaseMIDlet midlet) {
        this.midlet = midlet;
        this.host = ChannelHost.getInstance();
        this.leftArrow = Images.LEFT_BLUR;
        this.rightArrow = Images.RIGHT_BLUR;
        this.tipBG = Images.TIPS_BLUR;
        this.resetFocusIcon();
        this.state = 0;
        timer = new Timer();
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.channelButtom = this.height - 80;
        this.channelHCenter = this.channelButtom - 28;
        this.tipButtom = this.channelButtom - 58;
        this.channelTop = this.channelButtom - 56;
        this.tipHeight = this.tipBG.getHeight();
        this.channelLeft = 18;
        this.vCenter = this.width / 2;
        this.tipTop = this.tipButtom - this.tipHeight;
        this.titleLine = this.tipTop + 25;
        this.descLine = this.tipTop + 50;
        this.channelWidth = this.width - 20 - 8 - 8 + 1;
        this.channelRight = this.channelLeft + this.channelWidth;
        this.left1x = this.vCenter - 40;
        this.left2x = this.left1x - 40;
        this.right1x = this.vCenter + 40;
        this.right2x = this.right1x + 40;
        this.rightArrowRight = this.width - 4;
        this.rightArrowLeft = this.rightArrowRight - 10;
    }

    public void resetFocusIcon() {
        this.focusIcon = this.host.getChanenl((int)0).focusIcon;
    }

    public void stopRefresh() {
        if (this.refreshTask != null) {
            this.refreshTask.cancel();
            this.refreshTask = null;
        }
    }

    public void startRefresh() {
        if (this.refreshTask == null) {
            this.refreshTask = new RefreshTask();
            timer.scheduleAtFixedRate((TimerTask)this.refreshTask, 0L, 30L);
        }
    }

    private TimerTask getMoveLeftTask() {
        this.tmpx = this.left2x - 40;
        this.tmpImage = this.getChannelImage(-3);
        return new AnimateTask(){

            protected void finish() {
                FocusView.this.host.left();
            }

            protected void progress() {
                FocusView focusView = FocusView.this;
                focusView.xOffset = focusView.xOffset + 2;
            }
        };
    }

    private TimerTask getMoveRightTask() {
        this.tmpx = this.right2x + 40;
        this.tmpImage = this.getChannelImage(3);
        return new AnimateTask(){

            protected void progress() {
                FocusView focusView = FocusView.this;
                focusView.xOffset = focusView.xOffset - 2;
            }

            protected void finish() {
                FocusView.this.host.right();
            }
        };
    }

    protected void paint(Graphics g) {
        this.drawLeftArrow(g);
        this.drawRightArrow(g);
        Channel focusItem = this.host.getChanenl(0);
        if (this.state != 1 && this.state != 2) {
            this.drawTipBackground(g);
            if (this.state != 3) {
                this.drawText(g, focusItem);
            }
        }
        if (this.state == 1) {
            this.focusIcon = this.getChannelImage(focusItem);
        }
        this.drawChannels(g);
        if (this.state == 0 || this.state == 4) {
            this.state = 5;
        }
    }

    private void drawRightArrow(Graphics g) {
        g.setClip(this.rightArrowLeft, this.tipButtom, 10, this.channelButtom);
        g.drawImage(this.rightArrow, this.rightArrowRight, this.channelHCenter, 10);
    }

    private void drawLeftArrow(Graphics g) {
        g.setClip(4, this.tipButtom, 10, this.channelButtom);
        g.drawImage(this.leftArrow, 4, this.channelHCenter, 6);
    }

    private void drawChannels(Graphics g) {
        g.setClip(this.channelLeft, this.channelTop, this.channelWidth, 74);
        this.drawFrameImage(g, this.getChannelImage(-2), this.left2x + this.xOffset, this.channelHCenter);
        this.drawFrameImage(g, this.getChannelImage(-1), this.left1x + this.xOffset, this.channelHCenter);
        this.drawFrameImage(g, this.getChannelImage(1), this.right1x + this.xOffset, this.channelHCenter);
        this.drawFrameImage(g, this.getChannelImage(2), this.right2x + this.xOffset, this.channelHCenter);
        if (this.state == 1 && this.tmpImage != null) {
            this.drawFrameImage(g, this.tmpImage, this.tmpx + this.xOffset, this.channelHCenter);
        }
        this.drawFocusFrameImage(g, this.focusIcon, this.vCenter + this.xOffset, this.channelHCenter);
    }

    private void drawFrameImage(Graphics g, Image img, int vMiddle, int hMiddle) {
        int width = img.getWidth();
        int height = img.getHeight();
        g.drawImage(img, vMiddle, hMiddle, 3);
        g.setColor(this.getFrameColor());
        g.drawRect(vMiddle - width / 2, hMiddle - height / 2, width - 1, height - 1);
    }

    private int getFrameColor() {
        return this.isBlur ? 0x707470 : 0xFFFFFF;
    }

    private void drawFocusFrameImage(Graphics g, Image img, int vMiddle, int hMiddle) {
        int width = img.getWidth();
        int height = img.getHeight();
        g.drawImage(img, vMiddle, hMiddle, 3);
        if (this.state == 1) {
            g.setColor(this.getFrameColor());
        } else {
            g.setColor(7978800);
        }
        g.drawRect(vMiddle - width / 2, hMiddle - height / 2, width - 1, height - 1);
    }

    private Image getChannelImage(int offset) {
        Channel chanenl = this.host.getChanenl(offset);
        return this.getChannelImage(chanenl);
    }

    private Image getChannelImage(Channel chanenl) {
        return this.isBlur ? chanenl.blurIcon : chanenl.icon;
    }

    private void drawText(Graphics g, Channel focusItem) {
        g.setFont(TITLE_FONT);
        g.setClip(0, this.tipTop, this.width, this.tipHeight);
        g.setColor(3488575);
        g.drawString(focusItem.title, this.vCenter, this.titleLine, 65);
        g.setFont(Strings.CONTENT_FONT);
        int i = 0;
        while (i < focusItem.desc.length) {
            if (focusItem.desc[i] != null) {
                g.drawString(focusItem.desc[i], 20, this.descLine + i * ITEM_DESC_FONT_HEIGHT, 68);
            }
            ++i;
        }
    }

    private void drawTipBackground(Graphics g) {
        g.setClip(0, this.tipTop, this.width, this.tipHeight);
        g.drawImage(this.tipBG, this.vCenter, this.tipButtom, 33);
    }

    public void keyPressed(int keyCode) {
        this.lastActiveTime = System.currentTimeMillis();
        switch (this.getGameAction(keyCode)) {
            case 2: {
                this.leftArrow = Images.LEFT_PRESSED;
                this.state = 1;
                this.repaint(0, this.tipTop, this.width, this.tipHeight);
                timer.schedule(this.getMoveLeftTask(), 0L, 12L);
                break;
            }
            case 5: {
                this.rightArrow = Images.RIGHT_PRESSED;
                this.state = 1;
                this.repaint(0, this.tipTop, this.width, this.tipHeight);
                timer.schedule(this.getMoveRightTask(), 0L, 12L);
                break;
            }
            default: {
                super.keyPressed(keyCode);
                return;
            }
        }
    }

    public void keyRepeated(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 2: {
                if (this.state == 1) break;
                this.keyPressed(keyCode);
                break;
            }
            case 5: {
                if (this.state == 1) break;
                this.keyPressed(keyCode);
                break;
            }
            default: {
                super.keyRepeated(keyCode);
                return;
            }
        }
    }

    public void keyReleased(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 2: {
                this.resetLeftArrow();
                break;
            }
            case 5: {
                this.resetRightArrow();
                break;
            }
            default: {
                super.keyPressed(keyCode);
                return;
            }
        }
    }

    public void resetRightArrow() {
        this.rightArrow = this.isBlur ? Images.RIGHT_BLUR : Images.RIGHT;
        this.repaint(this.channelRight, this.tipButtom, 10, this.channelButtom);
    }

    public void resetLeftArrow() {
        this.leftArrow = this.isBlur ? Images.LEFT_BLUR : Images.LEFT;
        this.repaint(0, this.tipButtom, 10, this.channelButtom);
    }

    public void resetArrows() {
        this.resetLeftArrow();
        this.resetRightArrow();
    }

    public void addTask(TimerTask task, long delay, long period) {
        timer.schedule(task, delay, period);
    }

    private Image enlargeFocus(int width, int height) {
        return Images.enlargeImage(this.host.getChanenl((int)0).icon, width, height);
    }

    private Image getTips() {
        return this.isBlur ? Images.TIPS_BLUR : Images.TIPS;
    }

    public synchronized void doRepaint() {
        this.repaint(0, this.tipTop, this.width, this.tipHeight);
        this.repaint(this.channelLeft, this.channelTop, this.channelWidth, 56);
    }

    public void resetTip() {
        this.tipBG = this.getTips();
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    protected void showNotify() {
        if (!this.isBlur) {
            this.resetFocusIcon();
            this.startAutoLostFoucs();
            this.midlet.enterFocus();
        }
        this.doRepaint();
        this.startRefresh();
    }

    protected void hideNotify() {
        this.stopLostFocus();
        this.stopRefresh();
    }

    public void setLastActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    public void startAutoLostFoucs() {
        if (this.autoLostFocus != null) {
            this.stopLostFocus();
        }
        this.setLastActiveTime();
        this.autoLostFocus = new TimerTask(){

            public void run() {
                if (System.currentTimeMillis() - FocusView.this.lastActiveTime > 18000L) {
                    FocusView.this.midlet.leaveFocus();
                    FocusView.this.midlet.enterUnfocus();
                }
            }
        };
        this.addTask(this.autoLostFocus, 18000L, 1000L);
    }

    public void stopLostFocus() {
        if (this.autoLostFocus != null) {
            this.autoLostFocus.cancel();
            this.autoLostFocus = null;
        }
    }

    abstract class AnimateTask
    extends TimerTask {
        int i = 0;
        protected final int STEP;

        AnimateTask() {
            this.STEP = 2;
        }

        public void run() {
            if (FocusView.this.state != 1) {
                this.cancel();
                return;
            }
            ++this.i;
            this.progress();
            if (this.i == 20) {
                this.finish();
                FocusView.this.xOffset = 0;
                FocusView.this.resetFocusIcon();
                FocusView.this.state = 2;
                FocusView.this.tmpImage = null;
                timer.schedule((TimerTask)new EnlargeTask(), 0L, 100L);
                this.cancel();
            }
        }

        protected abstract void progress();

        protected abstract void finish();
    }

    class EnlargeTask
    extends TimerTask {
        private int i;

        EnlargeTask() {
        }

        public void run() {
            if (FocusView.this.state != 2) {
                this.cancel();
                return;
            }
            ++this.i;
            if (this.i > 3) {
                FocusView.this.state = 3;
                FocusView.this.tipBG = Images.TIPS01;
                timer.schedule((TimerTask)new ShowTipTask(), 0L, 40L);
                this.cancel();
                return;
            }
            int width = 37 + 37 * this.i / 3;
            int height = 28 + 28 * this.i / 3;
            if (width == 74 && height == 56) {
                FocusView.this.resetFocusIcon();
            } else {
                FocusView.this.focusIcon = FocusView.this.enlargeFocus(width, height);
            }
        }
    }

    class RefreshTask
    extends TimerTask {
        RefreshTask() {
        }

        public void run() {
            if (FocusView.this.state == 5) {
                return;
            }
            FocusView.this.doRepaint();
        }
    }

    class ShowTipTask
    extends TimerTask {
        private int i;

        ShowTipTask() {
        }

        public void run() {
            if (FocusView.this.state != 3) {
                this.cancel();
                return;
            }
            ++this.i;
            FocusView.this.tipBG = null;
            switch (this.i) {
                case 1: {
                    FocusView.this.tipBG = Images.TIPS01;
                    break;
                }
                case 2: {
                    FocusView.this.tipBG = Images.TIPS02;
                    break;
                }
                case 3: {
                    FocusView.this.tipBG = Images.TIPS03;
                    break;
                }
                case 4: {
                    FocusView.this.tipBG = Images.TIPS04;
                    break;
                }
            }
            if (this.i == 5) {
                FocusView.this.tipBG = FocusView.this.getTips();
                FocusView.this.state = 4;
                this.cancel();
            }
        }
    }
}

