/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui;

import com.sonyericsson.homescreen.Homescreen;
import com.sonyericsson.homescreen.HomescreenMIDlet;
import com.sonyericsson.homescreen.KeyListener;
import com.sonyericsson.starhub.protocol.bean.ProgramInfo;
import com.sonyericsson.starhub.protocol.bean.SubInfo;
import com.sonyericsson.tvm.log.Log;
import com.sonyericsson.tvm.mitv.MiTVStubImpl;
import com.sonyericsson.tvm.mitv.exception.MiTvException;
import com.sonyericsson.tvm.player.IPlayer;
import com.sonyericsson.tvm.player.impl.SEPlayer;
import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.rms.RecordManager;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import com.sonyericsson.tvm.ui.FocusView;
import com.sonyericsson.tvm.ui.IBaseMIDlet;
import com.sonyericsson.tvm.ui.epg.EpgBox;
import com.sonyericsson.tvm.ui.epg.EpgInfo;
import com.sonyericsson.tvm.ui.item.ChannelHost;
import com.sonyericsson.tvm.ui.textbox.MessageDialog;
import com.sonyericsson.tvm.ui.textbox.PendingDialog;
import com.sonyericsson.tvm.ui.textbox.ProgressMsgDlg;
import com.sonyericsson.tvm.ui.textbox.ReminderBox;
import com.sonyericsson.tvm.ui.textbox.ReminderCallback;
import com.sonyericsson.tvm.ui.textbox.SelectionDialog;
import com.sonyericsson.tvm.ui.textbox.SubscribeInfoDialog;
import com.sonyericsson.tvm.update.UpdateManager;
import com.sonyericsson.tvm.update.UpdateThread;
import com.sonyericsson.tvm.upgrade.UpgradeManager;
import java.util.TimerTask;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MobileTVMIDlet
extends HomescreenMIDlet
implements IBaseMIDlet,
KeyListener,
CommandListener {
    private static final int INTERVAL_PERIOD = 4000;
    private static final int DELAY_PERIOD = 3000;
    public static String rssUrl;
    public static String updateUrl;
    public static String appVersion;
    int mode;
    public static final int UNFOCUS_MODE = 0;
    public static final int FOCUS_MODE = 1;
    public static final int HIDE_MODE = 2;
    final Homescreen homescreen;
    private Display display;
    private IPlayer player;
    private UpgradeManager upgradeManager;
    private ChannelHost host = ChannelHost.getInstance();
    private ReminderCallback updateProgressInvocation;
    private ReminderCallback playInvoaction;
    private MiTVStubImpl stub;
    final FocusView view;
    private ReminderBox reminderView;
    private ProgressMsgDlg progressView;
    private MessageDialog msgDialog;
    private PendingDialog pending;
    private Command cancelProgressAction;
    private Command refreshAction;
    private Command viewAction;
    private Command hideAction;
    private Command debugAction;
    private final Command okCmd = new Command("OK", 4, 0);
    private final Command cancelCmd = new Command("Cancel", 3, 0);
    private final Command epgCmd = new Command("Program Guide", 1, 0);
    private TimerTask rotateTask;
    private Thread updateThread;
    private Thread upgradeThread;

    public MobileTVMIDlet() {
        rssUrl = this.getAppProperty("Rss-Url");
        updateUrl = this.getAppProperty("Update-Url");
        appVersion = this.getAppProperty("MIDlet-Version");
        this.view = new FocusView(this);
        this.homescreen = this.getHomescreen();
        this.msgDialog = new MessageDialog("", this, 0);
        this.msgDialog.setShowListener(this);
    }

    private void initHomeScreen() {
        this.homescreen.setKey(2, Images.LSK);
        this.homescreen.setStandbyInformation(true);
        this.homescreen.setTransparent(true);
        this.homescreen.addKeyListener((KeyListener)this);
    }

    public void keyPressed(int key) {
        if (2 == key) {
            switch (this.mode) {
                case 0: {
                    this.leaveUnfocus();
                    this.enterFocus();
                    break;
                }
                case 2: {
                    this.leaveHide();
                    this.enterFocus();
                    break;
                }
            }
        }
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        if (!unconditional) {
            this.leaveFocus();
            this.enterUnfocus();
            this.display.setCurrent((Displayable)this.view);
            this.pending.isCancel = true;
            if (this.updateThread != null) {
                UpdateManager.getInstance().cancel = true;
                this.updateThread = null;
            }
            if (this.upgradeThread != null) {
                this.upgradeThread.interrupt();
                this.upgradeThread = null;
            }
            throw new MIDletStateChangeException();
        }
    }

    protected void pauseApp() {
        Log.info("Pause");
    }

    protected void startApp() throws MIDletStateChangeException {
        this.pending = this.createPendingDialog();
        this.stub = MiTVStubImpl.getInstance(rssUrl);
        if (this.homescreen != null) {
            this.initHomeScreen();
            this.display = Display.getDisplay((MIDlet)this);
            this.initFocusPage();
            if (this.upgradeManager == null) {
                this.upgradeManager = new UpgradeManager(updateUrl, appVersion);
            }
            if (RecordManager.updateAvailable()) {
                UpgradeDialog updateDialog = new UpgradeDialog(this.display, new String[]{"A newer StarHubTV", "is available. Upgrade", "now? Data transmission", "charges may apply."}, "Upgrade now", "Remind next time");
                updateDialog.setShowListener(this);
                updateDialog.show(null);
                this.homescreen.leaveStandby();
            } else {
                this.enterUnfocus();
                this.display.setCurrent((Displayable)this.view);
                this.view.startRefresh();
            }
        }
    }

    void startRotate() {
        if (this.rotateTask == null) {
            this.rotateTask = this.createUnfocusTask();
        }
        this.view.addTask(this.rotateTask, 3000L, 4000L);
    }

    private void initFocusPage() {
        this.view.addCommand(this.epgCmd);
        this.refreshAction = new Command("Refresh", 1, 0);
        this.view.addCommand(this.refreshAction);
        this.viewAction = new Command("View", 4, 0);
        this.view.addCommand(this.viewAction);
        this.hideAction = new Command("Hide", 2, 0);
        this.view.addCommand(this.hideAction);
        this.debugAction = new Command("Debug", 1, 0);
        this.view.setCommandListener(this);
        this.view.setShowListener(this);
    }

    private void createPlayer() {
        this.player = new SEPlayer((MIDlet)this);
    }

    private void createReminderView(ReminderCallback r) {
        if (this.reminderView == null) {
            this.reminderView = new ReminderBox(this.display, this);
        }
        this.reminderView.reset();
        this.reminderView.show(r);
        this.reminderView.setShowListener(this);
    }

    private TimerTask createUnfocusTask() {
        return new TimerTask(){

            public void run() {
                int key = -4;
                MobileTVMIDlet.this.view.keyPressed(key);
                MobileTVMIDlet.this.view.keyReleased(key);
            }
        };
    }

    private void stopRotate() {
        if (this.rotateTask != null) {
            this.rotateTask.cancel();
            this.rotateTask = null;
        }
    }

    private UpdateThread createUpdateThread(ProgressMsgDlg progress) {
        return new UpdateThread(rssUrl, progress, this);
    }

    public void show() {
        if (!this.view.isBlur) {
            this.enterFocus();
            Log.info("midlet show");
            this.display.setCurrent((Displayable)this.view);
        }
    }

    private void checkUpgradeVersion() {
        if (this.upgradeManager != null) {
            new Thread(){

                public void run() {
                    RecordManager.deleteUpgradeUrl();
                    MobileTVMIDlet.this.upgradeManager.checkUpgrade();
                }
            }.start();
        }
    }

    public void enterUnfocus() {
        this.show((Displayable)this.view);
        this.view.isBlur = true;
        this.homescreen.enterStandby();
        this.view.resetTip();
        this.view.resetArrows();
        this.view.doRepaint();
        this.startRotate();
        this.mode = 0;
    }

    protected void leaveUnfocus() {
        this.stopRotate();
        this.view.isBlur = false;
    }

    protected void enterHide() {
        this.display.setCurrent(null);
        this.view.stopRefresh();
        this.mode = 2;
    }

    protected void leaveHide() {
        this.display.setCurrent((Displayable)this.view);
        this.view.startRefresh();
    }

    public void enterFocus() {
        this.view.resetTip();
        this.view.resetArrows();
        this.view.doRepaint();
        this.view.startAutoLostFoucs();
        this.homescreen.leaveStandby();
        this.mode = 1;
    }

    public void leaveFocus() {
        this.view.stopLostFocus();
    }

    public void commandAction(Command c, Displayable d) {
        this.view.setLastActiveTime();
        if (this.refreshAction.equals(c)) {
            this.view.stopRefresh();
            this.leaveFocus();
            if (this.updateProgressInvocation == null) {
                this.updateProgressInvocation = this.createUpdateProgress();
            }
            this.createReminderView(this.updateProgressInvocation);
            return;
        }
        if (this.hideAction.equals(c)) {
            this.leaveFocus();
            this.enterHide();
            this.homescreen.enterStandby();
            return;
        }
        if (this.viewAction.equals(c)) {
            this.view.stopRefresh();
            this.view.stopLostFocus();
            if (this.playInvoaction == null) {
                this.playInvoaction = this.createPlayProgress();
            }
            this.createReminderView(this.playInvoaction);
            return;
        }
        if (this.debugAction.equals(c)) {
            Log.show(this.display);
            return;
        }
        if (c.equals(this.cancelProgressAction)) {
            if (this.updateThread != null) {
                UpdateManager.getInstance().cancel = true;
                this.updateThread = null;
                this.show();
            }
        } else if (c.equals(this.epgCmd)) {
            GuideInvocation guideInvocation = new GuideInvocation();
            this.createReminderView(guideInvocation);
        } else if (c.equals(this.okCmd)) {
            this.show();
        }
    }

    private ReminderCallback createPlayProgress() {
        return new PlayInvocation();
    }

    private ReminderCallback createUpdateProgress() {
        return new UpdateInvocation();
    }

    public void show(Displayable d) {
        this.display.setCurrent(d);
    }

    private PendingDialog createPendingDialog() {
        final PendingDialog pendingDialog = new PendingDialog();
        pendingDialog.reset();
        pendingDialog.addCommand(this.cancelCmd);
        pendingDialog.setShowListener(this);
        pendingDialog.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.equals(MobileTVMIDlet.this.cancelCmd)) {
                    pendingDialog.isCancel = true;
                    MobileTVMIDlet.this.display.setCurrent((Displayable)MobileTVMIDlet.this.view);
                }
            }
        });
        return pendingDialog;
    }

    private void showFailedMessage(String message) {
        if (this.pending.isCancel) {
            return;
        }
        this.msgDialog.setTimeout(0);
        this.msgDialog.setMessage(message);
        this.display.setCurrent((Displayable)this.msgDialog);
    }

    public String getChannelDesc(String channelId) {
        return this.getAppProperty(channelId);
    }

    public void hanedle(AbstractHomescreenCanvas canvas) {
        this.homescreen.leaveStandby();
    }

    private final class GuideInvocation
    implements ReminderCallback,
    Runnable {
        private static final int MAX_PROGRAM = 2;

        private GuideInvocation() {
        }

        public void call() {
            MobileTVMIDlet.this.pending.reset();
            MobileTVMIDlet.this.display.setCurrent((Displayable)MobileTVMIDlet.this.pending);
            new Thread(this).start();
        }

        public void run() {
            block8: {
                try {
                    String id = ((MobileTVMIDlet)MobileTVMIDlet.this).host.getChanenl((int)0).title;
                    ProgramInfo[] infoes = MobileTVMIDlet.this.stub.getGuide(id);
                    if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                        return;
                    }
                    if (infoes.length > 0) {
                        int length = infoes.length > 2 ? 2 : infoes.length;
                        EpgInfo[] programs = new EpgInfo[length];
                        int i = 0;
                        while (i < programs.length) {
                            programs[i] = new EpgInfo(infoes[i]);
                            ++i;
                        }
                        EpgBox guideDialog = new EpgBox();
                        guideDialog.setEpgInfos(programs);
                        guideDialog.addCommand(MobileTVMIDlet.this.okCmd);
                        guideDialog.setCommandListener(MobileTVMIDlet.this);
                        guideDialog.setShowListener(MobileTVMIDlet.this);
                        if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                            return;
                        }
                        MobileTVMIDlet.this.show((Displayable)guideDialog);
                    } else if (!((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                        MobileTVMIDlet.this.showFailedMessage("Failed to get Guide!");
                    }
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) break block8;
                    MobileTVMIDlet.this.showFailedMessage("Failed to get Guide!");
                }
            }
        }
    }

    private final class PlayInvocation
    implements ReminderCallback,
    Runnable {
        private PlayInvocation() {
        }

        public void call() {
            MobileTVMIDlet.this.pending.reset();
            MobileTVMIDlet.this.display.setCurrent((Displayable)MobileTVMIDlet.this.pending);
            new Thread(this).start();
        }

        public void run() {
            block10: {
                try {
                    String id = ((MobileTVMIDlet)MobileTVMIDlet.this).host.getChanenl((int)0).title;
                    boolean accessAllowed = ((MobileTVMIDlet)MobileTVMIDlet.this).host.getChanenl((int)0).accessAllowed;
                    String url = MobileTVMIDlet.this.stub.getChannelUrl(id, accessAllowed);
                    if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                        return;
                    }
                    Log.debug("show url: " + url);
                    if (url == null) {
                        SubInfo info = MobileTVMIDlet.this.stub.getSubscribeInfo(id);
                        if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                            return;
                        }
                        if (info.subId == null) {
                            ((MobileTVMIDlet)MobileTVMIDlet.this).host.getChanenl((int)0).accessAllowed = true;
                            url = MobileTVMIDlet.this.stub.getChannelUrl(id, true);
                            this.play(url);
                        } else {
                            SubscribeInfoDialog subinfoDialog = new SubscribeInfoDialog();
                            subinfoDialog.setInfo(info);
                            subinfoDialog.addCommand(MobileTVMIDlet.this.okCmd);
                            subinfoDialog.addCommand(MobileTVMIDlet.this.cancelCmd);
                            MobileTVMIDlet.this.display.setCurrent((Displayable)subinfoDialog);
                            subinfoDialog.setCommandListener(new CommandListener(this, info, id, accessAllowed){
                                final /* synthetic */ PlayInvocation this$1;
                                private final /* synthetic */ SubInfo val$info;
                                private final /* synthetic */ String val$id;
                                private final /* synthetic */ boolean val$accessAllowed;
                                {
                                    this.this$1 = playInvocation;
                                    this.val$info = subInfo;
                                    this.val$id = string;
                                    this.val$accessAllowed = bl;
                                }

                                public void commandAction(Command c, Displayable d) {
                                    if (c.equals(MobileTVMIDlet.access$4(PlayInvocation.access$2(this.this$1)))) {
                                        boolean result = false;
                                        try {
                                            result = MobileTVMIDlet.access$3(PlayInvocation.access$2(this.this$1)).subscribe(this.val$info.subId);
                                        }
                                        catch (MiTvException e) {
                                            Log.error(e.toString());
                                            if (!MobileTVMIDlet.access$0((MobileTVMIDlet)PlayInvocation.access$2((PlayInvocation)this.this$1)).isCancel) {
                                                MobileTVMIDlet.access$5(PlayInvocation.access$2(this.this$1), "Failed to subscribe.");
                                            }
                                            return;
                                        }
                                        if (result) {
                                            try {
                                                PlayInvocation.access$0(this.this$1, MobileTVMIDlet.access$3(PlayInvocation.access$2(this.this$1)).getChannelUrl(this.val$id, this.val$accessAllowed));
                                            }
                                            catch (Exception e) {
                                                Log.error(e.toString());
                                                if (!MobileTVMIDlet.access$0((MobileTVMIDlet)PlayInvocation.access$2((PlayInvocation)this.this$1)).isCancel) {
                                                    MobileTVMIDlet.access$5(PlayInvocation.access$2(this.this$1), "Failed to play.");
                                                }
                                            }
                                        } else if (!MobileTVMIDlet.access$0((MobileTVMIDlet)PlayInvocation.access$2((PlayInvocation)this.this$1)).isCancel) {
                                            MobileTVMIDlet.access$5(PlayInvocation.access$2(this.this$1), "Failed to subscribe.");
                                        }
                                    } else if (c.equals(MobileTVMIDlet.access$6(PlayInvocation.access$2(this.this$1)))) {
                                        MobileTVMIDlet.access$1(PlayInvocation.access$2(this.this$1)).setCurrent((Displayable)PlayInvocation.access$2((PlayInvocation)this.this$1).view);
                                    }
                                }
                            });
                        }
                    } else {
                        Log.debug("show playing");
                        this.play(url);
                    }
                }
                catch (MiTvException e) {
                    Log.error(e.toString());
                    if (!((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) {
                        MobileTVMIDlet.this.showFailedMessage("Failed to connect.");
                    }
                }
                catch (Exception e) {
                    Log.error(e.toString());
                    if (((MobileTVMIDlet)MobileTVMIDlet.this).pending.isCancel) break block10;
                    MobileTVMIDlet.this.showFailedMessage("Failed to play.");
                }
            }
        }

        private void play(String url) throws ConnectionNotFoundException, Exception {
            MobileTVMIDlet.this.display.setCurrent((Displayable)MobileTVMIDlet.this.view);
            if (url.startsWith("http://")) {
                MobileTVMIDlet.this.platformRequest(url);
            } else {
                if (MobileTVMIDlet.this.player == null) {
                    MobileTVMIDlet.this.createPlayer();
                }
                MobileTVMIDlet.this.player.play(url);
            }
        }

        static /* synthetic */ void access$0(PlayInvocation playInvocation, String string) throws ConnectionNotFoundException, Exception {
            playInvocation.play(string);
        }

        static /* synthetic */ MobileTVMIDlet access$2(PlayInvocation playInvocation) {
            return playInvocation.MobileTVMIDlet.this;
        }
    }

    private final class UpdateInvocation
    implements ReminderCallback {
        private UpdateInvocation() {
        }

        public void call() {
            MobileTVMIDlet.this.checkUpgradeVersion();
            if (MobileTVMIDlet.this.progressView == null) {
                MobileTVMIDlet.this.progressView = new ProgressMsgDlg(10);
                MobileTVMIDlet.this.progressView.setShowListener(MobileTVMIDlet.this);
            } else {
                MobileTVMIDlet.this.progressView.setProgress(0);
            }
            MobileTVMIDlet.this.display.setCurrent((Displayable)MobileTVMIDlet.this.progressView);
            MobileTVMIDlet.this.updateThread = null;
            MobileTVMIDlet.this.updateThread = MobileTVMIDlet.this.createUpdateThread(MobileTVMIDlet.this.progressView);
            UpdateManager.getInstance().cancel = false;
            MobileTVMIDlet.this.updateThread.start();
            MobileTVMIDlet.this.progressView.setCommandListener(MobileTVMIDlet.this);
            if (MobileTVMIDlet.this.cancelProgressAction == null) {
                MobileTVMIDlet.this.cancelProgressAction = new Command("Cancel", 3, 0);
            }
            MobileTVMIDlet.this.progressView.addCommand(MobileTVMIDlet.this.cancelProgressAction);
        }
    }

    private final class UpgradeDialog
    extends SelectionDialog {
        private UpgradeDialog(Display display, String[] description, String option0, String option1) {
            super(display, description, option0, option1);
        }

        public void commandAction(Command c, Displayable d) {
            if (c.equals(this.selectReminderAction)) {
                switch (this.menuIdx) {
                    case 0: {
                        ProgressMsgDlg progress = new ProgressMsgDlg(10);
                        progress.setShowListener(MobileTVMIDlet.this);
                        progress.setLable("Upgrading...");
                        MobileTVMIDlet.this.display.setCurrent((Displayable)progress);
                        MobileTVMIDlet.this.upgradeThread = new Thread(this, progress){
                            final /* synthetic */ UpgradeDialog this$1;
                            private final /* synthetic */ ProgressMsgDlg val$progress;
                            {
                                this.this$1 = upgradeDialog;
                                this.val$progress = progressMsgDlg;
                            }

                            public void run() {
                                try {
                                    MobileTVMIDlet.access$17(UpgradeDialog.access$1(this.this$1)).upgrade(this.val$progress);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                UpgradeDialog.access$1(this.this$1).enterUnfocus();
                            }
                        };
                        MobileTVMIDlet.this.upgradeThread.start();
                        break;
                    }
                    case 1: {
                        MobileTVMIDlet.this.enterUnfocus();
                        break;
                    }
                }
            }
        }

        static /* synthetic */ MobileTVMIDlet access$1(UpgradeDialog upgradeDialog) {
            return upgradeDialog.MobileTVMIDlet.this;
        }
    }
}

