/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.epg;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import com.sonyericsson.tvm.ui.epg.EpgInfo;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class EpgBox
extends AbstractHomescreenCanvas {
    private static final int STYLE_IMAGE = 20;
    private Image bgImage;
    private EpgInfo[] epgInfos;
    private int bgX;
    private int bgY;
    private static final int LEFT_BG = 5;
    private static final int TOP_LABLE = 15;
    private static final int TOP_BG = 15;
    private static final int ROW_SPACING = 10;
    private static final int LOGO_W = 20;
    private static final int LOGO_H = 20;
    private String title = "Program Guide";
    private int titleX;
    private int titleY;
    private Font titleFont;
    Font contentFont;

    public EpgBox() {
        this.init();
    }

    private void init() {
        try {
            this.bgImage = Image.createImage((String)"/bg/update_result_bg.png");
            int bgWidth = this.bgImage.getWidth();
            int bgHeight = this.bgImage.getHeight();
            if (this.getWidth() > bgWidth) {
                this.bgX = (this.getWidth() - bgWidth) / 2;
            }
            if (this.getHeight() > bgHeight) {
                this.bgY = (this.getHeight() - bgHeight) / 2;
            }
            this.contentFont = Strings.NORMAL_TEXT_FONT;
            this.titleFont = Strings.TITLE_FONT;
            int lableW = this.titleFont.stringWidth(this.title);
            this.titleY = this.bgY + 15;
            if (bgWidth > lableW) {
                this.titleX = (bgWidth - lableW) / 2;
                this.titleX += this.bgX;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void paint(Graphics g) {
        g.drawImage(this.bgImage, this.bgX, this.bgY, 20);
        this.drawLable(g);
    }

    private void drawLable(Graphics g) {
        g.setFont(this.titleFont);
        g.setColor(3488575);
        g.drawString(this.title, this.titleX, this.titleY, 20);
        this.drawEpgInfo(g);
    }

    private void drawEpgInfo(Graphics g) {
        if (this.epgInfos != null && this.epgInfos.length > 0) {
            int x = this.bgX + 5;
            int y = this.titleY + 15 + this.titleFont.getHeight();
            int timeContentX = 0;
            int i = 0;
            while (i < this.epgInfos.length) {
                if (this.epgInfos[i].logoImage != null) {
                    g.drawImage(this.epgInfos[i].logoImage, x, y, 20);
                    timeContentX = x + 20 + 5;
                } else {
                    timeContentX = x;
                }
                this.drawContent(g, this.epgInfos[i].time, timeContentX, y);
                y = this.drawContent(g, this.epgInfos[i].name, x, y + this.contentFont.getHeight());
                y += 10;
                ++i;
            }
        }
    }

    private int drawContent(Graphics g, String str, int contentX, int contentY) {
        int bgW = this.bgX + this.bgImage.getWidth();
        int strW = contentX + this.contentFont.stringWidth(str);
        boolean exit = false;
        int position = 0;
        String strHead = str;
        String strTail = null;
        int count = 0;
        while (true) {
            ++count;
            while (bgW < strW) {
                position = strHead.lastIndexOf(32);
                strHead = strHead.substring(0, position);
                exit = true;
                if (count >= 2) {
                    exit = false;
                    strHead = String.valueOf(strHead) + "...";
                }
                strW = contentX + this.contentFont.stringWidth(strHead);
            }
            g.setFont(this.contentFont);
            g.setColor(3488575);
            g.drawString(strHead, contentX, contentY, 20);
            if (position >= str.length()) {
                contentY += this.contentFont.getHeight();
                break;
            }
            str = strTail = str.substring(position).trim();
            contentY += this.contentFont.getHeight();
            strW = contentX + this.contentFont.stringWidth(strTail);
            strHead = strTail;
            if (!exit) break;
            exit = false;
        }
        return contentY;
    }

    public void setEpgInfos(EpgInfo[] info) {
        if (info != null && info.length > 0) {
            int i = 0;
            while (i < info.length) {
                if (info[i].logoImage != null) {
                    Image in = info[i].logoImage;
                    info[i].logoImage = Images.enlargeImage(in, 20, 20);
                }
                ++i;
            }
        }
        this.epgInfos = info;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

