/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.item;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class Channel {
    private static final String INIT_DESC = "Select 'Refresh' in 'Options' to see latest updates.";
    private static final String INIT_URL = "";
    public Image icon;
    public Image blurIcon;
    public Image focusIcon;
    public String title;
    public String[] desc;
    public String url;
    public long timestamp;
    public boolean accessAllowed;
    private static final int TITLE_CHAR_SIZE = 18;
    public static final int DESC_LINE_CHAR_SIZE = 25;
    private static final int DESC_LINE_SIZE = 4;

    public Channel() {
        this(Images.DUMMY_IMG, "Reminder", INIT_DESC, INIT_URL, 0L, false);
    }

    private Channel(Image focusIcon, String title, String[] desc, String url, long timestamp, boolean accessAllowed) {
        this.initIcon(focusIcon);
        this.setTitle(title);
        this.desc = desc != null ? desc : new String[0];
        if (url != null) {
            this.url = url;
        } else {
            url = INIT_URL;
        }
        this.timestamp = timestamp;
        this.accessAllowed = accessAllowed;
    }

    private void initIcon(Image focusIcon) {
        this.focusIcon = Images.enlargeImage(focusIcon, 74, 56);
        this.icon = Images.enlargeImage(focusIcon, 37, 28);
        this.blurIcon = Images.blurImage(this.icon);
    }

    private Channel(Image focusIcon, String title, String desc, String url, long timestamp, boolean accessAllowed) {
        this.initIcon(focusIcon);
        this.setTitle(title);
        if (desc != null) {
            this.setDesc(desc);
        } else {
            this.desc = new String[0];
        }
        if (url != null) {
            this.url = url;
        } else {
            url = INIT_URL;
        }
        this.timestamp = timestamp;
    }

    public void setDesc(String desc) {
        this.desc = Strings.splitChannelItemStr(desc, 25, 4);
    }

    public void setTitle(String title) {
        this.title = title != null && title.trim().length() > 0 ? ((title = title.trim()).length() > 18 ? Strings.splitChannelItemStr(title, 18, 1)[0] : title) : INIT_URL;
    }

    public void setIcon(Image focusIcon) {
        if (focusIcon != null) {
            this.initIcon(focusIcon);
        } else {
            this.initIcon(Images.DUMMY_IMG);
        }
    }

    public static Channel deSerialize(byte[] data) {
        if (data == null || data.length < 1) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        DataInputStream reader = new DataInputStream(is);
        try {
            String title = reader.readUTF();
            String url = reader.readUTF();
            long timestamp = reader.readLong();
            boolean accessAllowed = reader.readBoolean();
            int len = reader.readInt();
            String[] desc = null;
            if (len > 0) {
                desc = new String[len];
                int i = 0;
                while (i < len) {
                    desc[i] = reader.readUTF();
                    ++i;
                }
            }
            len = reader.readInt();
            Image icon = null;
            if (len > 0) {
                byte[] iconBytes = new byte[len];
                reader.read(iconBytes);
                icon = Image.createImage((byte[])iconBytes, (int)0, (int)len);
                iconBytes = null;
            } else {
                icon = Images.DUMMY_IMG;
            }
            Channel channel = new Channel(icon, title, desc, url, timestamp, accessAllowed);
            return channel;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            reader = null;
            is = null;
        }
        return null;
    }

    public byte[] serialize(byte[] iconBuffer) {
        byte[] bytes = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream writor = new DataOutputStream(os);
        try {
            try {
                writor.writeUTF(this.title);
                writor.writeUTF(this.url);
                writor.writeLong(this.timestamp);
                writor.writeBoolean(this.accessAllowed);
                if (this.desc == null || this.desc.length < 1) {
                    writor.writeInt(0);
                } else {
                    writor.writeInt(this.desc.length);
                    int i = 0;
                    while (i < this.desc.length) {
                        writor.writeUTF(this.desc[i]);
                        ++i;
                    }
                }
                if (iconBuffer == null || iconBuffer.length < 1) {
                    writor.writeInt(0);
                } else {
                    writor.writeInt(iconBuffer.length);
                    ((OutputStream)writor).write(iconBuffer);
                }
                writor.flush();
                bytes = os.toByteArray();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (writor != null) {
                        writor.close();
                        writor = null;
                        os = null;
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (writor != null) {
                    writor.close();
                    writor = null;
                    os = null;
                }
            }
            catch (Exception exception) {}
        }
        return bytes;
    }
}

