/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.textbox;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class AbstractDialog
extends AbstractHomescreenCanvas {
    protected static final int TEXT_ALIGN_LEFT = 20;
    protected static final int TEXT_ALIGN_CENTRE = 17;
    protected static final String BG_PATH = "/bg/update_result_bg.png";
    protected final Font font = Strings.NORMAL_TEXT_FONT;
    protected final int fontHeight = this.font.getHeight();
    protected final int screenWidth = this.getWidth();
    protected final Image bg = Images.createImage("/bg/update_result_bg.png");
    protected final int bgX = (this.screenWidth - this.bg.getWidth()) / 2;
    protected final int bgHeight = this.bg.getHeight();
    protected final int bgY = (this.getHeight() - this.bgHeight) / 2;
    protected int messageX;
    protected int messageY;
    private String message;

    public AbstractDialog() {
        this.init();
    }

    protected void init() {
        this.messageY = this.bgY + (this.bg.getHeight() - this.fontHeight) / 2;
    }

    public void paint(Graphics g) {
        this.drawBackground(g);
        if (this.message != null && !this.message.equals("")) {
            this.drawResult(g);
        }
    }

    protected void drawBackground(Graphics g) {
        g.drawImage(this.bg, this.bgX, this.bgY, 20);
    }

    private void drawResult(Graphics g) {
        g.setFont(this.font);
        g.setColor(3488575);
        g.drawString(this.message, this.messageX, this.messageY, 20);
    }

    public void setMessage(String message) {
        this.message = message;
        this.messageX = this.bgX + (this.bg.getWidth() - this.font.stringWidth(message)) / 2;
        this.repaint();
    }

    public void show(Display display) {
        display.setCurrent((Displayable)this);
    }
}

