/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.textbox;

import com.sonyericsson.tvm.log.Log;
import com.sonyericsson.tvm.ui.IBaseMIDlet;
import com.sonyericsson.tvm.ui.textbox.AbstractDialog;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class MessageDialog
extends AbstractDialog
implements CommandListener {
    private CancelThread cancelthread;
    private long timeout;
    private Command okCommand;
    protected IBaseMIDlet midlet;

    public MessageDialog(String result, IBaseMIDlet changable, String buttonLabel, int timeout) {
        this.setMessage(result);
        this.midlet = changable;
        this.setTimeout(timeout);
        this.init();
        this.okCommand = new Command(buttonLabel, 4, 0);
        this.addCommand(this.okCommand);
        this.setCommandListener(this);
    }

    public MessageDialog(String result, IBaseMIDlet changable, int timeout) {
        this(result, changable, "OK", timeout);
    }

    protected void showNotify() {
        this.cancelthread = null;
        if (this.timeout > 0L) {
            this.cancelthread = new CancelThread();
            this.cancelthread.start();
            Log.info("success message dialog starting!");
        }
        super.showNotify();
    }

    protected void hideNotify() {
        if (this.cancelthread != null) {
            this.cancelthread.interrupt();
            this.cancelthread = null;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (this.okCommand.equals(c)) {
            if (this.cancelthread != null) {
                this.cancelthread.interrupt();
                this.cancelthread = null;
            }
            this.midlet.show();
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    private final class CancelThread
    extends Thread {
        private CancelThread() {
        }

        public void run() {
            try {
                Thread.sleep(MessageDialog.this.timeout);
                MessageDialog.this.midlet.show();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

