/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.textbox;

import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ProgressMsgDlg
extends AbstractHomescreenCanvas {
    private static final int STYLE_IMAGE = 20;
    private static final int STYLE_TEXT = 17;
    private String lable = "Refreshing...";
    private Image bgImage;
    private Image progressBgImage;
    private Image progressFgImage;
    private Font lableFont;
    private int bgX;
    private int bgY;
    private int progress = 0;
    private int progressBgX;
    private int progressBgY;
    private int progressFgY;
    private int progressFgInmageW;
    private int progressBgImageW;
    private int progressFgX;
    private int lableX;
    private int lableY;
    private int step;
    private int maxValue;

    public ProgressMsgDlg(int maxValue) {
        this.init();
        this.setMaxValue(maxValue);
    }

    protected void paint(Graphics g) {
        this.drawDialog(g);
    }

    private void drawDialog(Graphics g) {
        g.drawImage(this.bgImage, this.bgX, this.bgY, 20);
        this.drawLable(g);
        this.drawProgressbg(g);
        if (this.progress > 0) {
            this.drawProgress(g);
        }
    }

    private void drawProgressbg(Graphics g) {
        g.drawImage(this.progressBgImage, this.progressBgX, this.progressBgY, 20);
    }

    private void drawProgress(Graphics g) {
        int i = 0;
        while (i < this.progress) {
            this.progressFgX = this.progressBgX + this.progressFgInmageW * i;
            g.drawImage(this.progressFgImage, this.progressFgX, this.progressFgY, 20);
            ++i;
        }
    }

    private void drawLable(Graphics g) {
        g.setFont(this.lableFont);
        g.setColor(3488575);
        g.drawString(this.lable, this.getWidth() / 2, this.lableY, 17);
    }

    private void init() {
        try {
            this.bgImage = Image.createImage((String)"/bg/connecting_Server_Background.png");
            this.progressFgImage = Image.createImage((String)"/bg/connecting_Server_Progress_Bar_Foreground_Body.png");
            this.progressBgImage = Image.createImage((String)"/bg/connecting_Server_Progress_Bar_Background.png");
            int bgWidth = this.bgImage.getWidth();
            int bgHeight = this.bgImage.getHeight();
            this.progressFgInmageW = this.progressFgImage.getWidth();
            this.progressBgImageW = this.progressBgImage.getWidth();
            if (this.getWidth() > bgWidth) {
                this.bgX = (this.getWidth() - bgWidth) / 2;
            }
            if (this.getHeight() > bgHeight) {
                this.bgY = (this.getHeight() - bgHeight) / 2;
            }
            this.progressBgX = this.bgX + 7;
            this.progressFgY = this.progressBgY = this.bgY + this.bgImage.getHeight() - 26;
            this.lableFont = Strings.NORMAL_TEXT_FONT;
            int lableW = this.lableFont.stringWidth(this.lable);
            this.lableY = this.bgY + bgHeight - (49 + this.lableFont.getHeight());
            if (bgWidth > lableW) {
                this.lableX = (bgWidth - lableW) / 2;
                this.lableX += this.bgX;
            }
            ++this.progressFgY;
            this.progressFgX = this.progressBgX;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setProgress(int progress) {
        this.progress = progress >= this.maxValue ? this.progressBgImageW : progress * this.step;
        if (this.progressFgX >= this.progressBgImageW - this.progressFgImage.getWidth()) {
            this.progressFgX = this.progressBgX;
        }
        if (this.progressFgX > this.progressBgX) {
            this.progressFgX += this.progressFgImage.getWidth();
        }
        this.repaint(this.progressBgX, this.progressBgY, this.progressBgImageW, this.progressBgImage.getHeight());
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        this.step = maxValue >= this.progressBgImageW ? 1 : this.progressBgImageW / maxValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String getLable() {
        return this.lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }
}

