/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.textbox;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import com.sonyericsson.tvm.ui.textbox.ReminderCallback;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class SelectionDialog
extends AbstractHomescreenCanvas
implements CommandListener {
    protected String[] reminderDesc;
    protected final int remindBgY;
    protected static final int MIDDLE_LINE_MARGIN = 118;
    protected static final int ITEM_DIVIDED_LINE_HEIGTH = 8;
    static final int ITEM_BG_TEXT_HEIGTH = 8;
    protected static final int ITEM_LEFT_MARGIN = 6;
    protected static int width;
    protected static int height;
    protected int startX;
    protected int startY;
    int descX;
    int descY;
    protected int descStartY;
    protected static final int DESC_LINE_SPACE = 2;
    protected static final int REMIND_AGAIN = 0;
    protected static final int NO_REMIND = 1;
    static final int MENU_MARGIN = 3;
    protected static final Font FONT;
    protected static final int fontHeight;
    static final int ALIGN_STYLE = 20;
    protected static final String REMIND_BG_PATH = "/remind/multipleChoice_Background.png";
    protected static final String ITEM_BG_PATH = "/remind/item_Background.png";
    protected String[] mainMenu = new String[2];
    protected int menuIdx;
    protected Display display;
    protected Command selectReminderAction;
    protected static Image remindBg;
    protected static Image itemBg;
    protected int remindBgX;
    protected ReminderCallback callback;

    static {
        FONT = Strings.NORMAL_TEXT_FONT;
        fontHeight = FONT.getHeight();
    }

    public SelectionDialog(Display display, String[] description, String option0, String option1) {
        width = this.getWidth();
        height = this.getHeight();
        remindBg = Images.createImage(REMIND_BG_PATH);
        itemBg = Images.createImage(ITEM_BG_PATH);
        this.remindBgX = (width - remindBg.getWidth()) / 2;
        this.startX = this.remindBgX + 6;
        this.remindBgY = (height - remindBg.getHeight()) / 2;
        this.startY = this.remindBgY + 118 + 8 + (itemBg.getHeight() - fontHeight) / 2;
        this.descStartY = this.remindBgY + (118 - (FONT.getHeight() * 4 + 6)) / 2;
        this.menuIdx = 0;
        this.reminderDesc = description;
        this.mainMenu[0] = option0;
        this.mainMenu[1] = option1;
        this.display = display;
        this.selectReminderAction = new Command("Select", 4, 0);
        this.addCommand(this.selectReminderAction);
        this.setCommandListener(this);
    }

    public void paint(Graphics g) {
        g.setFont(FONT);
        g.drawImage(remindBg, this.remindBgX, this.remindBgY, 20);
        g.setColor(3488575);
        int i = 0;
        while (i < this.reminderDesc.length) {
            this.descX = this.remindBgX + (remindBg.getWidth() - FONT.stringWidth(this.reminderDesc[i])) / 2;
            this.descY = this.descStartY + i * (FONT.getHeight() + 2);
            g.drawString(this.reminderDesc[i], this.descX, this.descY, 20);
            ++i;
        }
        i = 0;
        while (i < this.mainMenu.length) {
            if (i == this.menuIdx) {
                g.drawImage(itemBg, this.remindBgX, this.remindBgY + 118 + 8 + i * itemBg.getHeight(), 20);
            }
            g.drawString(this.mainMenu[i], this.startX, this.startY + i * ((itemBg.getHeight() - fontHeight) / 2 + 8 + fontHeight), 20);
            ++i;
        }
    }

    protected void keyPressed(int code) {
        switch (this.getGameAction(code)) {
            case 1: {
                this.menuIdx = this.menuIdx > 0 ? --this.menuIdx : this.mainMenu.length - 1;
                this.repaint();
                break;
            }
            case 6: {
                this.menuIdx = this.menuIdx < this.mainMenu.length - 1 ? ++this.menuIdx : 0;
                this.repaint();
                break;
            }
        }
    }

    public void reset() {
        this.menuIdx = 0;
    }

    public void show(ReminderCallback callback) {
        this.callback = callback;
        this.display.setCurrent((Displayable)this);
    }

    public abstract /* synthetic */ void commandAction(Command var1, Displayable var2);
}

