/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.ui.textbox;

import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.ui.AbstractHomescreenCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TextMessageDialog
extends AbstractHomescreenCanvas {
    private String title = "";
    private String content = "";
    private final int titleFontHeight = Strings.TITLE_FONT.getHeight();
    private final int contentFontHeight = Strings.CONTENT_FONT.getHeight();
    private static final int ALIGN_STYLE = 17;
    private static final String TEXT_BG_PATH = "/textbox/information_Dialog_Background.png";
    private static final String SCROLL_BAR_BG_PATH = "/textbox/information_Dialog_ScrollBar_Background.png";
    private static final String SCROLL_BAR_HEAD_FG_PATH = "/textbox/information_Dialog_ScrollBar_Head_Foreground.png";
    private static final String SCROLL_BAR_TAIL_FG_PATH = "/textbox/information_Dialog_ScrollBar_Tail_Foreground.png";
    private Image textBg;
    private Image scrollBarBg;
    private Image scrollBarHeadFg;
    private Image scrollBarTailFg;
    private final int screenWidth = this.getWidth();
    private int vCentre;
    private int titleY;
    private int textBackgroundX;
    private int textBackgroundY;
    private static final int CONTENT_LEFT_MARGIN = 10;
    private int firstLine;
    private int lastLine;
    private static final int MAX_LINES = 8;
    private int step = 0;
    private int stepHeight = 1;
    private static final int LINE_SIZE = 24;
    private int lineCount = 0;
    private String[] splitStringlist;
    private int scrollBarBgX;
    private int scrollBarBgY;
    private int scrollBarTailFgY;
    private static final int SCROLL_BAR_BOTTOM_MARGIN = 10;
    private static final int SCROLL_BAR_RIGHT_MARGIN = 6;
    private static final int SCROLL_BAR_TITLE_GAP = 15;
    private int srollBarHeight;
    private int textY;

    public void show(Display display) {
        this.init();
        display.setCurrent((Displayable)this);
    }

    public void init() {
        this.textBg = Images.createImage(TEXT_BG_PATH);
        this.scrollBarBg = Images.createImage(SCROLL_BAR_BG_PATH);
        this.scrollBarHeadFg = Images.createImage(SCROLL_BAR_HEAD_FG_PATH);
        this.scrollBarTailFg = Images.createImage(SCROLL_BAR_TAIL_FG_PATH);
        this.textBackgroundX = (this.screenWidth - this.textBg.getWidth()) / 2;
        this.textBackgroundY = (this.getHeight() - this.textBg.getHeight()) / 2;
        this.vCentre = this.screenWidth / 2;
        if (this.title != null && !this.title.equals("")) {
            this.titleY = this.textBackgroundY + this.textBg.getHeight() - 10 - this.scrollBarBg.getHeight() - 15 - this.titleFontHeight;
        }
        if (this.content != null && !this.content.equals("")) {
            this.splitStringlist = Strings.splitString(this.content, 24);
            this.lineCount = this.splitStringlist.length;
        }
        this.scrollBarBgX = this.screenWidth - (this.screenWidth - this.textBg.getWidth()) / 2 - 6 - this.scrollBarBg.getWidth();
        this.scrollBarBgY = this.textBackgroundY + this.textBg.getHeight() - (10 + this.scrollBarBg.getHeight());
        this.scrollBarTailFgY = this.scrollBarBgY + (this.scrollBarBg.getHeight() - this.scrollBarTailFg.getHeight());
        if (this.content != null && !this.content.equals("") && this.lineCount > 8) {
            this.srollBarHeight = this.scrollBarBg.getHeight() - this.scrollBarHeadFg.getHeight() - this.scrollBarTailFg.getHeight() - this.stepHeight * (this.lineCount - 8);
        }
        int lines = this.lineCount > 8 ? 8 : this.lineCount;
        this.textY = (this.getHeight() - this.contentFontHeight * lines) / 2 - 20;
    }

    public void paint(Graphics g) {
        g.drawImage(this.textBg, this.vCentre, this.textBackgroundY, 17);
        this.drawTextTitle(g);
        this.drawTextContent(g);
        if (this.lineCount > 8) {
            this.drawScrollBar(g);
        }
    }

    private void drawTextTitle(Graphics g) {
        g.setFont(Strings.TITLE_FONT);
        g.setColor(3488575);
        if (this.title != null && !this.title.equals("")) {
            g.drawString(this.title, this.vCentre, this.titleY, 17);
        }
    }

    private void drawTextContent(Graphics g) {
        g.setFont(Strings.NORMAL_TEXT_FONT);
        if (this.splitStringlist != null && this.splitStringlist.length > 0) {
            if (this.lineCount <= 8) {
                this.firstLine = 0;
                this.lastLine = this.lineCount;
            } else {
                this.firstLine = this.step;
                this.lastLine = 8 + this.step;
            }
            int i = this.firstLine;
            while (i < this.lastLine) {
                String str = this.splitStringlist[i];
                if (i < this.lastLine - 1) {
                    g.drawString(str, this.vCentre, (i - this.step) * this.contentFontHeight + this.textY, 17);
                } else {
                    g.drawString(str, this.vCentre, (i - this.step) * this.contentFontHeight + this.textY + 10, 17);
                }
                ++i;
            }
        }
    }

    private void drawScrollBar(Graphics g) {
        g.drawImage(this.scrollBarBg, this.scrollBarBgX, this.scrollBarBgY, 17);
        g.drawImage(this.scrollBarHeadFg, this.scrollBarBgX, this.scrollBarBgY, 17);
        g.drawImage(this.scrollBarTailFg, this.scrollBarBgX, this.scrollBarTailFgY, 17);
        if (this.content != null && !this.content.equals("") && this.lineCount > 8) {
            int scrollBarBodyForegroundY = this.scrollBarBgY + this.scrollBarHeadFg.getHeight();
            g.setColor(7978800);
            g.fillRect(this.scrollBarBgX + 1, scrollBarBodyForegroundY + this.step, this.scrollBarBg.getWidth() - 2, this.srollBarHeight);
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.scrollUp();
                break;
            }
            case 6: {
                this.scrollDown();
                break;
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    private void scrollDown() {
        if (this.step < this.lineCount - 8) {
            ++this.step;
            this.repaint();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setSplitStringlist(String[] content) {
        this.splitStringlist = content;
        this.lineCount = this.splitStringlist.length;
    }

    private void scrollUp() {
        if (this.step != 0) {
            --this.step;
            this.repaint();
        }
    }

    public void reset() {
        this.step = 0;
    }
}

