/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.update;

import com.sonyericsson.starhub.protocol.bean.ChannelInfo;
import com.sonyericsson.tvm.exception.UpdateFailedException;
import com.sonyericsson.tvm.mitv.MiTVStub;
import com.sonyericsson.tvm.mitv.MiTVStubImpl;
import com.sonyericsson.tvm.mitv.exception.MiTvException;
import com.sonyericsson.tvm.res.Images;
import com.sonyericsson.tvm.rms.RecordManager;
import com.sonyericsson.tvm.ui.IBaseMIDlet;
import com.sonyericsson.tvm.ui.item.Channel;
import com.sonyericsson.tvm.ui.item.ChannelHost;
import com.sonyericsson.tvm.ui.textbox.ProgressMsgDlg;
import javax.microedition.lcdui.Image;

public class UpdateManager {
    private static final int PROGRESS_READ_RSS = 4;
    private static final int MAX_CHANNEL = 30;
    private static UpdateManager instance = new UpdateManager();
    private ChannelHost host;
    private MiTVStub stub;
    private IBaseMIDlet midlet;
    public boolean cancel;

    public static UpdateManager getInstance() {
        return instance;
    }

    public void update(String url, ProgressMsgDlg progress) throws UpdateFailedException {
        int size;
        if (this.host == null) {
            this.host = ChannelHost.getInstance();
        }
        if (this.cancel) {
            return;
        }
        if (this.stub == null) {
            this.stub = MiTVStubImpl.getInstance(url);
        }
        if (this.cancel) {
            return;
        }
        ChannelInfo[] srcChannels = null;
        try {
            srcChannels = this.stub.getAllChannels();
        }
        catch (MiTvException e) {
            throw new UpdateFailedException(e.getMessage());
        }
        if (this.cancel) {
            return;
        }
        if (srcChannels == null || srcChannels.length == 0) {
            throw new UpdateFailedException();
        }
        this.setProgress(progress, 4);
        int srcSize = srcChannels.length;
        int n = size = srcSize < 30 ? srcSize : 30;
        if (srcChannels != null && srcSize > 0) {
            Channel[] channels = new Channel[size];
            int length = this.host.getChannels().length < size ? this.host.getChannels().length : size;
            System.arraycopy(this.host.getChannels(), 0, channels, 0, length);
            int distance = 6;
            try {
                RecordManager.openChannelStore();
                int i = 0;
                while (i < size) {
                    ChannelInfo channelInfo = srcChannels[i];
                    if (channels[i] == null) {
                        channels[i] = new Channel();
                    }
                    Channel channel = channels[i];
                    this.setProgress(progress, 4 + distance * i / size);
                    if (this.cancel) {
                        return;
                    }
                    this.updateChannel(i + 1, channelInfo, channel);
                    ++i;
                }
            }
            finally {
                RecordManager.closeChannelStore();
            }
            if (!this.cancel) {
                this.host.resetChannel(channels);
            }
        }
    }

    private void setProgress(ProgressMsgDlg progressDialog, int progress) {
        if (progressDialog != null) {
            progressDialog.setProgress(progress);
        }
    }

    private void updateChannel(int index, ChannelInfo channelInfo, Channel channel) {
        byte[] buffer;
        block7: {
            String id = channelInfo.id;
            String channelDesc = this.midlet.getChannelDesc(id);
            if (channelDesc != null) {
                channel.setDesc(channelDesc);
            } else {
                channel.setDesc(channelInfo.name);
            }
            channel.setTitle(id);
            channel.accessAllowed = channelInfo.accessAllowed;
            String iconUrl = channelInfo.logo;
            buffer = Images.getOnlineBuffer(iconUrl);
            Image image = null;
            if (buffer != null && buffer.length > 0) {
                try {
                    image = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                    if (image != null) {
                        channel.setIcon(image);
                        image = null;
                        break block7;
                    }
                    buffer = RecordManager.getChannelImage(index);
                }
                catch (Exception e) {
                    buffer = RecordManager.getChannelImage(index);
                }
            } else {
                buffer = RecordManager.getChannelImage(index);
            }
        }
        RecordManager.setChannel(index, channel.serialize(buffer));
        buffer = null;
    }

    public void setMidlet(IBaseMIDlet midlet) {
        this.midlet = midlet;
    }
}

