/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.tvm.upgrade;

import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.tvm.log.Log;
import com.sonyericsson.tvm.res.Strings;
import com.sonyericsson.tvm.rms.RecordManager;
import com.sonyericsson.tvm.ui.textbox.ProgressMsgDlg;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class UpgradeManager {
    private static final int MAX_CONNECTION = 5;
    private static final String JAR_EXTENTION = "jar";
    private static final int REDIRECT_CODE = 302;
    private static String versionUrl;

    public UpgradeManager(String baseUrl, String version) {
        versionUrl = this.createUrl(baseUrl, version);
    }

    private String createUrl(String baseUrl, String version) {
        StringBuffer sb = new StringBuffer();
        sb.append(baseUrl).append("?model=");
        String modeName = Strings.MODE_NAME.indexOf(47) != -1 ? Strings.MODE_NAME.substring(0, Strings.MODE_NAME.indexOf(47)) : Strings.MODE_NAME;
        sb.append(modeName);
        sb.append("&plt=").append(Strings.JAVA_VERSION);
        sb.append("&ver=").append(version);
        String url = sb.toString();
        Log.debug(url);
        return url;
    }

    private String getUpgradeUrl() {
        String jadUrl;
        block16: {
            HttpConnection connection = null;
            jadUrl = null;
            try {
                try {
                    Log.debug(versionUrl);
                    int responseCode = 0;
                    int i = 0;
                    while (responseCode != 302 && i < 5) {
                        connection = (HttpConnection)Connector.open((String)versionUrl);
                        responseCode = connection.getResponseCode();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++i;
                    }
                    Log.debug(String.valueOf(responseCode));
                    if (responseCode == 302) {
                        jadUrl = connection.getHeaderField("Location");
                        Log.debug("actual url" + jadUrl);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (connection == null) break block16;
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return jadUrl;
    }

    public void checkUpgrade() {
        String url = this.getUpgradeUrl();
        Log.debug("check upgrade" + url);
        if (url != null) {
            RecordManager.setUpgradeUrl(url);
        }
    }

    public void upgrade(ProgressMsgDlg progress) throws InterruptedException {
        this.setProgress(progress, 1);
        Thread.sleep(100L);
        String jadUrl = RecordManager.getUpgradeUrl();
        Log.debug(jadUrl);
        if (jadUrl == null) {
            return;
        }
        this.setProgress(progress, 3);
        int responseCode = 0;
        int i = 0;
        try {
            while (responseCode != 302 && i < 5) {
                HttpConnection connection = (HttpConnection)Connector.open((String)versionUrl);
                responseCode = connection.getResponseCode();
                Thread.sleep(100L);
                ++i;
            }
            if (responseCode != 302) {
                return;
            }
            this.setProgress(progress, 7);
            Thread.sleep(100L);
            ApplicationManager manager = ApplicationManager.getApplicationManager();
            String jarUrl = jadUrl.substring(0, jadUrl.indexOf("jad")).concat(JAR_EXTENTION);
            Log.debug(jarUrl);
            Thread.sleep(200L);
            this.setProgress(progress, 10);
            manager.installApplication(jadUrl, jarUrl, false);
            RecordManager.deleteUpgradeUrl();
        }
        catch (IOException e) {
            Log.error(e.toString());
        }
    }

    private void setProgress(ProgressMsgDlg progress, int value) {
        if (progress != null) {
            progress.setProgress(value);
        }
    }
}

