/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class BSongInfo {
    public static final byte MAX_BASE_VENUES = 2;
    public static final byte NUM_BASE_VENUES = 3;
    public String[] venues = null;
    public int numVenues = 0;
    public int num = 0;
    public BSongData[] song = null;
    public int curVenue = 0;
    public int curPlayer = 0;
    public int curSongIndex = 0;
    public int curGuitar = 0;
    public int curLevel = 0;
    public byte[] achievement = new byte[15];
    public byte[] setAchieve = new byte[15];
    public static final byte A_TONE_DEAF = 0;
    public static final byte A_SOLO_CAREER = 1;
    public static final byte A_EASY_RIDER = 2;
    public static final byte A_MEDIUM_RARE = 3;
    public static final byte A_RIGHT_HAND = 4;
    public static final byte A_BRONZE_STREAKER = 5;
    public static final byte A_SILVER_STREAKER = 6;
    public static final byte A_GOLD_STREAKER = 7;
    public static final byte A_FIRST_BIG_SCORE = 8;
    public static final byte A_THATS_IMPRESSIVE = 9;
    public static final byte A_AXE_GRINDER = 10;
    public static final byte A_ROCK_GURU = 11;
    public static final byte A_GUITAR_HERO = 12;
    public static final byte A_PERFECTIONIST = 13;
    public static final byte A_AXE_COLLECTOR = 14;
    public static final byte ACHIEVE_NUM = 15;

    public boolean load(String string, BDate bDate) {
        boolean bl = false;
        try {
            bl = this.load(new DataInputStream(this.getClass().getResourceAsStream(string)), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(DataInputStream dataInputStream, BDate bDate) {
        if (dataInputStream == null) {
            return false;
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = null;
        byte[] byArray = new byte[1];
        int n = -1;
        int n2 = -1;
        int n3 = this.num;
        try {
            while (dataInputStream.read(byArray) != -1) {
                char c = (char)byArray[0];
                if (c == '\u0000') continue;
                string = string + c;
            }
            if (string.length() == 0) {
                boolean bl = false;
                return bl;
            }
            stringArray = ST.split(string, '\r');
            if (stringArray == null) {
                stringArray = ST.split(string, '\n');
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2 = ST.split(stringArray[i], '|');
                    if (stringArray2 != null) {
                        if (stringArray2.length != 2) continue;
                        if (bDate != null) {
                            n = -1;
                            if (!bDate.verified(stringArray2[0])) continue;
                            n = this.addVenue(stringArray2[1]);
                            continue;
                        }
                        n = this.addVenue(stringArray2[1]);
                        continue;
                    }
                    stringArray2 = ST.split(stringArray[i], ',');
                    if (stringArray2 == null || n == -1 || stringArray2.length != 4) continue;
                    n2 = this.addSongData(n, stringArray2[0], stringArray2[1], stringArray2[2], Integer.parseInt(stringArray2[3]));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                stringArray = null;
                System.gc();
                stringArray2 = null;
                System.gc();
                byArray = null;
                System.gc();
                dataInputStream.close();
                dataInputStream = null;
                System.gc();
            }
            catch (Exception exception) {}
        }
        return this.num > n3;
    }

    public int addVenue(String string) {
        int n = this.venueExists(string);
        if (n != -1) {
            return n;
        }
        int n2 = this.numVenues++;
        String[] stringArray = null;
        if (this.venues != null) {
            stringArray = new String[this.venues.length];
            System.arraycopy(this.venues, 0, stringArray, 0, this.venues.length);
        }
        this.venues = new String[this.numVenues];
        if (stringArray != null) {
            System.arraycopy(stringArray, 0, this.venues, 0, stringArray.length);
        }
        this.venues[n2] = string;
        if (stringArray != null) {
            stringArray = null;
            System.gc();
        }
        return n2;
    }

    public int addSongData(int n, String string, String string2, String string3, int n2) {
        if (n < 0 || n > this.numVenues - 1) {
            return -1;
        }
        if (this.songExists(n, string, string2)) {
            return -1;
        }
        int n3 = this.numSongs(n);
        int n4 = this.num++;
        BSongData[] bSongDataArray = null;
        if (this.song != null) {
            bSongDataArray = new BSongData[this.song.length];
            System.arraycopy(this.song, 0, bSongDataArray, 0, this.song.length);
        }
        this.song = new BSongData[this.num];
        if (bSongDataArray != null) {
            System.arraycopy(bSongDataArray, 0, this.song, 0, bSongDataArray.length);
        }
        this.song[n4] = new BSongData(n, n3, string, string2, string3, n2);
        if (bSongDataArray != null) {
            bSongDataArray = null;
            System.gc();
        }
        return n4;
    }

    private int numSongs(int n) {
        int n2 = 0;
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue != n) continue;
            ++n2;
        }
        return n2;
    }

    private boolean songExists(int n, String string, String string2) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue != n || !this.song[i].artist.equals(string) || !this.song[i].title.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean songCompleted(int n) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].stars[n] < 3) continue;
            return true;
        }
        return false;
    }

    private int venueExists(String string) {
        for (int i = 0; i < this.numVenues; ++i) {
            if (!this.venues[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int venuesCompleted(int n) {
        if (n == -1) {
            return this.venuesCompleted();
        }
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.venueComplete(i, n)) continue;
            ++n2;
        }
        return n2;
    }

    public int venuesCompleted() {
        int n = 0;
        block0: for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.venueComplete(i, j)) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public boolean venueComplete(int n, int n2) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue != n || this.song[i].stars[n2] >= 3) continue;
            return false;
        }
        return true;
    }

    public int getNumSongs(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < this.num; ++n4) {
            if (this.song[n4].venue != n) continue;
            if (n2 == -1) {
                for (n5 = 0; n5 < 3; ++n5) {
                    if (this.song[n4].score[n5] <= 0) continue;
                    ++n6;
                    break;
                }
            } else if (this.song[n4].score[n2] > 0) {
                ++n6;
            }
            ++n3;
        }
        if (n6 < n3 - 1) {
            --n3;
        }
        return n3;
    }

    public int getNumSongs(int n) {
        int n2 = 0;
        int n3 = 0;
        for (n3 = 0; n3 < this.num; ++n3) {
            if (this.song[n3].venue != n) continue;
            ++n2;
        }
        return n2;
    }

    private BSongData getSong(int n, int n2) {
        for (int i = 0; i < this.num; ++i) {
            if (!this.song[i].check(n, n2)) continue;
            return this.song[i];
        }
        return new BSongData();
    }

    public String getTitle(int n, int n2) {
        return this.getSong((int)n, (int)n2).title;
    }

    public String getArtist(int n, int n2) {
        return this.getSong((int)n, (int)n2).artist;
    }

    public String getDate(int n, int n2) {
        return Integer.toString(this.getSong((int)n, (int)n2).date);
    }

    public String getTitleDate(int n, int n2) {
        return this.getTitle(n, n2) + "\n" + " (" + this.getDate(n, n2) + ")";
    }

    public String getFile(int n, int n2) {
        String string = this.getSong((int)n, (int)n2).file;
        if (string == null) {
            return null;
        }
        string = string + ".dat";
        if (n > 2) {
            String string2 = ST.appProperty("Update-URL");
            if (string2 == null) {
                return null;
            }
            string = string2 + string + ".gz";
        }
        return string;
    }

    public int getScore(int n, int n2, int n3) {
        if (n3 == -1) {
            int n4 = 0;
            for (int i = 0; i < 3 && (n4 = this.getSong(n, n2).getScore(i)) <= 0; ++i) {
            }
            return n4;
        }
        return this.getSong(n, n2).getScore(n3);
    }

    public int getStars(int n, int n2, int n3) {
        return this.getSong(n, n2).getStars(n3);
    }

    public int getCareerScore() {
        int n = 0;
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue >= 3) continue;
            n += this.song[i].getTotalScore();
        }
        return n;
    }

    public int getSongIndex(int n, String string) {
        String string2 = null;
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue != n || (string2 = this.song[i].title).length() > string.length() || !string.substring(0, string2.length()).equals(string2)) continue;
            return this.song[i].index;
        }
        return 0;
    }

    public void setScore(int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.num; ++i) {
            if (!this.song[i].check(n, n2) || n4 <= this.song[i].score[n3]) continue;
            this.song[i].score[n3] = n4;
            this.song[i].stars[n3] = (byte)n5;
            break;
        }
    }

    public void cheat(int n) {
        int n2 = 0;
        for (n2 = 0; n2 < 15; ++n2) {
            this.achievement[n2] = 1;
        }
        if (this.num > 0) {
            for (n2 = 0; n2 < this.num; ++n2) {
                this.song[n2].cheat(n);
            }
        }
    }

    public void setData(DataOutputStream dataOutputStream, boolean bl) {
        if (dataOutputStream == null) {
            return;
        }
        int n = 0;
        try {
            if (bl) {
                for (n = 0; n < 15; ++n) {
                    this.achievement[n] = 0;
                }
            }
            for (n = 0; n < 15; ++n) {
                dataOutputStream.writeByte(this.achievement[n]);
            }
            dataOutputStream.writeInt(this.numVenues);
            if (this.numVenues > 0) {
                for (n = 0; n < this.numVenues; ++n) {
                    dataOutputStream.writeUTF(this.venues[n]);
                }
            }
            dataOutputStream.writeInt(this.num);
            if (this.num > 0) {
                for (n = 0; n < this.num; ++n) {
                    this.song[n].setData(dataOutputStream, bl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void getData(DataInputStream dataInputStream) {
        if (dataInputStream == null) {
            return;
        }
        int n = 0;
        try {
            if (this.achievement != null) {
                this.achievement = null;
                System.gc();
            }
            this.achievement = new byte[15];
            for (n = 0; n < 15; ++n) {
                this.achievement[n] = dataInputStream.readByte();
            }
            this.numVenues = dataInputStream.readInt();
            if (this.numVenues > 0) {
                if (this.venues != null) {
                    this.venues = null;
                    System.gc();
                }
                this.venues = new String[this.numVenues];
                for (n = 0; n < this.numVenues; ++n) {
                    this.venues[n] = dataInputStream.readUTF();
                }
            }
            this.num = dataInputStream.readInt();
            if (this.num > 0) {
                if (this.song != null) {
                    this.song = null;
                    System.gc();
                }
                this.song = new BSongData[this.num];
                for (n = 0; n < this.num; ++n) {
                    this.song[n] = new BSongData();
                    this.song[n].getData(dataInputStream);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean completedAllSongs(int n) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue >= 3 || this.song[i].getScore(n) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean setCurrentScore(int n, int n2) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue != this.curVenue || this.song[i].index != this.curSongIndex) continue;
            if (n > this.song[i].score[this.curLevel]) {
                this.song[i].score[this.curLevel] = n;
                this.song[i].stars[this.curLevel] = (byte)n2;
                return true;
            }
            return false;
        }
        return false;
    }

    public String getVenueTitle(int n) {
        if (this.venues == null) {
            return "No Title";
        }
        if (n >= 0 && n < this.numVenues) {
            return this.venues[n];
        }
        return "No Title";
    }

    public String currentVenueTitle() {
        return this.getVenueTitle(this.curVenue);
    }

    public String currentFamousTitle() {
        return GHero.can.songInfo.getTitle(this.curVenue, this.curSongIndex) + "\n" + BCanvas.bab(131) + "\n" + GHero.can.songInfo.getArtist(this.curVenue, this.curSongIndex);
    }

    public boolean completedFiveStars(int n) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue >= 3 || this.song[i].stars[n] >= 5) continue;
            return false;
        }
        return true;
    }

    public boolean completedFourStars(int n) {
        for (int i = 0; i < this.num; ++i) {
            if (this.song[i].venue >= 3 || this.song[i].stars[n] >= 4) continue;
            return false;
        }
        return true;
    }

    public boolean hasAchievement(int n) {
        if (n < 0 || n > 14) {
            return false;
        }
        return this.achievement[n] != 0;
    }

    public String updateAchievements(int n, int n2, int n3) {
        if (this.curVenue > 2) {
            return null;
        }
        int n4 = 0;
        for (n4 = 0; n4 < 15; ++n4) {
            this.setAchieve[n4] = 0;
        }
        if (this.achievement[0] == 0 && !BBuild.HAS_SOUND && this.curLevel == 2) {
            this.setAchieve[0] = 1;
        }
        boolean bl = false;
        if (this.achievement[5] == 0 && n2 > 49) {
            this.setAchieve[5] = 1;
        }
        if (this.achievement[6] == 0 && n2 > 99) {
            this.setAchieve[6] = 1;
        }
        if (this.achievement[7] == 0 && n2 > 199) {
            this.setAchieve[7] = 1;
        }
        if (this.achievement[8] == 0 && n > 99999) {
            this.setAchieve[8] = 1;
        }
        if (this.achievement[9] == 0 && n > 149999) {
            this.setAchieve[9] = 1;
        }
        if (this.achievement[13] == 0 && n3 == 100) {
            this.setAchieve[13] = 1;
        }
        String string = "";
        for (n4 = 0; n4 < 15; ++n4) {
            if (this.setAchieve[n4] != 1) continue;
            string = string + BCanvas.bab(77) + " " + BSongInfo.getAchievementInfo(n4, true) + " " + BCanvas.bab(78) + "\n\n";
            this.achievement[n4] = 1;
        }
        string = string.length() > 0 ? string + BCanvas.bab(76) : null;
        return string;
    }

    public static String getAchievementInfo(int n, boolean bl) {
        if (n > 14) {
            return null;
        }
        if (bl) {
            return BCanvas.bab(93 + n);
        }
        return BCanvas.bab(108 + n);
    }
}

