/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class MenuItem {
    public static final byte SELECT = 0;
    public static final byte CHECK = 1;
    public static final byte TEXT = 2;
    public int index = 0;
    public int menuIndex = 0;
    public String text = null;
    public String altText = null;
    public String tempText = null;
    private int textSwapDelay = 0;
    private long nextSwap = 0L;
    public boolean selected = false;
    public boolean selectable = true;
    public boolean checked = false;
    public boolean enabled = true;
    public byte type = 0;
    public int lines = 0;
    public int x = 0;
    public int height = 0;
    public int align = 1;
    public int tag = -1;
    public int tag2 = -1;
    public boolean useShake = false;
    public int enabledIndex = -1;
    public static int pointerWidth = 0;
    private static Image pointer = null;
    private static long tick = 0L;
    private static boolean flip = false;
    private static int shake = 0;

    public MenuItem(Menu menu, String string, int n, int n2, int n3, int n4, boolean bl) {
        this(menu, string, n, n2, n3, n4, bl, true);
    }

    public MenuItem(Menu menu, String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.index = n;
        this.menuIndex = n2;
        this.type = (byte)n3;
        this.align = n4;
        this.enabled = bl;
        this.x = n4 == 0 ? menu.textArea.x : (n4 == 2 ? menu.textArea.x + menu.textArea.w : menu.textArea.x + menu.textArea.w / 2);
        if (bl2) {
            this.wrapText(string, menu.can.font, menu.textArea);
        } else {
            this.text = string;
            this.lines = 1;
        }
        this.height = this.lines * menu.can.getFontHeight() + this.lines * menu.can.getFontVSpacing();
    }

    public void setAltText(String string, int n) {
        this.altText = string;
        this.textSwapDelay = n;
    }

    private void wrapText(String string, BFont bFont, BFrame bFrame) {
        this.text = bFont.WrapText(string, bFrame.w);
        this.lines = bFont.WrapLines;
    }

    public void render(BCanvas bCanvas, int n) {
        if (bCanvas == null) {
            return;
        }
        String string = "";
        if (this.type == 1) {
            string = this.checked ? " " + BCanvas.bab(129) : " " + BCanvas.bab(130);
        }
        if (this.useShake && this.selected) {
            bCanvas.drawText(this.text + string, this.x + shake, n, this.align);
        } else {
            if (this.altText != null && this.nextSwap < System.currentTimeMillis()) {
                this.nextSwap = System.currentTimeMillis() + (long)this.textSwapDelay;
                this.tempText = this.text;
                this.text = this.altText;
                this.altText = this.tempText;
            }
            bCanvas.drawText(this.text + string, this.x, n, this.align);
        }
        this.renderPointer(bCanvas);
    }

    public void renderPointer(BCanvas bCanvas) {
        if (this.selectable && this.selected) {
            int n = 0;
            if (this.lines > 1) {
                n = -this.height / 2;
            }
            MenuItem.renderPointer(bCanvas, n);
        }
    }

    public void toggleCheck() {
        this.checked = !this.checked;
    }

    public int getHeight() {
        return this.height;
    }

    public static void initPointer(String string) {
        pointer = Use.loadImage(string);
    }

    private static void renderPointer(BCanvas bCanvas, int n) {
        if (pointer == null) {
            return;
        }
        if (tick == 0L) {
            tick = BBuild.tickCount;
        }
        if (BBuild.tickCount > tick) {
            tick = BBuild.tickCount + 300L;
            boolean bl = flip = !flip;
            shake = flip ? ++shake : --shake;
        }
        bCanvas.renderImage(pointer, BFont.lastPosX - pointer.getWidth() - 4 + shake, BFont.lastPosY - pointer.getHeight() / 2 + n);
    }

    public void setEnabledIndex(int n) {
        this.enabledIndex = n;
    }

    public int getEnabledIndex() {
        return this.enabledIndex;
    }
}

